/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.AbstractCacheCleanup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedSizeOldestCacheCleanup
extends AbstractCacheCleanup {
    private static final Logger LOGGER = LoggerFactory.getLogger(FixedSizeOldestCacheCleanup.class);
    private static final Comparator<File> NEWEST_FIRST = Ordering.natural().onResultOf((Function)new Function<File, Comparable<Long>>(){

        public Comparable<Long> apply(File input) {
            return input.lastModified();
        }
    }).reverse();
    private final long targetSizeInMB;

    public FixedSizeOldestCacheCleanup(long targetSizeInMB) {
        this.targetSizeInMB = targetSizeInMB;
    }

    @Override
    protected List<File> findFilesToDelete(PersistentCache persistentCache, File[] filesEligibleForCleanup) {
        Arrays.sort(filesEligibleForCleanup, NEWEST_FIRST);
        long totalSize = 0L;
        long targetSize = this.targetSizeInMB * 1024L * 1024L;
        ArrayList filesForDeletion = Lists.newArrayList();
        for (File file : filesEligibleForCleanup) {
            long size = file.length();
            if ((totalSize += size) <= targetSize) continue;
            filesForDeletion.add(file);
        }
        LOGGER.info("{} consuming {} (target: {} MB).", new Object[]{persistentCache, FileUtils.byteCountToDisplaySize((long)totalSize), this.targetSizeInMB});
        return filesForDeletion;
    }
}

