/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import groovy.lang.Closure;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.internal.AbstractTask;
import org.gradle.api.internal.ClassGenerator;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.reflect.ObjectInstantiationException;
import org.gradle.api.tasks.TaskInstantiationException;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.GUtil;
import org.gradle.util.NameValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskFactory
implements ITaskFactory {
    private static final Set<String> VALID_TASK_ARGUMENTS = ImmutableSet.of((Object)"action", (Object)"dependsOn", (Object)"description", (Object)"group", (Object)"name", (Object)"overwrite", (Object[])new String[]{"type"});
    private static final Set<String> MANDATORY_TASK_ARGUMENTS = ImmutableSet.of((Object)"name", (Object)"type");
    private final ClassGenerator generator;
    private final ProjectInternal project;
    private final Instantiator instantiator;

    public TaskFactory(ClassGenerator generator) {
        this(generator, null, null);
    }

    TaskFactory(ClassGenerator generator, ProjectInternal project, Instantiator instantiator) {
        this.generator = generator;
        this.project = project;
        this.instantiator = instantiator;
    }

    @Override
    public ITaskFactory createChild(ProjectInternal project, Instantiator instantiator) {
        return new TaskFactory(this.generator, project, instantiator);
    }

    @Override
    public TaskInternal createTask(Map<String, ?> args) {
        Object action;
        Object group;
        Object description;
        Map<String, ?> actualArgs = this.checkTaskArgsAndCreateDefaultValues(args);
        String name = actualArgs.get("name").toString();
        if (!GUtil.isTrue((Object)name)) {
            throw new InvalidUserDataException("The task name must be provided.");
        }
        Class type = (Class)actualArgs.get("type");
        Object task = this.create(name, type);
        Object dependsOnTasks = actualArgs.get("dependsOn");
        if (dependsOnTasks != null) {
            task.dependsOn(new Object[]{dependsOnTasks});
        }
        if ((description = actualArgs.get("description")) != null) {
            task.setDescription(description.toString());
        }
        if ((group = actualArgs.get("group")) != null) {
            task.setGroup(group.toString());
        }
        if ((action = actualArgs.get("action")) instanceof Action) {
            Action taskAction = (Action)action;
            task.doFirst(taskAction);
        } else if (action != null) {
            Closure closure = (Closure)action;
            task.doFirst(closure);
        }
        return task;
    }

    public <S extends TaskInternal> S create(String name, final Class<S> type) {
        if (!Task.class.isAssignableFrom(type)) {
            throw new InvalidUserDataException(String.format("Cannot create task of type '%s' as it does not implement the Task interface.", type.getSimpleName()));
        }
        NameValidator.validate(name, "task name", "");
        final Class<DefaultTask> generatedType = type.isAssignableFrom(DefaultTask.class) ? this.generator.generate(DefaultTask.class) : this.generator.generate(type);
        return (S)((TaskInternal)type.cast(AbstractTask.injectIntoNewInstance(this.project, name, type, new Callable<Task>(){

            @Override
            public Task call() throws Exception {
                try {
                    return (Task)TaskFactory.this.instantiator.newInstance(generatedType, new Object[0]);
                }
                catch (ObjectInstantiationException e) {
                    throw new TaskInstantiationException(String.format("Could not create task of type '%s'.", type.getSimpleName()), e.getCause());
                }
            }
        })));
    }

    private Map<String, ?> checkTaskArgsAndCreateDefaultValues(Map<String, ?> args) {
        this.validateArgs(args);
        if (!args.keySet().containsAll(MANDATORY_TASK_ARGUMENTS)) {
            HashMap argsWithDefaults = Maps.newHashMap(args);
            this.setIfNull(argsWithDefaults, "name", "");
            this.setIfNull(argsWithDefaults, "type", DefaultTask.class);
            return argsWithDefaults;
        }
        return args;
    }

    private void validateArgs(Map<String, ?> args) {
        if (!VALID_TASK_ARGUMENTS.containsAll(args.keySet())) {
            HashMap unknownArguments = new HashMap(args);
            unknownArguments.keySet().removeAll(VALID_TASK_ARGUMENTS);
            throw new InvalidUserDataException(String.format("Could not create task '%s': Unknown argument(s) in task definition: %s", args.get("name"), unknownArguments.keySet()));
        }
    }

    private void setIfNull(Map<String, Object> map, String key, Object defaultValue) {
        if (map.get(key) == null) {
            map.put(key, defaultValue);
        }
    }
}

