/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.artifacts.DependencySubstitution;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.composite.CompositeBuildContext;
import org.gradle.composite.internal.CompositeBuildDependencySubstitutions;
import org.gradle.composite.internal.IncludedBuildDependencyMetadataBuilder;
import org.gradle.composite.internal.IncludedBuildInternal;
import org.gradle.composite.internal.IncludedBuildRegistry;
import org.gradle.composite.internal.RegisteredProject;
import org.gradle.internal.Actions;
import org.gradle.internal.Pair;
import org.gradle.internal.component.local.model.LocalComponentArtifactMetadata;
import org.gradle.internal.component.local.model.LocalComponentMetadata;

public class DefaultBuildableCompositeBuildContext
implements CompositeBuildContext {
    private final Map<ProjectComponentIdentifier, RegisteredProject> projectMetadata = Maps.newHashMap();
    private final Set<Pair<ModuleVersionIdentifier, ProjectComponentIdentifier>> availableModules = Sets.newHashSet();
    private final Set<BuildIdentifier> configuredBuilds = Sets.newHashSet();
    private final List<Action<DependencySubstitution>> substitutionRules = Lists.newArrayList();
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final IncludedBuildDependencyMetadataBuilder dependencyMetadataBuilder;
    private IncludedBuildRegistry includedBuildRegistry;

    public DefaultBuildableCompositeBuildContext(ImmutableModuleIdentifierFactory moduleIdentifierFactory, IncludedBuildDependencyMetadataBuilder dependencyMetadataBuilder) {
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.dependencyMetadataBuilder = dependencyMetadataBuilder;
    }

    public LocalComponentMetadata getComponent(ProjectComponentIdentifier project) {
        RegisteredProject registeredProject = this.getRegisteredProject(project);
        return registeredProject != null ? registeredProject.metaData : null;
    }

    public Collection<LocalComponentArtifactMetadata> getAdditionalArtifacts(ProjectComponentIdentifier project) {
        RegisteredProject registeredProject = this.getRegisteredProject(project);
        return registeredProject != null ? registeredProject.artifacts : null;
    }

    public void addAvailableModules(Set<Pair<ModuleVersionIdentifier, ProjectComponentIdentifier>> availableModules) {
        this.availableModules.addAll(availableModules);
    }

    public void registerSubstitution(Action<DependencySubstitution> substitutions) {
        this.substitutionRules.add(substitutions);
    }

    public Action<DependencySubstitution> getRuleAction() {
        ArrayList allActions = Lists.newArrayList();
        if (!this.availableModules.isEmpty()) {
            allActions.add(new CompositeBuildDependencySubstitutions(this.availableModules, this.moduleIdentifierFactory));
        }
        allActions.addAll(this.substitutionRules);
        return Actions.composite((Iterable)allActions);
    }

    public boolean hasRules() {
        return !this.availableModules.isEmpty() || !this.substitutionRules.isEmpty();
    }

    private RegisteredProject getRegisteredProject(ProjectComponentIdentifier project) {
        RegisteredProject registeredProject = this.projectMetadata.get(project);
        BuildIdentifier buildIdentifier = project.getBuild();
        if (registeredProject == null && !this.configuredBuilds.contains(buildIdentifier)) {
            this.configuredBuilds.add(buildIdentifier);
            IncludedBuildInternal includedBuild = (IncludedBuildInternal)this.includedBuildRegistry.getBuild(buildIdentifier);
            if (includedBuild != null) {
                this.projectMetadata.putAll(this.dependencyMetadataBuilder.build(includedBuild));
                registeredProject = this.projectMetadata.get(project);
                if (registeredProject == null) {
                    throw new IllegalStateException(project + " was not found.");
                }
            }
        }
        return registeredProject;
    }

    public void setIncludedBuildRegistry(IncludedBuildRegistry includedBuildRegistry) {
        this.includedBuildRegistry = includedBuildRegistry;
    }
}

