/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.KtLightClassMarker;
import org.jetbrains.kotlin.com.intellij.openapi.components.ServiceManager;
import org.jetbrains.kotlin.com.intellij.openapi.project.DumbAware;
import org.jetbrains.kotlin.com.intellij.openapi.project.DumbService;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.roots.PackageIndex;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.NonClasspathClassFinder;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFinder;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackage;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiElementFinderImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.file.PsiPackageImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.file.impl.JavaFileManager;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightModifierList;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.kotlin.com.intellij.reference.SoftReference;
import org.jetbrains.kotlin.com.intellij.util.CommonProcessors;
import org.jetbrains.kotlin.com.intellij.util.ConcurrencyUtil;
import org.jetbrains.kotlin.com.intellij.util.Processor;
import org.jetbrains.kotlin.com.intellij.util.Query;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.messages.MessageBus;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.load.java.AbstractJavaClassFinder;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.impl.JavaClassImpl;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.resolve.jvm.GlobalSearchScopeWithModuleSources;
import org.jetbrains.kotlin.resolve.jvm.KotlinCliJavaFileManager;
import org.jetbrains.kotlin.resolve.jvm.KotlinFinderMarker;
import org.jetbrains.kotlin.resolve.jvm.KotlinSafeClassFinder;

public class KotlinJavaPsiFacade {
    private volatile KotlinPsiElementFinderWrapper[] elementFinders;
    private volatile SoftReference<PackageCache> packageCache;
    private final Project project;
    private final LightModifierList emptyModifierList;

    public static KotlinJavaPsiFacade getInstance(Project project) {
        return ServiceManager.getService(project, KotlinJavaPsiFacade.class);
    }

    public KotlinJavaPsiFacade(@NotNull Project project) {
        this.project = project;
        this.emptyModifierList = new LightModifierList(PsiManager.getInstance(project), KotlinLanguage.INSTANCE, new String[0]);
        final PsiModificationTracker modificationTracker2 = PsiManager.getInstance(project).getModificationTracker();
        MessageBus bus = project.getMessageBus();
        bus.connect().subscribe(PsiModificationTracker.TOPIC, new PsiModificationTracker.Listener(){
            private long lastTimeSeen = -1L;

            @Override
            public void modificationCountChanged() {
                long now = modificationTracker2.getJavaStructureModificationCount();
                if (this.lastTimeSeen != now) {
                    this.lastTimeSeen = now;
                    KotlinJavaPsiFacade.this.packageCache = null;
                }
            }
        });
    }

    public LightModifierList getEmptyModifierList() {
        return this.emptyModifierList;
    }

    public JavaClass findClass(@NotNull ClassId classId, @NotNull GlobalSearchScope scope) {
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        String qualifiedName = classId.asSingleFqName().asString();
        if (this.shouldUseSlowResolve()) {
            PsiClass[] classes2 = this.findClassesInDumbMode(qualifiedName, scope);
            if (classes2.length != 0) {
                return KotlinJavaPsiFacade.createJavaClass(classId, classes2[0]);
            }
            return null;
        }
        for (KotlinPsiElementFinderWrapper finder : this.finders()) {
            GlobalSearchScope baseScope;
            boolean isSourcesScope;
            Object aClass2;
            if (finder instanceof CliFinder) {
                aClass2 = ((CliFinder)finder).findClass(classId, scope);
                if (aClass2 == null) continue;
                return aClass2;
            }
            aClass2 = finder.findClass(qualifiedName, scope);
            if (aClass2 == null) continue;
            if (scope instanceof AbstractJavaClassFinder.FilterOutKotlinSourceFilesScope && !(isSourcesScope = (baseScope = ((AbstractJavaClassFinder.FilterOutKotlinSourceFilesScope)scope).getBase()) instanceof GlobalSearchScopeWithModuleSources)) {
                KotlinPsiElementFinderWrapper originalFinder = finder instanceof KotlinPsiElementFinderWrapperImpl ? ((KotlinPsiElementFinderWrapperImpl)finder).getOriginal() : finder;
                boolean isAndroidDataBindingClassWriter = originalFinder.getClass().getName().equals("com.android.tools.idea.databinding.DataBindingClassFinder");
                boolean isAndroidDataBindingComponentClassWriter = originalFinder.getClass().getName().equals("com.android.tools.idea.databinding.DataBindingComponentClassFinder");
                if (isAndroidDataBindingClassWriter || isAndroidDataBindingComponentClassWriter) continue;
            }
            return KotlinJavaPsiFacade.createJavaClass(classId, (PsiClass)aClass2);
        }
        return null;
    }

    @NotNull
    private static JavaClass createJavaClass(@NotNull ClassId classId, @NotNull PsiClass psiClass) {
        JavaClassImpl javaClass = new JavaClassImpl(psiClass);
        FqName fqName2 = classId.asSingleFqName();
        if (!fqName2.equals(javaClass.getFqName())) {
            throw new IllegalStateException("Requested " + fqName2 + ", got " + javaClass.getFqName());
        }
        if (psiClass instanceof KtLightClassMarker) {
            throw new IllegalStateException("Kotlin light classes should not be found by JavaPsiFacade, resolving: " + fqName2);
        }
        return javaClass;
    }

    @Nullable
    public Set<String> knownClassNamesInPackage(@NotNull FqName packageFqName) {
        KotlinPsiElementFinderWrapper[] finders = this.finders();
        if (finders.length == 1 && finders[0] instanceof CliFinder) {
            return ((CliFinder)finders[0]).knownClassNamesInPackage(packageFqName);
        }
        return null;
    }

    @NotNull
    private PsiClass[] findClassesInDumbMode(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        String packageName = StringUtil.getPackageName(qualifiedName);
        PsiPackage pkg = this.findPackage(packageName, scope);
        String className2 = StringUtil.getShortName(qualifiedName);
        if (pkg == null && packageName.length() < qualifiedName.length()) {
            PsiClass[] containingClasses = this.findClassesInDumbMode(packageName, scope);
            if (containingClasses.length == 1) {
                return PsiElementFinder.filterByName(className2, containingClasses[0].getInnerClasses());
            }
            return PsiClass.EMPTY_ARRAY;
        }
        if (pkg == null || !pkg.containsClassNamed(className2)) {
            return PsiClass.EMPTY_ARRAY;
        }
        return pkg.findClassByShortName(className2, scope);
    }

    private boolean shouldUseSlowResolve() {
        DumbService dumbService = DumbService.getInstance(this.getProject());
        return dumbService.isDumb() && dumbService.isAlternativeResolveEnabled();
    }

    @NotNull
    private KotlinPsiElementFinderWrapper[] finders() {
        KotlinPsiElementFinderWrapper[] answer = this.elementFinders;
        if (answer == null) {
            answer = this.calcFinders();
            this.elementFinders = answer;
        }
        return answer;
    }

    @NotNull
    private KotlinPsiElementFinderWrapper[] calcFinders() {
        ArrayList<CliFinder> elementFinders = new ArrayList<CliFinder>();
        JavaFileManager javaFileManager = KotlinJavaPsiFacade.findJavaFileManager(this.project);
        elementFinders.add((CliFinder)(javaFileManager instanceof KotlinCliJavaFileManager ? new CliFinder((KotlinCliJavaFileManager)javaFileManager) : new NonCliFinder(this.project, javaFileManager)));
        List nonKotlinFinders = ArraysKt.filter((Object[])this.getProject().getExtensions(PsiElementFinder.EP_NAME), finder -> finder instanceof KotlinSafeClassFinder || !(finder instanceof NonClasspathClassFinder) && !(finder instanceof KotlinFinderMarker) && !(finder instanceof PsiElementFinderImpl));
        elementFinders.addAll(CollectionsKt.map((Iterable)nonKotlinFinders, KotlinJavaPsiFacade::wrap));
        return elementFinders.toArray(new KotlinPsiElementFinderWrapper[elementFinders.size()]);
    }

    @NotNull
    private static JavaFileManager findJavaFileManager(@NotNull Project project) {
        JavaFileManager javaFileManager = ServiceManager.getService(project, JavaFileManager.class);
        if (javaFileManager == null) {
            throw new IllegalStateException("JavaFileManager component is not found in project");
        }
        return javaFileManager;
    }

    public PsiPackage findPackage(@NotNull String qualifiedName, GlobalSearchScope searchScope) {
        Pair<String, GlobalSearchScope> key;
        PsiPackage aPackage;
        PackageCache cache2 = SoftReference.dereference(this.packageCache);
        if (cache2 == null) {
            cache2 = new PackageCache();
            this.packageCache = new SoftReference<PackageCache>(cache2);
        }
        if ((aPackage = (PsiPackage)cache2.packageInScopeCache.get(key = new Pair<String, GlobalSearchScope>(qualifiedName, searchScope))) != null) {
            return aPackage;
        }
        KotlinPsiElementFinderWrapper[] finders = this.filteredFinders();
        Boolean packageFoundInAllScope = (Boolean)cache2.hasPackageInAllScopeCache.get(qualifiedName);
        if (packageFoundInAllScope != null) {
            if (!packageFoundInAllScope.booleanValue()) {
                return null;
            }
            for (KotlinPsiElementFinderWrapper finder : finders) {
                if (finder.isSameResultForAnyScope() || (aPackage = finder.findPackage(qualifiedName, searchScope)) == null) continue;
                return ConcurrencyUtil.cacheOrGet(cache2.packageInScopeCache, key, aPackage);
            }
        } else {
            for (KotlinPsiElementFinderWrapper finder : finders) {
                aPackage = finder.findPackage(qualifiedName, searchScope);
                if (aPackage == null) continue;
                return ConcurrencyUtil.cacheOrGet(cache2.packageInScopeCache, key, aPackage);
            }
            boolean found = false;
            for (KotlinPsiElementFinderWrapper finder : finders) {
                if (finder.isSameResultForAnyScope() || (aPackage = finder.findPackage(qualifiedName, GlobalSearchScope.allScope(this.project))) == null) continue;
                found = true;
                break;
            }
            cache2.hasPackageInAllScopeCache.put(qualifiedName, found);
        }
        return null;
    }

    @NotNull
    private KotlinPsiElementFinderWrapper[] filteredFinders() {
        DumbService dumbService = DumbService.getInstance(this.getProject());
        KotlinPsiElementFinderWrapper[] finders = this.finders();
        if (dumbService.isDumb()) {
            List<KotlinPsiElementFinderWrapper> list2 = dumbService.filterByDumbAwareness(Arrays.asList(finders));
            finders = list2.toArray(new KotlinPsiElementFinderWrapper[list2.size()]);
        }
        return finders;
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }

    public static KotlinPsiElementFinderWrapper wrap(PsiElementFinder finder) {
        return finder instanceof DumbAware ? new KotlinPsiElementFinderWrapperImplDumbAware(finder) : new KotlinPsiElementFinderWrapperImpl(finder);
    }

    private static class NonCliFinder
    implements DumbAware,
    KotlinPsiElementFinderWrapper {
        private final JavaFileManager javaFileManager;
        private final PsiManager psiManager;
        private final PackageIndex packageIndex;

        public NonCliFinder(@NotNull Project project, @NotNull JavaFileManager javaFileManager) {
            this.javaFileManager = javaFileManager;
            this.packageIndex = PackageIndex.getInstance(project);
            this.psiManager = PsiManager.getInstance(project);
        }

        @Override
        public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
            return this.javaFileManager.findClass(qualifiedName, scope);
        }

        @Override
        public PsiPackage findPackage(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
            Query<VirtualFile> dirs = this.packageIndex.getDirsByPackageName(qualifiedName, true);
            return NonCliFinder.hasDirectoriesInScope(dirs, scope) ? new PsiPackageImpl(this.psiManager, qualifiedName) : null;
        }

        @Override
        public boolean isSameResultForAnyScope() {
            return false;
        }

        private static boolean hasDirectoriesInScope(Query<VirtualFile> dirs, final GlobalSearchScope scope) {
            CommonProcessors.FindProcessor<VirtualFile> findProcessor = new CommonProcessors.FindProcessor<VirtualFile>(){

                @Override
                protected boolean accept(VirtualFile file) {
                    return scope.accept(file);
                }
            };
            dirs.forEach((Processor<VirtualFile>)findProcessor);
            return findProcessor.isFound();
        }
    }

    private static class CliFinder
    implements DumbAware,
    KotlinPsiElementFinderWrapper {
        private final KotlinCliJavaFileManager javaFileManager;

        public CliFinder(@NotNull KotlinCliJavaFileManager javaFileManager) {
            this.javaFileManager = javaFileManager;
        }

        @Override
        public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
            return this.javaFileManager.findClass(qualifiedName, scope);
        }

        public JavaClass findClass(@NotNull ClassId classId, @NotNull GlobalSearchScope scope) {
            return this.javaFileManager.findClass(classId, scope);
        }

        @Nullable
        public Set<String> knownClassNamesInPackage(@NotNull FqName packageFqName) {
            return this.javaFileManager.knownClassNamesInPackage(packageFqName);
        }

        @Override
        public PsiPackage findPackage(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
            return this.javaFileManager.findPackage(qualifiedName);
        }

        @Override
        public boolean isSameResultForAnyScope() {
            return false;
        }
    }

    private static class KotlinPsiElementFinderWrapperImplDumbAware
    extends KotlinPsiElementFinderWrapperImpl
    implements DumbAware {
        private KotlinPsiElementFinderWrapperImplDumbAware(PsiElementFinder finder) {
            super(finder);
        }
    }

    private static class KotlinPsiElementFinderWrapperImpl
    implements KotlinPsiElementFinderWrapper {
        private final PsiElementFinder finder;

        private KotlinPsiElementFinderWrapperImpl(@NotNull PsiElementFinder finder) {
            this.finder = finder;
        }

        public PsiElementFinder getOriginal() {
            return this.finder;
        }

        @Override
        public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
            return this.finder.findClass(qualifiedName, scope);
        }

        @Override
        public PsiPackage findPackage(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
            return this.finder.findPackage(qualifiedName);
        }

        @Override
        public boolean isSameResultForAnyScope() {
            return true;
        }

        public String toString() {
            return this.finder.toString();
        }
    }

    static interface KotlinPsiElementFinderWrapper {
        public PsiClass findClass(@NotNull String var1, @NotNull GlobalSearchScope var2);

        public PsiPackage findPackage(@NotNull String var1, @NotNull GlobalSearchScope var2);

        public boolean isSameResultForAnyScope();
    }

    private static class PackageCache {
        final ConcurrentMap<Pair<String, GlobalSearchScope>, PsiPackage> packageInScopeCache = ContainerUtil.newConcurrentMap();
        final ConcurrentMap<String, Boolean> hasPackageInAllScopeCache = ContainerUtil.newConcurrentMap();

        private PackageCache() {
        }
    }
}

