/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\tH\u0002J\b\u0010\u000f\u001a\u00020\u0005H\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u0016H\u0016J\u0006\u0010\u0017\u001a\u00020\u0003J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/IntegerValueTypeConstructor;", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "value", "", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "(JLorg/jetbrains/kotlin/builtins/KotlinBuiltIns;)V", "supertypes", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/types/KotlinType;", "checkBoundsAndAddSuperType", "", "minValue", "maxValue", "kotlinType", "getBuiltIns", "getDeclarationDescriptor", "", "getParameters", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "getSupertypes", "", "getValue", "isDenotable", "", "isFinal", "toString", "", "core"})
public final class IntegerValueTypeConstructor
implements TypeConstructor {
    private final ArrayList<KotlinType> supertypes;
    private final long value;
    private final KotlinBuiltIns builtIns;

    private final void checkBoundsAndAddSuperType(long value, long minValue, long maxValue, KotlinType kotlinType) {
        if (value >= minValue && value <= maxValue) {
            this.supertypes.add(kotlinType);
        }
    }

    @Override
    @NotNull
    public Collection<KotlinType> getSupertypes() {
        return this.supertypes;
    }

    @Override
    @NotNull
    public List<TypeParameterDescriptor> getParameters() {
        return CollectionsKt.emptyList();
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @Override
    public boolean isDenotable() {
        return false;
    }

    @Nullable
    public Void getDeclarationDescriptor() {
        return null;
    }

    public final long getValue() {
        return this.value;
    }

    @Override
    @NotNull
    public KotlinBuiltIns getBuiltIns() {
        return this.builtIns;
    }

    @NotNull
    public String toString() {
        return "IntegerValueType(" + this.value + ')';
    }

    public IntegerValueTypeConstructor(long value, @NotNull KotlinBuiltIns builtIns) {
        Intrinsics.checkParameterIsNotNull((Object)builtIns, (String)"builtIns");
        this.value = value;
        this.builtIns = builtIns;
        this.supertypes = new ArrayList(4);
        long l = Integer.MIN_VALUE;
        long l2 = Integer.MAX_VALUE;
        SimpleType simpleType2 = this.builtIns.getIntType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"builtIns.intType");
        this.checkBoundsAndAddSuperType(this.value, l, l2, simpleType2);
        long l3 = -128;
        long l4 = 127;
        SimpleType simpleType3 = this.builtIns.getByteType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType3, (String)"builtIns.byteType");
        this.checkBoundsAndAddSuperType(this.value, l3, l4, simpleType3);
        long l5 = Short.MIN_VALUE;
        long l6 = Short.MAX_VALUE;
        SimpleType simpleType4 = this.builtIns.getShortType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType4, (String)"builtIns.shortType");
        this.checkBoundsAndAddSuperType(this.value, l5, l6, simpleType4);
        this.supertypes.add(this.builtIns.getLongType());
    }
}

