/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.java.JavaLanguage;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiField;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiFileFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameIdentifierOwner;
import org.jetbrains.kotlin.incremental.ChangedFiles;
import org.jetbrains.kotlin.incremental.ChangedJavaFilesProcessor;
import org.jetbrains.kotlin.incremental.ChangesEither;
import org.jetbrains.kotlin.incremental.FileUtilsKt;
import org.jetbrains.kotlin.incremental.ICReporter;
import org.jetbrains.kotlin.incremental.LookupSymbol;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u001a\u0010\u0018\u001a\u00020\u0019*\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u001cH\u0002J\u000e\u0010\u001d\u001a\u0004\u0018\u00010\u001e*\u00020\u001fH\u0002R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/incremental/ChangedJavaFilesProcessor;", "", "reporter", "Lorg/jetbrains/kotlin/incremental/ICReporter;", "(Lorg/jetbrains/kotlin/incremental/ICReporter;)V", "allChangedSymbols", "", "Lorg/jetbrains/kotlin/incremental/LookupSymbol;", "getAllChangedSymbols", "()Ljava/util/Collection;", "allSymbols", "Ljava/util/HashSet;", "javaLang", "Lorg/jetbrains/kotlin/com/intellij/lang/java/JavaLanguage;", "psiFileFactory", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiFileFactory;", "getPsiFileFactory", "()Lcom/intellij/psi/PsiFileFactory;", "psiFileFactory$delegate", "Lkotlin/Lazy;", "process", "Lorg/jetbrains/kotlin/incremental/ChangesEither;", "filesDiff", "Lorg/jetbrains/kotlin/incremental/ChangedFiles$Known;", "addLookupSymbols", "", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiClass;", "symbols", "", "psiFile", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiFile;", "Ljava/io/File;", "incremental-compilation-impl"})
public final class ChangedJavaFilesProcessor {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final HashSet<LookupSymbol> allSymbols;
    private final JavaLanguage javaLang;
    private final Lazy psiFileFactory$delegate;
    private final ICReporter reporter;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ChangedJavaFilesProcessor.class), "psiFileFactory", "getPsiFileFactory()Lcom/intellij/psi/PsiFileFactory;"))};
    }

    private final PsiFileFactory getPsiFileFactory() {
        Lazy lazy = this.psiFileFactory$delegate;
        ChangedJavaFilesProcessor changedJavaFilesProcessor = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (PsiFileFactory)lazy.getValue();
    }

    @NotNull
    public final Collection<LookupSymbol> getAllChangedSymbols() {
        return this.allSymbols;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ChangesEither process(@NotNull ChangedFiles.Known filesDiff) {
        void $receiver$iv$iv;
        void $receiver$iv$iv2;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)filesDiff, (String)"filesDiff");
        Iterable iterable = $receiver$iv = (Iterable)filesDiff.getModified();
        Iterable destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            File p1 = (File)element$iv$iv;
            if (!FileUtilsKt.isJavaFile(p1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List modifiedJava = (List)destination$iv$iv;
        Iterable $receiver$iv2 = filesDiff.getRemoved();
        destination$iv$iv = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv2 : $receiver$iv$iv) {
            File p1 = (File)element$iv$iv2;
            if (!FileUtilsKt.isJavaFile(p1)) continue;
            destination$iv$iv2.add(element$iv$iv2);
        }
        List removedJava = (List)destination$iv$iv2;
        if (CollectionsKt.any((Iterable)removedJava)) {
            this.reporter.report((Function0<String>)((Function0)new Function0<String>(removedJava){
                final /* synthetic */ List $removedJava;

                @NotNull
                public final String invoke() {
                    return "Some java files are removed: [" + CollectionsKt.joinToString$default((Iterable)this.$removedJava, null, null, null, (int)0, null, null, (int)63, null) + ']';
                }
                {
                    this.$removedJava = list2;
                    super(0);
                }
            }));
            return new ChangesEither.Unknown();
        }
        HashSet symbols = new HashSet();
        for (File javaFile : modifiedJava) {
            boolean element$iv$iv = StringsKt.equals((String)FilesKt.getExtension((File)javaFile), (String)"java", (boolean)true);
            if (_Assertions.ENABLED && !element$iv$iv) {
                Object element$iv$iv2;
                element$iv$iv2 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError(element$iv$iv2));
            }
            PsiFile psiFile = this.psiFile(javaFile);
            if (!(psiFile instanceof PsiJavaFile)) {
                this.reporter.report((Function0<String>)((Function0)new Function0<String>(psiFile){
                    final /* synthetic */ PsiFile $psiFile;

                    @NotNull
                    public final String invoke() {
                        PsiFile psiFile = this.$psiFile;
                        return "Expected PsiJavaFile, got " + (psiFile != null ? psiFile.getClass() : null);
                    }
                    {
                        this.$psiFile = psiFile;
                        super(0);
                    }
                }));
                return new ChangesEither.Unknown();
            }
            PsiClass[] psiClassArray = ((PsiJavaFile)psiFile).getClasses();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiClassArray, (String)"psiFile.classes");
            Object[] $receiver$iv3 = psiClassArray;
            for (int i = 0; i < $receiver$iv3.length; ++i) {
                PsiClass it;
                Object element$iv = $receiver$iv3[i];
                PsiClass psiClass = it = (PsiClass)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"it");
                this.addLookupSymbols(psiClass, symbols);
            }
        }
        this.allSymbols.addAll(symbols);
        return new ChangesEither.Known(symbols, null, 2, null);
    }

    private final void addLookupSymbols(@NotNull PsiClass $receiver, Set<LookupSymbol> symbols) {
        PsiNameIdentifierOwner it;
        Object element$iv;
        int n;
        String string;
        String string2;
        String fqn;
        String string3 = $receiver.getQualifiedName();
        String string4 = string3;
        if (string4 == null) {
            string4 = fqn = "";
        }
        if ((string2 = (string3 = $receiver.getName())) == null) {
            string2 = "";
        }
        if (Intrinsics.areEqual((Object)fqn, (Object)$receiver.getName())) {
            string = "";
        } else {
            StringBuilder stringBuilder = new StringBuilder().append(".");
            String string5 = $receiver.getName();
            if (string5 == null) {
                Intrinsics.throwNpe();
            }
            string = StringsKt.removeSuffix((String)fqn, (CharSequence)stringBuilder.append(string5).toString());
        }
        symbols.add(new LookupSymbol(string2, string));
        PsiMethod[] psiMethodArray = $receiver.getMethods();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiMethodArray, (String)"methods");
        Object[] $receiver$iv = psiMethodArray;
        for (n = 0; n < $receiver$iv.length; ++n) {
            element$iv = $receiver$iv[n];
            it = (PsiMethod)element$iv;
            PsiMethod psiMethod = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod, (String)"it");
            String string6 = psiMethod.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"it.name");
            symbols.add(new LookupSymbol(string6, fqn));
        }
        PsiField[] psiFieldArray = $receiver.getFields();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFieldArray, (String)"fields");
        $receiver$iv = psiFieldArray;
        for (n = 0; n < $receiver$iv.length; ++n) {
            element$iv = $receiver$iv[n];
            PsiNameIdentifierOwner psiNameIdentifierOwner = it = (PsiField)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiNameIdentifierOwner, (String)"it");
            String $i$a$1$forEach = psiNameIdentifierOwner.getName();
            String string7 = $i$a$1$forEach;
            if (string7 == null) {
                string7 = "";
            }
            symbols.add(new LookupSymbol(string7, fqn));
        }
        PsiClass[] psiClassArray = $receiver.getInnerClasses();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClassArray, (String)"innerClasses");
        $receiver$iv = psiClassArray;
        for (n = 0; n < $receiver$iv.length; ++n) {
            element$iv = $receiver$iv[n];
            PsiNameIdentifierOwner psiNameIdentifierOwner = it = (PsiClass)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiNameIdentifierOwner, (String)"it");
            this.addLookupSymbols((PsiClass)psiNameIdentifierOwner, symbols);
        }
    }

    private final PsiFile psiFile(@NotNull File $receiver) {
        return this.getPsiFileFactory().createFileFromText(FilesKt.getNameWithoutExtension((File)$receiver), this.javaLang, (CharSequence)FilesKt.readText$default((File)$receiver, null, (int)1, null));
    }

    public ChangedJavaFilesProcessor(@NotNull ICReporter reporter) {
        Intrinsics.checkParameterIsNotNull((Object)reporter, (String)"reporter");
        this.reporter = reporter;
        this.allSymbols = new HashSet();
        this.javaLang = JavaLanguage.INSTANCE;
        this.psiFileFactory$delegate = LazyKt.lazy((Function0)psiFileFactory.2.INSTANCE);
    }
}

