/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.collect.Lists;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;

public class DiagnosticUtils {
    @NotNull
    private static final Comparator<TextRange> TEXT_RANGE_COMPARATOR = (o1, o2) -> {
        if (o1.getStartOffset() != o2.getStartOffset()) {
            return o1.getStartOffset() - o2.getStartOffset();
        }
        return o1.getEndOffset() - o2.getEndOffset();
    };

    private DiagnosticUtils() {
    }

    public static String atLocation(DeclarationDescriptor descriptor2) {
        PsiElement element = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
        if (element == null) {
            element = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2.getOriginal());
        }
        if (element == null && descriptor2 instanceof ASTNode) {
            element = DiagnosticUtils.getClosestPsiElement((ASTNode)((Object)descriptor2));
        }
        if (element != null) {
            return DiagnosticUtils.atLocation(element);
        }
        return "unknown location";
    }

    public static String atLocation(KtExpression expression2) {
        return DiagnosticUtils.atLocation(expression2.getNode());
    }

    public static String atLocation(@NotNull PsiElement element) {
        return DiagnosticUtils.atLocation(element.getNode());
    }

    public static String atLocation(@NotNull ASTNode node) {
        int startOffset = node.getStartOffset();
        PsiElement element = DiagnosticUtils.getClosestPsiElement(node);
        if (element != null && element.isValid()) {
            return DiagnosticUtils.atLocation(element.getContainingFile(), element.getTextRange());
        }
        return "' at offset " + startOffset + " (line and file unknown: no PSI element)";
    }

    @Nullable
    public static PsiElement getClosestPsiElement(@NotNull ASTNode node) {
        while (node.getPsi() == null) {
            node = node.getTreeParent();
        }
        return node.getPsi();
    }

    @NotNull
    public static PsiFile getContainingFile(@NotNull ASTNode node) {
        PsiElement closestPsiElement = DiagnosticUtils.getClosestPsiElement(node);
        assert (closestPsiElement != null) : "This node is not contained by a file";
        return closestPsiElement.getContainingFile();
    }

    @NotNull
    public static String atLocation(@NotNull PsiFile file, @NotNull TextRange textRange) {
        Document document = file.getViewProvider().getDocument();
        return DiagnosticUtils.atLocation(file, textRange, document);
    }

    @NotNull
    public static String atLocation(PsiFile file, TextRange textRange, Document document) {
        int offset2 = textRange.getStartOffset();
        VirtualFile virtualFile2 = file.getVirtualFile();
        String pathSuffix = " in " + (virtualFile2 == null ? file.getName() : virtualFile2.getPath());
        return DiagnosticUtils.offsetToLineAndColumn(document, offset2).toString() + pathSuffix;
    }

    @NotNull
    public static LineAndColumn getLineAndColumn(@NotNull Diagnostic diagnostic) {
        PsiFile file = diagnostic.getPsiFile();
        List<TextRange> textRanges = diagnostic.getTextRanges();
        if (textRanges.isEmpty()) {
            return LineAndColumn.NONE;
        }
        TextRange firstRange = DiagnosticUtils.firstRange(textRanges);
        return DiagnosticUtils.getLineAndColumnInPsiFile(file, firstRange);
    }

    @NotNull
    public static LineAndColumn getLineAndColumnInPsiFile(PsiFile file, TextRange range) {
        Document document = file.getViewProvider().getDocument();
        return DiagnosticUtils.offsetToLineAndColumn(document, range.getStartOffset());
    }

    @NotNull
    public static LineAndColumn offsetToLineAndColumn(@Nullable Document document, int offset2) {
        if (document == null) {
            return new LineAndColumn(-1, offset2, null);
        }
        int lineNumber = document.getLineNumber(offset2);
        int lineStartOffset = document.getLineStartOffset(lineNumber);
        int column = offset2 - lineStartOffset;
        int lineEndOffset = document.getLineEndOffset(lineNumber);
        CharSequence lineContent = document.getCharsSequence().subSequence(lineStartOffset, lineEndOffset);
        return new LineAndColumn(lineNumber + 1, column + 1, lineContent.toString());
    }

    public static void throwIfRunningOnServer(Throwable e) {
        if (System.getProperty("kotlin.running.in.server.mode", "false").equals("true") || ApplicationManager.getApplication().isUnitTestMode()) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static TextRange firstRange(@NotNull List<TextRange> ranges2) {
        return Collections.min(ranges2, TEXT_RANGE_COMPARATOR);
    }

    @NotNull
    public static List<Diagnostic> sortedDiagnostics(@NotNull Collection<Diagnostic> diagnostics) {
        ArrayList<Diagnostic> result2 = Lists.newArrayList(diagnostics);
        result2.sort((d1, d2) -> {
            TextRange range2;
            String path2;
            String path1 = d1.getPsiFile().getViewProvider().getVirtualFile().getPath();
            if (!path1.equals(path2 = d2.getPsiFile().getViewProvider().getVirtualFile().getPath())) {
                return path1.compareTo(path2);
            }
            TextRange range1 = DiagnosticUtils.firstRange(d1.getTextRanges());
            if (!range1.equals(range2 = DiagnosticUtils.firstRange(d2.getTextRanges()))) {
                return TEXT_RANGE_COMPARATOR.compare(range1, range2);
            }
            return d1.getFactory().getName().compareTo(d2.getFactory().getName());
        });
        return result2;
    }

    public static boolean hasError(Diagnostics diagnostics) {
        for (Diagnostic diagnostic : diagnostics.all()) {
            if (diagnostic.getSeverity() != Severity.ERROR) continue;
            return true;
        }
        return false;
    }

    public static final class LineAndColumn {
        public static final LineAndColumn NONE = new LineAndColumn(-1, -1, null);
        private final int line;
        private final int column;
        private final String lineContent;

        public LineAndColumn(int line, int column, @Nullable String lineContent) {
            this.line = line;
            this.column = column;
            this.lineContent = lineContent;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        @Nullable
        public String getLineContent() {
            return this.lineContent;
        }

        public String toString() {
            if (this.line < 0) {
                return "(offset: " + this.column + " line unknown)";
            }
            return "(" + this.line + "," + this.column + ")";
        }
    }
}

