/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.parsing;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.AnalysisFlag;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.contracts.description.ContractDescription;
import org.jetbrains.kotlin.contracts.description.ContractProviderKey;
import org.jetbrains.kotlin.contracts.description.LazyContractProvider;
import org.jetbrains.kotlin.contracts.parsing.PsiContractParserDispatcher;
import org.jetbrains.kotlin.contracts.parsing.PsiContractsUtilsKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001d\u0010\u0015\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u0018J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u001a\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J$\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/contracts/parsing/ContractParsingServices;", "", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "checkContractAndRecordIfPresent", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "isFirstStatement", "", "fastCheckIfContractPresent", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "isContractAllowedHere", "isContractDescriptionCall", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isContractDescriptionCall$frontend", "isContractDescriptionCallFastCheck", "isContractDescriptionCallPreciseCheck", "parseContract", "Lorg/jetbrains/kotlin/contracts/description/ContractDescription;", "ownerDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "frontend"})
public final class ContractParsingServices {
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;

    public final boolean fastCheckIfContractPresent(@NotNull KtElement element) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (!this.isContractAllowedHere(element)) {
            return false;
        }
        KtElement ktElement = element;
        if (!(ktElement instanceof KtFunction)) {
            ktElement = null;
        }
        KtFunction ktFunction = (KtFunction)ktElement;
        KtExpression ktExpression = ktFunction != null ? ktFunction.getBodyExpression() : null;
        if (!(ktExpression instanceof KtBlockExpression)) {
            ktExpression = null;
        }
        if ((object = (KtBlockExpression)ktExpression) == null || (object = ((KtBlockExpression)object).getStatements()) == null || (object = (KtExpression)CollectionsKt.firstOrNull((List)object)) == null) {
            return false;
        }
        Object firstExpression = object;
        return this.isContractDescriptionCallFastCheck((KtExpression)firstExpression);
    }

    /*
     * Unable to fully structure code
     */
    public final void checkContractAndRecordIfPresent(@NotNull KtExpression expression, @NotNull BindingTrace trace, @NotNull LexicalScope scope, boolean isFirstStatement) {
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        ownerDescriptor = scope.getOwnerDescriptor();
        if (!this.isContractDescriptionCallFastCheck(expression) || !(ownerDescriptor instanceof FunctionDescriptor)) {
            return;
        }
        v0 = (LazyContractProvider)((FunctionDescriptor)ownerDescriptor).getUserData(ContractProviderKey.INSTANCE);
        if (v0 == null) {
            return;
        }
        contractProvider = v0;
        v1 = isFeatureTurnedOn = this.languageVersionSettings.supportsFeature(LanguageFeature.CallsInPlaceEffect) != false || this.languageVersionSettings.supportsFeature(LanguageFeature.ReturnsEffect) != false || this.languageVersionSettings.getFlag(AnalysisFlag.Flags.getAllowKotlinPackage()) != false;
        if (!isFeatureTurnedOn) ** GOTO lbl-1000
        v2 = trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"trace.bindingContext");
        if (!this.isContractDescriptionCallPreciseCheck(expression, v2)) lbl-1000:
        // 2 sources

        {
            v3 = null;
        } else if (!this.isContractAllowedHere(scope) || !isFirstStatement) {
            trace.report(Errors.CONTRACT_NOT_ALLOWED.on((KtElement)((PsiElement)expression)));
            v3 = null;
        } else {
            v3 = this.parseContract(expression, trace, (FunctionDescriptor)ownerDescriptor);
        }
        contractDescriptor = v3;
        contractProvider.setContractDescription(contractDescriptor);
    }

    private final ContractDescription parseContract(KtExpression expression2, BindingTrace trace, FunctionDescriptor ownerDescriptor) {
        return new PsiContractParserDispatcher(trace, this).parseContract(expression2, ownerDescriptor);
    }

    public final boolean isContractDescriptionCall$frontend(@NotNull KtExpression expression2, @NotNull BindingContext context) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return this.isContractDescriptionCallFastCheck(expression2) && this.isContractDescriptionCallPreciseCheck(expression2, context);
    }

    private final boolean isContractAllowedHere(KtElement element) {
        return element instanceof KtNamedFunction && ((KtNamedFunction)element).isTopLevel() && ((KtNamedFunction)element).hasBlockBody() && !((KtNamedFunction)element).hasModifier(KtTokens.OPERATOR_KEYWORD);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isContractAllowedHere(LexicalScope scope) {
        if (!Intrinsics.areEqual((Object)((Object)scope.getKind()), (Object)((Object)LexicalScopeKind.CODE_BLOCK))) return false;
        HierarchicalScope hierarchicalScope = scope.getParent();
        if (!(hierarchicalScope instanceof LexicalScope)) {
            hierarchicalScope = null;
        }
        LexicalScope lexicalScope = (LexicalScope)hierarchicalScope;
        if (!Intrinsics.areEqual((Object)((Object)(lexicalScope != null ? lexicalScope.getKind() : null)), (Object)((Object)LexicalScopeKind.FUNCTION_INNER_SCOPE))) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isContractDescriptionCallFastCheck(KtExpression expression2) {
        if (!(expression2 instanceof KtCallExpression)) return false;
        KtExpression ktExpression = ((KtCallExpression)expression2).getCalleeExpression();
        if (!Intrinsics.areEqual((Object)(ktExpression != null ? ktExpression.getText() : null), (Object)"contract")) return false;
        return true;
    }

    private final boolean isContractDescriptionCallPreciseCheck(KtExpression expression2, BindingContext context) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(expression2, context);
        return resolvedCall2 != null && (resolvedCall2 = resolvedCall2.getResultingDescriptor()) != null ? PsiContractsUtilsKt.isContractCallDescriptor((DeclarationDescriptor)((Object)resolvedCall2)) : false;
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings() {
        return this.languageVersionSettings;
    }

    public ContractParsingServices(@NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        this.languageVersionSettings = languageVersionSettings;
    }
}

