/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.base.MoreObjects;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SmartPointerAnchorProvider;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IFileElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.kotlin.com.intellij.util.containers.WeakInterner;

public abstract class Identikit {
    private static final WeakInterner<ByType> ourPlainInterner = new WeakInterner();
    private static final WeakInterner<ByAnchor> ourAnchorInterner = new WeakInterner();

    @Nullable
    public abstract PsiElement findPsiElement(@NotNull PsiFile var1, int var2, int var3);

    @NotNull
    public abstract Language getFileLanguage();

    public abstract boolean isForPsiFile();

    public static ByType fromPsi(@NotNull PsiElement element, @NotNull Language fileLanguage) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/Identikit", "fromPsi"));
        }
        if (fileLanguage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileLanguage", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/Identikit", "fromPsi"));
        }
        return Identikit.fromTypes(element.getClass(), PsiUtilCore.getElementType(element), fileLanguage);
    }

    @Nullable
    static Pair<ByAnchor, PsiElement> withAnchor(@NotNull PsiElement element, @NotNull Language fileLanguage) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/Identikit", "withAnchor"));
        }
        if (fileLanguage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileLanguage", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/Identikit", "withAnchor"));
        }
        PsiUtilCore.ensureValid(element);
        if (element.isPhysical()) {
            for (SmartPointerAnchorProvider provider : SmartPointerAnchorProvider.EP_NAME.getExtensions()) {
                PsiElement anchor2 = provider.getAnchor(element);
                if (anchor2 == null || !anchor2.isPhysical() || provider.restoreElement(anchor2) != element) continue;
                ByAnchor anchorKit = new ByAnchor(Identikit.fromPsi(element, fileLanguage), Identikit.fromPsi(anchor2, fileLanguage), provider);
                return Pair.create(ourAnchorInterner.intern(anchorKit), anchor2);
            }
        }
        return null;
    }

    @NotNull
    static ByType fromTypes(@NotNull Class elementClass, @Nullable IElementType elementType, @NotNull Language fileLanguage) {
        if (elementClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementClass", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/Identikit", "fromTypes"));
        }
        if (fileLanguage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileLanguage", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/Identikit", "fromTypes"));
        }
        ByType byType = ourPlainInterner.intern(new ByType(elementClass, elementType, fileLanguage));
        if (byType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/Identikit", "fromTypes"));
        }
        return byType;
    }

    static class ByAnchor
    extends Identikit {
        private final ByType myElementInfo;
        private final ByType myAnchorInfo;
        private final SmartPointerAnchorProvider myAnchorProvider;

        ByAnchor(ByType elementInfo, ByType anchorInfo, SmartPointerAnchorProvider anchorProvider) {
            this.myElementInfo = elementInfo;
            this.myAnchorInfo = anchorInfo;
            this.myAnchorProvider = anchorProvider;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ByAnchor)) {
                return false;
            }
            ByAnchor anchor2 = (ByAnchor)o;
            if (!this.myElementInfo.equals(anchor2.myElementInfo)) {
                return false;
            }
            if (!this.myAnchorInfo.equals(anchor2.myAnchorInfo)) {
                return false;
            }
            return this.myAnchorProvider.equals(anchor2.myAnchorProvider);
        }

        public int hashCode() {
            return this.myElementInfo.hashCode();
        }

        @Override
        @Nullable
        public PsiElement findPsiElement(@NotNull PsiFile file, int startOffset, int endOffset) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/Identikit$ByAnchor", "findPsiElement"));
            }
            PsiElement anchor2 = this.myAnchorInfo.findPsiElement(file, startOffset, endOffset);
            PsiElement element = anchor2 == null ? null : this.myAnchorProvider.restoreElement(anchor2);
            return element != null && this.myElementInfo.isAcceptable(element) ? element : null;
        }

        @Override
        @NotNull
        public Language getFileLanguage() {
            Language language = this.myAnchorInfo.getFileLanguage();
            if (language == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/Identikit$ByAnchor", "getFileLanguage"));
            }
            return language;
        }

        @Override
        public boolean isForPsiFile() {
            return this.myAnchorInfo.isForPsiFile();
        }
    }

    public static class ByType
    extends Identikit {
        private final Class myElementClass;
        private final IElementType myElementType;
        private final Language myFileLanguage;

        private ByType(@NotNull Class elementClass, @Nullable IElementType elementType, Language fileLanguage) {
            if (elementClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementClass", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/Identikit$ByType", "<init>"));
            }
            this.myElementClass = elementClass;
            this.myElementType = elementType;
            this.myFileLanguage = fileLanguage;
        }

        @Override
        @Nullable
        public PsiElement findPsiElement(@NotNull PsiFile file, int startOffset, int endOffset) {
            PsiElement lastChild;
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/Identikit$ByType", "findPsiElement"));
            }
            PsiElement anchor2 = file.getViewProvider().findElementAt(startOffset, this.myFileLanguage);
            if (anchor2 == null && startOffset == file.getTextLength() && (lastChild = file.getViewProvider().getPsi(this.myFileLanguage).getLastChild()) != null) {
                anchor2 = PsiTreeUtil.getDeepestLast(lastChild);
            }
            if (anchor2 == null) {
                return null;
            }
            PsiElement result2 = this.findParent(startOffset, endOffset, anchor2);
            if (endOffset == startOffset) {
                while (result2 == null && anchor2.getTextRange().getStartOffset() == endOffset && (anchor2 = PsiTreeUtil.prevLeaf(anchor2, false)) != null) {
                    result2 = this.findParent(startOffset, endOffset, anchor2);
                }
            }
            return result2;
        }

        @Nullable
        private PsiElement findParent(int startOffset, int endOffset, PsiElement anchor2) {
            TextRange range = anchor2.getTextRange();
            if (range.getStartOffset() != startOffset) {
                return null;
            }
            while (range.getEndOffset() < endOffset) {
                if ((anchor2 = anchor2.getParent()) == null || anchor2.getTextRange() == null) {
                    return null;
                }
                range = anchor2.getTextRange();
            }
            while (range.getEndOffset() == endOffset) {
                if (this.isAcceptable(anchor2)) {
                    return anchor2;
                }
                if ((anchor2 = anchor2.getParent()) == null || anchor2.getTextRange() == null) break;
                range = anchor2.getTextRange();
            }
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ByType)) {
                return false;
            }
            ByType info = (ByType)o;
            return this.myElementType == info.myElementType && this.myElementClass == info.myElementClass && this.myFileLanguage == info.myFileLanguage;
        }

        public int hashCode() {
            return (this.myElementType == null ? 0 : this.myElementType.hashCode() * 31 * 31) + 31 * this.myElementClass.getName().hashCode() + this.myFileLanguage.hashCode();
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("class", this.myElementClass).add("elementType", this.myElementType).add("fileLanguage", this.myFileLanguage).toString();
        }

        @Override
        @NotNull
        public Language getFileLanguage() {
            Language language = this.myFileLanguage;
            if (language == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/Identikit$ByType", "getFileLanguage"));
            }
            return language;
        }

        @Override
        public boolean isForPsiFile() {
            return this.myElementType instanceof IFileElementType;
        }

        private boolean isAcceptable(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/Identikit$ByType", "isAcceptable"));
            }
            return this.myElementClass == element.getClass() && this.myElementType == PsiUtilCore.getElementType(element);
        }
    }
}

