/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.file;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.codeInsight.completion.scope.JavaCompletionHints;
import org.jetbrains.kotlin.com.intellij.core.CoreJavaDirectoryService;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.java.JavaLanguage;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentation;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentationProviders;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.openapi.project.DumbService;
import org.jetbrains.kotlin.com.intellij.openapi.project.IndexNotReadyException;
import org.jetbrains.kotlin.com.intellij.openapi.ui.Queryable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Condition;
import org.jetbrains.kotlin.com.intellij.openapi.util.Conditions;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.NavigatablePsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiDirectory;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackage;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackageStatement;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;
import org.jetbrains.kotlin.com.intellij.psi.impl.JavaPsiFacadeImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.file.PsiPackageBase;
import org.jetbrains.kotlin.com.intellij.psi.impl.file.PsiPackageImplementationHelper;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java.PsiCompositeModifierList;
import org.jetbrains.kotlin.com.intellij.psi.scope.ElementClassHint;
import org.jetbrains.kotlin.com.intellij.psi.scope.NameHint;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.search.EverythingGlobalScope;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.search.PsiSearchScopeUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValue;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiClassUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.reference.SoftReference;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.Processor;
import org.jetbrains.kotlin.com.intellij.util.Processors;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class PsiPackageImpl
extends PsiPackageBase
implements Queryable,
PsiPackage {
    private static final Logger LOG = Logger.getInstance(PsiPackageImpl.class);
    private volatile CachedValue<PsiModifierList> myAnnotationList;
    private volatile CachedValue<Collection<PsiDirectory>> myDirectories;
    private volatile CachedValue<Collection<PsiDirectory>> myDirectoriesWithLibSources;
    private volatile SoftReference<Map<String, PsiClass[]>> myClassCache;
    private volatile SoftReference<Map<GlobalSearchScope, Map<String, PsiClass[]>>> myDumbModeFullCache;
    private volatile SoftReference<Map<Pair<GlobalSearchScope, String>, PsiClass[]>> myDumbModePartialCache;

    public PsiPackageImpl(PsiManager manager, String qualifiedName) {
        super(manager, qualifiedName);
    }

    @Override
    protected Collection<PsiDirectory> getAllDirectories(boolean includeLibrarySources) {
        if (includeLibrarySources) {
            if (this.myDirectoriesWithLibSources == null) {
                this.myDirectoriesWithLibSources = this.createCachedDirectories(true);
            }
            return this.myDirectoriesWithLibSources.getValue();
        }
        if (this.myDirectories == null) {
            this.myDirectories = this.createCachedDirectories(false);
        }
        return this.myDirectories.getValue();
    }

    @NotNull
    private CachedValue<Collection<PsiDirectory>> createCachedDirectories(boolean includeLibrarySources) {
        CachedValue<Collection<PsiDirectory>> cachedValue2 = CachedValuesManager.getManager(this.myManager.getProject()).createCachedValue(() -> {
            ArrayList result2 = new ArrayList();
            Processor<PsiDirectory> processor = Processors.cancelableCollectProcessor(result2);
            this.getFacade().processPackageDirectories(this, this.allScope(), processor, includeLibrarySources);
            return CachedValueProvider.Result.create(result2, PsiPackageImplementationHelper.getInstance().getDirectoryCachedValueDependencies(this));
        }, false);
        if (cachedValue2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiPackageImpl", "createCachedDirectories"));
        }
        return cachedValue2;
    }

    @Override
    protected PsiElement findPackage(String qName) {
        return this.getFacade().findPackage(qName);
    }

    @Override
    public void handleQualifiedNameChange(@NotNull String newQualifiedName) {
        if (newQualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newQualifiedName", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiPackageImpl", "handleQualifiedNameChange"));
        }
        PsiPackageImplementationHelper.getInstance().handleQualifiedNameChange(this, newQualifiedName);
    }

    @Override
    @NotNull
    public VirtualFile[] occursInPackagePrefixes() {
        VirtualFile[] virtualFileArray = PsiPackageImplementationHelper.getInstance().occursInPackagePrefixes(this);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiPackageImpl", "occursInPackagePrefixes"));
        }
        return virtualFileArray;
    }

    @Override
    public PsiPackageImpl getParentPackage() {
        return (PsiPackageImpl)super.getParentPackage();
    }

    @Override
    protected PsiPackageImpl createInstance(PsiManager manager, String qName) {
        return new PsiPackageImpl(this.myManager, qName);
    }

    @Override
    @NotNull
    public Language getLanguage() {
        JavaLanguage javaLanguage = JavaLanguage.INSTANCE;
        if (javaLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiPackageImpl", "getLanguage"));
        }
        return javaLanguage;
    }

    @Override
    public boolean isValid() {
        return !this.myManager.getProject().isDisposed() && (PsiPackageImplementationHelper.getInstance().packagePrefixExists(this) || !this.getAllDirectories(true).isEmpty());
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiPackageImpl", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitPackage(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiPackage:" + this.getQualifiedName();
    }

    @Override
    @NotNull
    public PsiClass[] getClasses() {
        PsiClass[] psiClassArray = this.getClasses(this.allScope());
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiPackageImpl", "getClasses"));
        }
        return psiClassArray;
    }

    @NotNull
    protected GlobalSearchScope allScope() {
        GlobalSearchScope globalSearchScope = PsiPackageImplementationHelper.getInstance().adjustAllScope(this, GlobalSearchScope.allScope(this.getProject()));
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiPackageImpl", "allScope"));
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public PsiClass[] getClasses(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiPackageImpl", "getClasses"));
        }
        PsiClass[] psiClassArray = this.getFacade().getClasses(this, scope);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiPackageImpl", "getClasses"));
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    public PsiFile[] getFiles(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiPackageImpl", "getFiles"));
        }
        PsiFile[] psiFileArray = this.getFacade().getPackageFiles(this, scope);
        if (psiFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiPackageImpl", "getFiles"));
        }
        return psiFileArray;
    }

    @Override
    @Nullable
    public PsiModifierList getAnnotationList() {
        if (this.myAnnotationList == null) {
            this.myAnnotationList = CachedValuesManager.getManager(this.myManager.getProject()).createCachedValue(new PackageAnnotationValueProvider(), false);
        }
        return this.myAnnotationList.getValue();
    }

    @Override
    @NotNull
    public PsiPackage[] getSubPackages() {
        PsiPackage[] psiPackageArray = this.getSubPackages(this.allScope());
        if (psiPackageArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiPackageImpl", "getSubPackages"));
        }
        return psiPackageArray;
    }

    @Override
    @NotNull
    public PsiPackage[] getSubPackages(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiPackageImpl", "getSubPackages"));
        }
        PsiPackage[] psiPackageArray = this.getFacade().getSubPackages(this, scope);
        if (psiPackageArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiPackageImpl", "getSubPackages"));
        }
        return psiPackageArray;
    }

    private JavaPsiFacadeImpl getFacade() {
        return (JavaPsiFacadeImpl)JavaPsiFacade.getInstance(this.myManager.getProject());
    }

    @NotNull
    private PsiClass[] getCachedClassesByName(@NotNull String name, GlobalSearchScope scope) {
        PsiClass[] classes2;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiPackageImpl", "getCachedClassesByName"));
        }
        if (DumbService.getInstance(this.getProject()).isDumb()) {
            PsiClass[] psiClassArray = this.getCachedClassInDumbMode(name, scope);
            if (psiClassArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiPackageImpl", "getCachedClassesByName"));
            }
            return psiClassArray;
        }
        Map<String, PsiClass[]> map2 = SoftReference.dereference(this.myClassCache);
        if (map2 == null) {
            map2 = ContainerUtil.createConcurrentSoftValueMap();
            this.myClassCache = new SoftReference<ConcurrentMap<String, PsiClass[]>>((ConcurrentMap<String, PsiClass[]>)map2);
        }
        if ((classes2 = map2.get(name)) != null) {
            if (classes2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiPackageImpl", "getCachedClassesByName"));
            }
            return classes2;
        }
        String qName = this.getQualifiedName();
        String classQName = !qName.isEmpty() ? qName + "." + name : name;
        classes2 = this.getFacade().findClasses(classQName, new EverythingGlobalScope(this.getProject()));
        map2.put(name, classes2);
        if (classes2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiPackageImpl", "getCachedClassesByName"));
        }
        return classes2;
    }

    @NotNull
    private PsiClass[] getCachedClassInDumbMode(String name, GlobalSearchScope scope) {
        PsiClass[] classes2;
        Map<String, PsiClass[]> map2;
        Map<GlobalSearchScope, Map<String, PsiClass[]>> scopeMap = SoftReference.dereference(this.myDumbModeFullCache);
        if (scopeMap == null) {
            scopeMap = ContainerUtil.newConcurrentMap();
            this.myDumbModeFullCache = new SoftReference<ConcurrentMap<GlobalSearchScope, Map<String, PsiClass[]>>>((ConcurrentMap<GlobalSearchScope, Map<String, PsiClass[]>>)scopeMap);
        }
        if ((map2 = scopeMap.get(scope)) == null) {
            PsiClass[] array = this.findClassesHeuristically(name, scope);
            if (array != null) {
                if (array == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiPackageImpl", "getCachedClassInDumbMode"));
                }
                return array;
            }
            map2 = new HashMap<String, PsiClass[]>();
            for (PsiClass psiClass : this.getClasses(scope)) {
                PsiClass[] psiClassArray;
                String psiClassName = psiClass.getName();
                if (psiClassName == null) continue;
                PsiClass[] existing = map2.get(psiClassName);
                if (existing == null) {
                    PsiClass[] psiClassArray2 = new PsiClass[1];
                    psiClassArray = psiClassArray2;
                    psiClassArray2[0] = psiClass;
                } else {
                    psiClassArray = ArrayUtil.append(existing, psiClass);
                }
                map2.put(psiClassName, psiClassArray);
            }
            scopeMap.put(scope, map2);
        }
        PsiClass[] psiClassArray = (classes2 = map2.get(name)) == null ? PsiClass.EMPTY_ARRAY : classes2;
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiPackageImpl", "getCachedClassInDumbMode"));
        }
        return psiClassArray;
    }

    @Nullable
    private PsiClass[] findClassesHeuristically(String name, GlobalSearchScope scope) {
        PsiClass[] result2;
        if (this.findSubPackageByName(name) != null) {
            return PsiClass.EMPTY_ARRAY;
        }
        Map<Pair<GlobalSearchScope, String>, PsiClass[]> partial = SoftReference.dereference(this.myDumbModePartialCache);
        if (partial == null) {
            partial = ContainerUtil.newConcurrentMap();
            this.myDumbModePartialCache = new SoftReference<ConcurrentMap<Pair<GlobalSearchScope, String>, PsiClass[]>>((ConcurrentMap<Pair<GlobalSearchScope, String>, PsiClass[]>)partial);
        }
        if ((result2 = partial.get(Pair.create(scope, name))) == null) {
            ArrayList<PsiClass> fastClasses = ContainerUtil.newArrayList();
            for (PsiDirectory directory : this.getDirectories(scope)) {
                List<PsiFile> sameNamed = ContainerUtil.filter(directory.getFiles(), file -> file.getName().contains(name));
                Collections.addAll(fastClasses, CoreJavaDirectoryService.getPsiClasses(directory, sameNamed.toArray(new PsiFile[sameNamed.size()])));
            }
            if (!fastClasses.isEmpty()) {
                result2 = fastClasses.toArray(new PsiClass[fastClasses.size()]);
                partial.put(Pair.create(scope, name), result2);
            }
        }
        return result2;
    }

    @Override
    public boolean containsClassNamed(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiPackageImpl", "containsClassNamed"));
        }
        return this.getCachedClassesByName(name, new EverythingGlobalScope(this.getProject())).length > 0;
    }

    @Override
    @NotNull
    public PsiClass[] findClassByShortName(@NotNull String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiPackageImpl", "findClassByShortName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiPackageImpl", "findClassByShortName"));
        }
        PsiClass[] allClasses = this.getCachedClassesByName(name, scope);
        if (allClasses.length == 0) {
            if (allClasses == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiPackageImpl", "findClassByShortName"));
            }
            return allClasses;
        }
        if (allClasses.length == 1) {
            PsiClass[] psiClassArray = PsiSearchScopeUtil.isInScope(scope, (PsiElement)allClasses[0]) ? allClasses : PsiClass.EMPTY_ARRAY;
            if (psiClassArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiPackageImpl", "findClassByShortName"));
            }
            return psiClassArray;
        }
        PsiClass[] array = ContainerUtil.findAllAsArray(allClasses, aClass2 -> {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiPackageImpl", "lambda$findClassByShortName$2"));
            }
            return PsiSearchScopeUtil.isInScope(scope, (PsiElement)aClass2);
        });
        Arrays.sort(array, PsiClassUtil.createScopeComparator(scope));
        if (array == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiPackageImpl", "findClassByShortName"));
        }
        return array;
    }

    @Nullable
    private PsiPackage findSubPackageByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiPackageImpl", "findSubPackageByName"));
        }
        String qName = this.getQualifiedName();
        String subpackageQName = qName.isEmpty() ? name : qName + "." + name;
        return this.getFacade().findPackage(subpackageQName);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state2, PsiElement lastParent, @NotNull PsiElement place) {
        PsiClass[] classes2;
        String providedName;
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiPackageImpl", "processDeclarations"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiPackageImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiPackageImpl", "processDeclarations"));
        }
        GlobalSearchScope scope = place.getResolveScope();
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, this);
        ElementClassHint classHint = processor.getHint(ElementClassHint.KEY);
        Condition<String> nameCondition = processor.getHint(JavaCompletionHints.NAME_FILTER);
        NameHint providedNameHint = processor.getHint(NameHint.KEY);
        String string = providedName = providedNameHint == null ? null : providedNameHint.getName(state2);
        if ((classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) && (providedName != null ? !PsiPackageImpl.processClasses(processor, state2, classes2 = this.findClassByShortName(providedName, scope), Conditions.alwaysTrue()) : !PsiPackageImpl.processClasses(processor, state2, classes2 = this.getClasses(scope), nameCondition != null ? nameCondition : Conditions.alwaysTrue()))) {
            return false;
        }
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.PACKAGE)) {
            if (providedName != null) {
                PsiPackage aPackage = this.findSubPackageByName(providedName);
                if (aPackage != null && !processor.execute(aPackage, state2)) {
                    return false;
                }
            } else {
                PsiPackage[] packs;
                for (PsiPackage pack : packs = this.getSubPackages(scope)) {
                    String packageName = pack.getName();
                    if (packageName == null || !PsiNameHelper.getInstance(this.myManager.getProject()).isIdentifier(packageName, PsiUtil.getLanguageLevel(this)) || processor.execute(pack, state2)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean processClasses(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state2, @NotNull PsiClass[] classes2, @NotNull Condition<String> nameCondition) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiPackageImpl", "processClasses"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiPackageImpl", "processClasses"));
        }
        if (classes2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiPackageImpl", "processClasses"));
        }
        if (nameCondition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameCondition", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiPackageImpl", "processClasses"));
        }
        for (PsiClass aClass2 : classes2) {
            String name = aClass2.getName();
            if (name == null || !nameCondition.value(name)) continue;
            try {
                if (processor.execute(aClass2, state2)) continue;
                return false;
            }
            catch (ProcessCanceledException | IndexNotReadyException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error(e);
            }
        }
        return true;
    }

    @Override
    public boolean canNavigate() {
        return this.isValid();
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public void navigate(boolean requestFocus) {
        PsiPackageImplementationHelper.getInstance().navigate(this, requestFocus);
    }

    @Override
    @Nullable
    public PsiModifierList getModifierList() {
        return this.getAnnotationList();
    }

    @Override
    public boolean hasModifierProperty(@NonNls @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiPackageImpl", "hasModifierProperty"));
        }
        return false;
    }

    private class PackageAnnotationValueProvider
    implements CachedValueProvider<PsiModifierList> {
        private PackageAnnotationValueProvider() {
        }

        @Override
        public CachedValueProvider.Result<PsiModifierList> compute() {
            ArrayList<PsiModifierList> modifiers2 = ContainerUtil.newArrayList();
            for (PsiDirectory psiDirectory : PsiPackageImpl.this.getDirectories()) {
                PsiFile file = psiDirectory.findFile("package-info.java");
                PsiPackageStatement stmt = file == null ? null : PsiTreeUtil.getChildOfType(file, PsiPackageStatement.class);
                PsiModifierList modifierList = stmt == null ? null : stmt.getAnnotationList();
                ContainerUtil.addIfNotNull(modifiers2, modifierList);
            }
            for (NavigatablePsiElement navigatablePsiElement : PsiPackageImpl.this.getFacade().findClasses(PsiPackageImpl.this.getQualifiedName() + ".package-info", PsiPackageImpl.this.allScope())) {
                ContainerUtil.addIfNotNull(modifiers2, navigatablePsiElement.getModifierList());
            }
            PsiCompositeModifierList result2 = modifiers2.isEmpty() ? null : new PsiCompositeModifierList(PsiPackageImpl.this.getManager(), modifiers2);
            return new CachedValueProvider.Result<PsiModifierList>(result2, PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
        }
    }
}

