/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport$Companion$WhenMappings;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.DefaultDiagnosticReporter;
import org.jetbrains.kotlin.cli.common.messages.DiagnosticMessageReporter;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.codegen.state.IncompatibleClassTrackerImpl;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiErrorElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiFormatUtil;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.load.java.JvmBytecodeBinaryVersion;
import org.jetbrains.kotlin.load.java.components.TraceBasedErrorReporter;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.AnalyzingUtils;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.jvm.JvmBindingContextSlices;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.serialization.deserialization.IncompatibleVersionErrorData;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0003\u0017\u0018\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0011J\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\fH\u0002J\b\u0010\u0015\u001a\u00020\fH\u0002J\u0016\u0010\u0016\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport;", "", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "(Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;)V", "analysisResult", "Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "getAnalysisResult", "()Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "setAnalysisResult", "(Lorg/jetbrains/kotlin/analyzer/AnalysisResult;)V", "analyzeAndReport", "", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "analyze", "Lkotlin/Function0;", "hasErrors", "", "reportAlternativeSignatureErrors", "reportIncompleteHierarchies", "reportSyntaxErrors", "Companion", "MyDiagnostic", "SyntaxErrorReport", "cli"})
public final class AnalyzerWithCompilerReport {
    @NotNull
    public AnalysisResult analysisResult;
    private final MessageCollector messageCollector;
    private static final DiagnosticFactory0<PsiErrorElement> SYNTAX_ERROR_FACTORY;
    public static final Companion Companion;

    @NotNull
    public final AnalysisResult getAnalysisResult() {
        AnalysisResult analysisResult2 = this.analysisResult;
        if (analysisResult2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"analysisResult");
        }
        return analysisResult2;
    }

    public final void setAnalysisResult(@NotNull AnalysisResult analysisResult2) {
        Intrinsics.checkParameterIsNotNull((Object)analysisResult2, (String)"<set-?>");
        this.analysisResult = analysisResult2;
    }

    private final void reportIncompleteHierarchies() {
        BindingContext bindingContext;
        Collection<ClassDescriptor> classes2;
        AnalysisResult analysisResult2 = this.analysisResult;
        if (analysisResult2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"analysisResult");
        }
        if (!(classes2 = (bindingContext = analysisResult2.getBindingContext()).getKeys(TraceBasedErrorReporter.INCOMPLETE_HIERARCHY)).isEmpty()) {
            StringBuilder message = new StringBuilder("Supertypes of the following classes cannot be resolved. Please make sure you have the required dependencies in the classpath:\n");
            for (ClassDescriptor descriptor2 : classes2) {
                boolean bl;
                String fqName2 = DescriptorUtils.getFqName(descriptor2).asString();
                List unresolved = (List)bindingContext.get(TraceBasedErrorReporter.INCOMPLETE_HIERARCHY, descriptor2);
                boolean bl2 = bl = unresolved != null && !unresolved.isEmpty();
                if (_Assertions.ENABLED && !bl) {
                    String string = "Incomplete hierarchy should be reported with names of unresolved superclasses: " + fqName2;
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                StringBuilder stringBuilder = message.append("    class ").append(fqName2).append(", unresolved supertypes: ");
                List list2 = unresolved;
                if (list2 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"unresolved!!");
                stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list2, null, null, null, (int)0, null, null, (int)63, null)).append("\n");
            }
            String string = message.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message.toString()");
            MessageCollector.DefaultImpls.report$default(this.messageCollector, CompilerMessageSeverity.ERROR, string, null, 4, null);
        }
    }

    private final void reportAlternativeSignatureErrors() {
        BindingContext bc;
        Collection<DeclarationDescriptor> descriptorsWithErrors;
        AnalysisResult analysisResult2 = this.analysisResult;
        if (analysisResult2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"analysisResult");
        }
        if (!(descriptorsWithErrors = (bc = analysisResult2.getBindingContext()).getKeys(JvmBindingContextSlices.LOAD_FROM_JAVA_SIGNATURE_ERRORS)).isEmpty()) {
            StringBuilder message = new StringBuilder("The following Java entities have annotations with wrong Kotlin signatures:\n");
            Iterator<DeclarationDescriptor> iterator2 = descriptorsWithErrors.iterator();
            while (iterator2.hasNext()) {
                boolean bl;
                DeclarationDescriptor descriptor2;
                DeclarationDescriptor declarationDescriptor = descriptor2 = iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"descriptor");
                PsiElement declaration = DescriptorToSourceUtils.descriptorToDeclaration(declarationDescriptor);
                boolean bl2 = declaration instanceof PsiModifierListOwner;
                if (_Assertions.ENABLED && !bl2) {
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                List errors = (List)bc.get(JvmBindingContextSlices.LOAD_FROM_JAVA_SIGNATURE_ERRORS, descriptor2);
                boolean bl3 = bl = errors != null && !errors.isEmpty();
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                PsiElement psiElement = declaration;
                if (psiElement == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiModifierListOwner");
                }
                String externalName = PsiFormatUtil.getExternalName((PsiModifierListOwner)psiElement);
                message.append(externalName).append(":\n");
                List list2 = errors;
                if (list2 == null) {
                    Intrinsics.throwNpe();
                }
                for (String error : list2) {
                    message.append("    ").append(error).append("\n");
                }
            }
            String string = message.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message.toString()");
            MessageCollector.DefaultImpls.report$default(this.messageCollector, CompilerMessageSeverity.ERROR, string, null, 4, null);
        }
    }

    private final void reportSyntaxErrors(Collection<? extends KtFile> files2) {
        for (KtFile ktFile : files2) {
            Companion.reportSyntaxErrors((PsiElement)ktFile, this.messageCollector);
        }
    }

    public final boolean hasErrors() {
        return this.messageCollector.hasErrors();
    }

    public final void analyzeAndReport(@NotNull Collection<? extends KtFile> files2, @NotNull Function0<? extends AnalysisResult> analyze2) {
        Intrinsics.checkParameterIsNotNull(files2, (String)"files");
        Intrinsics.checkParameterIsNotNull(analyze2, (String)"analyze");
        this.analysisResult = (AnalysisResult)analyze2.invoke();
        this.reportSyntaxErrors(files2);
        AnalysisResult analysisResult2 = this.analysisResult;
        if (analysisResult2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"analysisResult");
        }
        Diagnostics diagnostics = analysisResult2.getBindingContext().getDiagnostics();
        Intrinsics.checkExpressionValueIsNotNull((Object)diagnostics, (String)"analysisResult.bindingContext.diagnostics");
        Companion.reportDiagnostics(diagnostics, this.messageCollector);
        this.reportIncompleteHierarchies();
        this.reportAlternativeSignatureErrors();
    }

    public AnalyzerWithCompilerReport(@NotNull MessageCollector messageCollector2) {
        Intrinsics.checkParameterIsNotNull((Object)messageCollector2, (String)"messageCollector");
        this.messageCollector = messageCollector2;
    }

    static {
        Companion = new Companion(null);
        SYNTAX_ERROR_FACTORY = DiagnosticFactory0.create(Severity.ERROR);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport$SyntaxErrorReport;", "", "isHasErrors", "", "isAllErrorsAtEof", "(ZZ)V", "()Z", "cli"})
    public static final class SyntaxErrorReport {
        private final boolean isHasErrors;
        private final boolean isAllErrorsAtEof;

        public final boolean isHasErrors() {
            return this.isHasErrors;
        }

        public final boolean isAllErrorsAtEof() {
            return this.isAllErrorsAtEof;
        }

        public SyntaxErrorReport(boolean isHasErrors, boolean isAllErrorsAtEof) {
            this.isHasErrors = isHasErrors;
            this.isAllErrorsAtEof = isAllErrorsAtEof;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B#\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport$MyDiagnostic;", "E", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/diagnostics/SimpleDiagnostic;", "psiElement", "factory", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory0;", "message", "", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory0;Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "isValid", "", "cli"})
    private static final class MyDiagnostic<E extends PsiElement>
    extends SimpleDiagnostic<E> {
        @NotNull
        private final String message;

        @Override
        public boolean isValid() {
            return true;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        public MyDiagnostic(@NotNull E psiElement, @NotNull DiagnosticFactory0<E> factory2, @NotNull String message) {
            Intrinsics.checkParameterIsNotNull(psiElement, (String)"psiElement");
            Intrinsics.checkParameterIsNotNull(factory2, (String)"factory");
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            super(psiElement, factory2, Severity.ERROR);
            this.message = message;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001&B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u0012J&\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0016\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0011\u001a\u00020\u0012R8\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport$Companion;", "", "()V", "SYNTAX_ERROR_FACTORY", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory0;", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiErrorElement;", "kotlin.jvm.PlatformType", "getSYNTAX_ERROR_FACTORY", "()Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory0;", "convertSeverity", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "reportBytecodeVersionErrors", "", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "reportDiagnostic", "", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "reporter", "Lorg/jetbrains/kotlin/cli/common/messages/DiagnosticMessageReporter;", "reportDiagnostics", "Lorg/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport$Companion$ReportDiagnosticsResult;", "unsortedDiagnostics", "Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "diagnostics", "reportIncompatibleBinaryVersion", "data", "Lorg/jetbrains/kotlin/serialization/deserialization/IncompatibleVersionErrorData;", "Lorg/jetbrains/kotlin/load/java/JvmBytecodeBinaryVersion;", "reportSyntaxErrors", "Lorg/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport$SyntaxErrorReport;", "file", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "ReportDiagnosticsResult", "cli"})
    public static final class Companion {
        @NotNull
        public final CompilerMessageSeverity convertSeverity(@NotNull Severity severity) {
            CompilerMessageSeverity compilerMessageSeverity;
            Intrinsics.checkParameterIsNotNull((Object)((Object)severity), (String)"severity");
            switch (AnalyzerWithCompilerReport$Companion$WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
                case 1: {
                    compilerMessageSeverity = CompilerMessageSeverity.INFO;
                    break;
                }
                case 2: {
                    compilerMessageSeverity = CompilerMessageSeverity.ERROR;
                    break;
                }
                case 3: {
                    compilerMessageSeverity = CompilerMessageSeverity.WARNING;
                    break;
                }
                default: {
                    throw (Throwable)new IllegalStateException("Unknown severity: " + (Object)((Object)severity));
                }
            }
            return compilerMessageSeverity;
        }

        private final DiagnosticFactory0<PsiErrorElement> getSYNTAX_ERROR_FACTORY() {
            return SYNTAX_ERROR_FACTORY;
        }

        private final boolean reportDiagnostic(Diagnostic diagnostic, DiagnosticMessageReporter reporter) {
            Object object;
            if (!diagnostic.isValid()) {
                return false;
            }
            PsiFile psiFile = diagnostic.getPsiFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"diagnostic.psiFile");
            Diagnostic diagnostic2 = diagnostic;
            if (!(diagnostic2 instanceof MyDiagnostic)) {
                diagnostic2 = null;
            }
            if ((object = (MyDiagnostic)diagnostic2) == null || (object = ((MyDiagnostic)object).getMessage()) == null) {
                String string = DefaultErrorMessages.render(diagnostic);
                object = string;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"DefaultErrorMessages.render(diagnostic)");
            }
            reporter.report(diagnostic, psiFile, (String)object);
            return Intrinsics.areEqual((Object)((Object)diagnostic.getSeverity()), (Object)((Object)Severity.ERROR));
        }

        @NotNull
        public final ReportDiagnosticsResult reportDiagnostics(@NotNull Diagnostics unsortedDiagnostics, @NotNull DiagnosticMessageReporter reporter) {
            Intrinsics.checkParameterIsNotNull((Object)unsortedDiagnostics, (String)"unsortedDiagnostics");
            Intrinsics.checkParameterIsNotNull((Object)reporter, (String)"reporter");
            boolean hasErrors = false;
            boolean hasIncompatibleClassErrors = false;
            List<Diagnostic> diagnostics = DiagnosticUtils.sortedDiagnostics(unsortedDiagnostics.all());
            Iterator<Diagnostic> iterator2 = diagnostics.iterator();
            while (iterator2.hasNext()) {
                Diagnostic diagnostic;
                Diagnostic diagnostic2 = diagnostic = iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)diagnostic2, (String)"diagnostic");
                hasErrors |= this.reportDiagnostic(diagnostic2, reporter);
                hasIncompatibleClassErrors |= Intrinsics.areEqual(diagnostic.getFactory(), Errors.INCOMPATIBLE_CLASS) || Intrinsics.areEqual(diagnostic.getFactory(), Errors.PRE_RELEASE_CLASS);
            }
            return new ReportDiagnosticsResult(hasErrors, hasIncompatibleClassErrors);
        }

        /*
         * WARNING - void declaration
         */
        public final boolean reportDiagnostics(@NotNull Diagnostics diagnostics, @NotNull MessageCollector messageCollector2) {
            void hasErrors;
            Intrinsics.checkParameterIsNotNull((Object)diagnostics, (String)"diagnostics");
            Intrinsics.checkParameterIsNotNull((Object)messageCollector2, (String)"messageCollector");
            ReportDiagnosticsResult reportDiagnosticsResult = this.reportDiagnostics(diagnostics, new DefaultDiagnosticReporter(messageCollector2));
            boolean bl = reportDiagnosticsResult.component1();
            boolean hasIncompatibleClassErrors = reportDiagnosticsResult.component2();
            if (hasIncompatibleClassErrors) {
                MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Incompatible classes were found in dependencies. Remove them from the classpath or use '-Xskip-metadata-version-check' to suppress errors", null, 4, null);
            }
            return (boolean)hasErrors;
        }

        @NotNull
        public final SyntaxErrorReport reportSyntaxErrors(@NotNull PsiElement file, @NotNull DiagnosticMessageReporter reporter) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)reporter, (String)"reporter");
            @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00009\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J5\u0010\f\u001a\u00020\r\"\b\b\u0000\u0010\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u0002H\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0017H\u0016J\f\u0010\u0018\u001a\u00020\u0004*\u00020\u000fH\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\b\u00a8\u0006\u0019"}, d2={"org/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport$Companion$reportSyntaxErrors$ErrorReportingVisitor", "Lorg/jetbrains/kotlin/resolve/AnalyzingUtils$PsiErrorElementVisitor;", "(Lorg/jetbrains/kotlin/cli/common/messages/DiagnosticMessageReporter;)V", "allErrorsAtEof", "", "getAllErrorsAtEof", "()Z", "setAllErrorsAtEof", "(Z)V", "hasErrors", "getHasErrors", "setHasErrors", "reportDiagnostic", "", "E", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "element", "factory", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory0;", "message", "", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory0;Ljava/lang/String;)V", "visitErrorElement", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiErrorElement;", "isAtEof", "cli"})
            public final class ErrorReportingVisitor
            extends AnalyzingUtils.PsiErrorElementVisitor {
                private boolean hasErrors;
                private boolean allErrorsAtEof;
                final /* synthetic */ DiagnosticMessageReporter $reporter;

                public final boolean getHasErrors() {
                    return this.hasErrors;
                }

                public final void setHasErrors(boolean bl) {
                    this.hasErrors = bl;
                }

                public final boolean getAllErrorsAtEof() {
                    return this.allErrorsAtEof;
                }

                public final void setAllErrorsAtEof(boolean bl) {
                    this.allErrorsAtEof = bl;
                }

                private final <E extends PsiElement> void reportDiagnostic(E element, DiagnosticFactory0<E> factory2, String message) {
                    MyDiagnostic<E> diagnostic = new MyDiagnostic<E>(element, factory2, message);
                    org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport$Companion.access$reportDiagnostic(AnalyzerWithCompilerReport.Companion, diagnostic, this.$reporter);
                    if (this.allErrorsAtEof && !this.isAtEof(element)) {
                        this.allErrorsAtEof = false;
                    }
                    this.hasErrors = true;
                }

                private final boolean isAtEof(@NotNull PsiElement $receiver) {
                    PsiElement element = $receiver;
                    do {
                        if (element.getNextSibling() != null) continue;
                        return true;
                    } while (element instanceof PsiWhiteSpace && element instanceof PsiComment);
                    return false;
                }

                public void visitErrorElement(@NotNull PsiErrorElement element) {
                    Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                    String description2 = element.getErrorDescription();
                    PsiElement psiElement = element;
                    DiagnosticFactory0 diagnosticFactory0 = org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport$Companion.access$getSYNTAX_ERROR_FACTORY$p(AnalyzerWithCompilerReport.Companion);
                    Intrinsics.checkExpressionValueIsNotNull((Object)diagnosticFactory0, (String)"SYNTAX_ERROR_FACTORY");
                    String string = StringUtil.isEmpty(description2) ? "Syntax error" : description2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"if (StringUtil.isEmpty(d\u2026x error\" else description");
                    this.reportDiagnostic(psiElement, diagnosticFactory0, string);
                }

                public ErrorReportingVisitor(DiagnosticMessageReporter $captured_local_variable$0) {
                    this.$reporter = $captured_local_variable$0;
                    this.allErrorsAtEof = true;
                }
            }
            ErrorReportingVisitor visitor2 = new ErrorReportingVisitor(reporter);
            file.accept(visitor2);
            return new SyntaxErrorReport(visitor2.getHasErrors(), visitor2.getAllErrorsAtEof());
        }

        @NotNull
        public final SyntaxErrorReport reportSyntaxErrors(@NotNull PsiElement file, @NotNull MessageCollector messageCollector2) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)messageCollector2, (String)"messageCollector");
            return this.reportSyntaxErrors(file, new DefaultDiagnosticReporter(messageCollector2));
        }

        public final void reportBytecodeVersionErrors(@NotNull BindingContext bindingContext, @NotNull MessageCollector messageCollector2) {
            Intrinsics.checkParameterIsNotNull((Object)bindingContext, (String)"bindingContext");
            Intrinsics.checkParameterIsNotNull((Object)messageCollector2, (String)"messageCollector");
            CompilerMessageSeverity severity = Intrinsics.areEqual((Object)System.getProperty("kotlin.jvm.disable.bytecode.version.error"), (Object)"true") ? CompilerMessageSeverity.STRONG_WARNING : CompilerMessageSeverity.ERROR;
            Collection<String> locations = bindingContext.getKeys(IncompatibleClassTrackerImpl.BYTECODE_VERSION_ERRORS);
            if (locations.isEmpty()) {
                return;
            }
            for (String location2 : locations) {
                IncompatibleVersionErrorData data;
                if ((IncompatibleVersionErrorData)bindingContext.get(IncompatibleClassTrackerImpl.BYTECODE_VERSION_ERRORS, location2) == null) {
                    String string = "Value is missing for key in binding context: " + location2;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                IncompatibleVersionErrorData incompatibleVersionErrorData = data;
                Intrinsics.checkExpressionValueIsNotNull((Object)incompatibleVersionErrorData, (String)"data");
                this.reportIncompatibleBinaryVersion(messageCollector2, incompatibleVersionErrorData, severity);
            }
        }

        private final void reportIncompatibleBinaryVersion(MessageCollector messageCollector2, IncompatibleVersionErrorData<JvmBytecodeBinaryVersion> data, CompilerMessageSeverity severity) {
            messageCollector2.report(severity, "Class '" + JvmClassName.byClassId(data.getClassId()) + "' was compiled with an incompatible version of Kotlin. " + "The binary version of its bytecode is " + data.getActualVersion() + ", expected version is " + data.getExpectedVersion(), CompilerMessageLocation.Companion.create(FileUtil.toSystemDependentName(data.getFilePath())));
        }

        private Companion() {
        }

        public static final /* synthetic */ boolean access$reportDiagnostic(Companion $this, @NotNull Diagnostic diagnostic, @NotNull DiagnosticMessageReporter reporter) {
            return $this.reportDiagnostic(diagnostic, reporter);
        }

        public static final /* synthetic */ DiagnosticFactory0 access$getSYNTAX_ERROR_FACTORY$p(Companion $this) {
            return $this.getSYNTAX_ERROR_FACTORY();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport$Companion$ReportDiagnosticsResult;", "", "hasErrors", "", "hasIncompatibleClassErrors", "(ZZ)V", "getHasErrors", "()Z", "getHasIncompatibleClassErrors", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "cli"})
        public static final class ReportDiagnosticsResult {
            private final boolean hasErrors;
            private final boolean hasIncompatibleClassErrors;

            public final boolean getHasErrors() {
                return this.hasErrors;
            }

            public final boolean getHasIncompatibleClassErrors() {
                return this.hasIncompatibleClassErrors;
            }

            public ReportDiagnosticsResult(boolean hasErrors, boolean hasIncompatibleClassErrors) {
                this.hasErrors = hasErrors;
                this.hasIncompatibleClassErrors = hasIncompatibleClassErrors;
            }

            public final boolean component1() {
                return this.hasErrors;
            }

            public final boolean component2() {
                return this.hasIncompatibleClassErrors;
            }

            @NotNull
            public final ReportDiagnosticsResult copy(boolean hasErrors, boolean hasIncompatibleClassErrors) {
                return new ReportDiagnosticsResult(hasErrors, hasIncompatibleClassErrors);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ ReportDiagnosticsResult copy$default(ReportDiagnosticsResult reportDiagnosticsResult, boolean bl, boolean bl2, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = reportDiagnosticsResult.hasErrors;
                }
                if ((n & 2) != 0) {
                    bl2 = reportDiagnosticsResult.hasIncompatibleClassErrors;
                }
                return reportDiagnosticsResult.copy(bl, bl2);
            }

            public String toString() {
                return "ReportDiagnosticsResult(hasErrors=" + this.hasErrors + ", hasIncompatibleClassErrors=" + this.hasIncompatibleClassErrors + ")";
            }

            public int hashCode() {
                int n = this.hasErrors ? 1 : 0;
                if (n != 0) {
                    n = 1;
                }
                int n2 = n * 31;
                int n3 = this.hasIncompatibleClassErrors ? 1 : 0;
                if (n3 != 0) {
                    n3 = 1;
                }
                return n2 + n3;
            }

            public boolean equals(Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof ReportDiagnosticsResult)) break block3;
                        ReportDiagnosticsResult reportDiagnosticsResult = (ReportDiagnosticsResult)object;
                        if (!(this.hasErrors == reportDiagnosticsResult.hasErrors) || !(this.hasIncompatibleClassErrors == reportDiagnosticsResult.hasIncompatibleClassErrors)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

