/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.util.Set;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.artifacts.component.DefaultBuildIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DependencySubstitutionsInternal;
import org.gradle.api.internal.composite.CompositeBuildContext;
import org.gradle.api.internal.project.ProjectRegistry;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.composite.internal.DefaultIncludedBuilds;
import org.gradle.composite.internal.DefaultProjectPathRegistry;
import org.gradle.composite.internal.IncludedBuildDependencySubstitutionsBuilder;
import org.gradle.composite.internal.IncludedBuildInternal;
import org.gradle.initialization.DefaultProjectDescriptor;
import org.gradle.internal.component.local.model.DefaultProjectComponentIdentifier;
import org.gradle.internal.composite.CompositeContextBuilder;
import org.gradle.util.Path;

public class DefaultCompositeContextBuilder
implements CompositeContextBuilder {
    private static final Logger LOGGER = Logging.getLogger(DefaultCompositeContextBuilder.class);
    private final DefaultIncludedBuilds allIncludedBuilds;
    private final DefaultProjectPathRegistry projectRegistry;
    private final CompositeBuildContext context;

    public DefaultCompositeContextBuilder(DefaultIncludedBuilds allIncludedBuilds, DefaultProjectPathRegistry projectRegistry, CompositeBuildContext context) {
        this.allIncludedBuilds = allIncludedBuilds;
        this.projectRegistry = projectRegistry;
        this.context = context;
    }

    public void setRootBuild(SettingsInternal settings) {
        ProjectRegistry settingsProjectRegistry = settings.getProjectRegistry();
        String rootName = ((DefaultProjectDescriptor)settingsProjectRegistry.getRootProject()).getName();
        DefaultBuildIdentifier buildIdentifier = new DefaultBuildIdentifier(rootName, true);
        this.registerProjects(Path.ROOT, (BuildIdentifier)buildIdentifier, settingsProjectRegistry.getAllProjects());
    }

    public void addIncludedBuilds(Iterable<IncludedBuild> includedBuilds) {
        this.registerProjects(includedBuilds);
        this.registerSubstitutions(includedBuilds);
    }

    private void registerProjects(Iterable<IncludedBuild> includedBuilds) {
        for (IncludedBuild includedBuild : includedBuilds) {
            this.allIncludedBuilds.registerBuild(includedBuild);
            Path rootProjectPath = Path.ROOT.child(includedBuild.getName());
            DefaultBuildIdentifier buildIdentifier = new DefaultBuildIdentifier(includedBuild.getName());
            Set allProjects = ((IncludedBuildInternal)includedBuild).getLoadedSettings().getProjectRegistry().getAllProjects();
            this.registerProjects(rootProjectPath, (BuildIdentifier)buildIdentifier, allProjects);
        }
    }

    private void registerProjects(Path rootPath, BuildIdentifier buildIdentifier, Set<DefaultProjectDescriptor> allProjects) {
        for (DefaultProjectDescriptor project : allProjects) {
            Path projectIdentityPath = rootPath.append(project.path());
            ProjectComponentIdentifier projectComponentIdentifier = DefaultProjectComponentIdentifier.newProjectId((BuildIdentifier)buildIdentifier, (String)project.getPath());
            this.projectRegistry.add(projectIdentityPath, projectComponentIdentifier);
        }
    }

    private void registerSubstitutions(Iterable<IncludedBuild> includedBuilds) {
        IncludedBuildDependencySubstitutionsBuilder contextBuilder = new IncludedBuildDependencySubstitutionsBuilder(this.context);
        for (IncludedBuild includedBuild : includedBuilds) {
            this.doAddToCompositeContext((IncludedBuildInternal)includedBuild, contextBuilder);
        }
    }

    private void doAddToCompositeContext(IncludedBuildInternal build, IncludedBuildDependencySubstitutionsBuilder contextBuilder) {
        DependencySubstitutionsInternal substitutions = build.resolveDependencySubstitutions();
        if (!substitutions.hasRules()) {
            LOGGER.info("[composite-build] Configuring build: " + build.getProjectDir());
            contextBuilder.build(build);
        } else {
            this.context.registerSubstitution(substitutions.getRuleAction());
        }
    }
}

