/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.xctest.internal;

import java.io.File;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.file.DirectoryVar;
import org.gradle.api.internal.tasks.testing.DefaultTestClassDescriptor;
import org.gradle.api.internal.tasks.testing.DefaultTestClassRunInfo;
import org.gradle.api.internal.tasks.testing.DefaultTestMethodDescriptor;
import org.gradle.api.internal.tasks.testing.DefaultTestOutputEvent;
import org.gradle.api.internal.tasks.testing.TestClassProcessor;
import org.gradle.api.internal.tasks.testing.TestClassRunInfo;
import org.gradle.api.internal.tasks.testing.TestCompleteEvent;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.TestStartEvent;
import org.gradle.api.internal.tasks.testing.detection.TestExecuter;
import org.gradle.api.internal.tasks.testing.processors.TestMainAction;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.id.LongIdGenerator;
import org.gradle.internal.io.LineBufferingOutputStream;
import org.gradle.internal.io.TextStream;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.time.Clock;
import org.gradle.nativeplatform.test.xctest.internal.MacOSXCTestLocator;
import org.gradle.process.internal.DefaultExecHandleBuilder;
import org.gradle.process.internal.ExecHandle;
import org.gradle.process.internal.ExecHandleBuilder;

public class NativeTestExecuter
implements TestExecuter {
    public ExecHandleBuilder getExecHandleBuilder() {
        return new DefaultExecHandleBuilder();
    }

    @Inject
    public BuildOperationExecutor getBuildOperationExcecutor() {
        throw new UnsupportedOperationException();
    }

    public IdGenerator<?> getIdGenerator() {
        return new LongIdGenerator();
    }

    @Inject
    public ObjectFactory getObjectFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    public Clock getTimeProvider() {
        throw new UnsupportedOperationException();
    }

    public void execute(Test testTask, TestResultProcessor testResultProcessor) {
        ObjectFactory objectFactory = this.getObjectFactory();
        File executable = (File)((DirectoryVar)testTask.getExtensions().getExtraProperties().get("testBundleDir")).getAsFile().get();
        File workingDir = (File)((DirectoryVar)testTask.getExtensions().getExtraProperties().get("workingDir")).getAsFile().get();
        TestClassProcessor processor = (TestClassProcessor)objectFactory.newInstance(NativeTestClassProcessor.class, new Object[]{executable, workingDir, this.getExecHandleBuilder(), this.getIdGenerator()});
        NativeTestDetector detector = new NativeTestDetector(processor);
        Object testTaskOperationId = this.getBuildOperationExcecutor().getCurrentOperation().getParentId();
        new TestMainAction((Runnable)detector, processor, testResultProcessor, this.getTimeProvider(), testTaskOperationId, (Object)testTask.getPath(), "Gradle Test Run " + testTask.getPath()).run();
    }

    private static class TextStreamToProcessor
    implements TextStream {
        private static final Pattern TEST_SUITE_NAME_PATTERN = Pattern.compile("'(\\p{Alnum}+)'");
        private static final Pattern TEST_CASE_NAME_PATTERN = Pattern.compile("'-\\[\\p{Alnum}+.(\\p{Alnum}+) (\\p{Alnum}+)]'");
        private final TestResultProcessor processor;
        private final TestOutputEvent.Destination destination;
        private final IdGenerator<?> idGenerator;
        private final Clock clock;
        private final Deque<TestDescriptorInternal> testDescriptors = new ArrayDeque<TestDescriptorInternal>();

        private TextStreamToProcessor(TestOutputEvent.Destination destination, TestResultProcessor processor, IdGenerator<?> idGenerator, Clock clock) {
            this.processor = processor;
            this.destination = destination;
            this.idGenerator = idGenerator;
            this.clock = clock;
        }

        public void text(String text) {
            System.out.print(text);
            if (text.startsWith("Test Suite")) {
                Matcher testSuiteMatcher = TEST_SUITE_NAME_PATTERN.matcher(text);
                if (!testSuiteMatcher.find()) {
                    return;
                }
                String testSuite = testSuiteMatcher.group(1);
                if (text.contains("started at")) {
                    DefaultTestClassDescriptor testDescriptor = new DefaultTestClassDescriptor(this.idGenerator.generateId(), testSuite);
                    this.processor.started((TestDescriptorInternal)testDescriptor, new TestStartEvent(this.clock.getCurrentTime()));
                    this.testDescriptors.push((TestDescriptorInternal)testDescriptor);
                } else {
                    TestDescriptorInternal testDescriptor = this.testDescriptors.pop();
                    TestResult.ResultType resultType = TestResult.ResultType.SUCCESS;
                    if (text.contains("failed at")) {
                        resultType = TestResult.ResultType.FAILURE;
                    }
                    this.processor.completed(testDescriptor.getId(), new TestCompleteEvent(this.clock.getCurrentTime(), resultType));
                }
            } else if (text.startsWith("Test Case")) {
                Matcher testCaseMatcher = TEST_CASE_NAME_PATTERN.matcher(text);
                testCaseMatcher.find();
                String testSuite = testCaseMatcher.group(1);
                String testCase = testCaseMatcher.group(2);
                if (text.contains("started.")) {
                    DefaultTestMethodDescriptor testDescriptor = new DefaultTestMethodDescriptor(this.idGenerator.generateId(), testSuite, testCase);
                    this.processor.started((TestDescriptorInternal)testDescriptor, new TestStartEvent(this.clock.getCurrentTime()));
                    this.testDescriptors.push((TestDescriptorInternal)testDescriptor);
                } else {
                    TestDescriptorInternal testDescriptor = this.testDescriptors.pop();
                    TestResult.ResultType resultType = TestResult.ResultType.SUCCESS;
                    if (text.contains("failed (")) {
                        resultType = TestResult.ResultType.FAILURE;
                        this.processor.failure(testDescriptor.getId(), new Throwable("Dummy failure for HTML generation"));
                    }
                    this.processor.completed(testDescriptor.getId(), new TestCompleteEvent(this.clock.getCurrentTime(), resultType));
                }
            } else {
                TestDescriptorInternal testDescriptor = this.testDescriptors.peek();
                if (testDescriptor != null) {
                    this.processor.output(testDescriptor.getId(), (TestOutputEvent)new DefaultTestOutputEvent(this.destination, text));
                }
            }
        }

        public void endOfStream(@Nullable Throwable failure) {
            if (failure != null) {
                while (!this.testDescriptors.isEmpty()) {
                    this.processor.failure((Object)this.testDescriptors.pop(), failure);
                }
            }
        }
    }

    protected static class NativeTestClassProcessor
    implements TestClassProcessor {
        private TestResultProcessor resultProcessor;
        private ExecHandle execHandle;
        private final ExecHandleBuilder execHandleBuilder;
        private final IdGenerator<?> idGenerator;
        private final Clock clock;
        private final File bundle;

        @Inject
        public NativeTestClassProcessor(Clock clock, MacOSXCTestLocator xcTestLocator, File executable, File workingDir, ExecHandleBuilder execHandleBuilder, IdGenerator<?> idGenerator) {
            this.execHandleBuilder = execHandleBuilder;
            this.idGenerator = idGenerator;
            this.clock = clock;
            this.bundle = executable;
            execHandleBuilder.executable((Object)xcTestLocator.find());
            execHandleBuilder.setWorkingDir(workingDir);
        }

        public void startProcessing(TestResultProcessor resultProcessor) {
            this.resultProcessor = resultProcessor;
        }

        public void processTestClass(TestClassRunInfo testClass) {
            this.execHandle = this.executeTest(testClass.getTestClassName());
            this.execHandle.waitForFinish();
        }

        private ExecHandle executeTest(String testName) {
            this.execHandleBuilder.setArgs(Arrays.asList("-XCTest", testName, this.bundle));
            TextStreamToProcessor stdOut = new TextStreamToProcessor(TestOutputEvent.Destination.StdOut, this.resultProcessor, this.idGenerator, this.clock);
            TextStreamToProcessor stdErr = new TextStreamToProcessor(TestOutputEvent.Destination.StdErr, this.resultProcessor, this.idGenerator, this.clock);
            this.execHandleBuilder.setStandardOutput((OutputStream)new LineBufferingOutputStream((TextStream)stdOut));
            this.execHandleBuilder.setErrorOutput((OutputStream)new LineBufferingOutputStream((TextStream)stdErr));
            ExecHandle handle = this.execHandleBuilder.build();
            return handle.start();
        }

        public void stop() {
            if (this.execHandle != null) {
                this.execHandle.abort();
                this.execHandle.waitForFinish();
            }
        }
    }

    static class NativeTestDetector
    implements Runnable {
        private final TestClassProcessor testClassProcessor;

        NativeTestDetector(TestClassProcessor testClassProcessor) {
            this.testClassProcessor = testClassProcessor;
        }

        @Override
        public void run() {
            DefaultTestClassRunInfo testClass = new DefaultTestClassRunInfo("All");
            this.testClassProcessor.processTestClass((TestClassRunInfo)testClass);
        }
    }
}

