/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.concurrent;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.coroutines.experimental.Continuation;
import kotlin.coroutines.experimental.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.kotlin.dsl.concurrent.Either;
import org.gradle.kotlin.dsl.concurrent.EitherKt;
import org.gradle.kotlin.dsl.concurrent.FutureContinuation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\r\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0012J\u001e\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0096\u0002\u00a2\u0006\u0002\u0010\u0017J\r\u0010\u0018\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0019\u001a\u00020\u000fH\u0016J\b\u0010\u001a\u001a\u00020\u000fH\u0016J\u0015\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u001c\u0010\u001f\u001a\u00020\u001c2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00028\u00000\nH\u0002J\u0010\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u000bH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00028\u0000\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/gradle/kotlin/dsl/concurrent/FutureContinuation;", "T", "Ljava/util/concurrent/Future;", "Lkotlin/coroutines/experimental/Continuation;", "context", "Lkotlin/coroutines/experimental/CoroutineContext;", "(Lkotlin/coroutines/experimental/CoroutineContext;)V", "getContext", "()Lkotlin/coroutines/experimental/CoroutineContext;", "outcome", "Lorg/gradle/kotlin/dsl/concurrent/Either;", "", "outcomeLatch", "Ljava/util/concurrent/CountDownLatch;", "cancel", "", "mayInterruptIfRunning", "get", "()Ljava/lang/Object;", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "(JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;", "getOrThrow", "isCancelled", "isDone", "resume", "", "value", "(Ljava/lang/Object;)V", "resumeWith", "resumeWithException", "exception", "provider_main"})
final class FutureContinuation<T>
implements Future<T>,
Continuation<T> {
    private Either<? extends Throwable, ? extends T> outcome;
    private final CountDownLatch outcomeLatch;
    @NotNull
    private final CoroutineContext context;

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.outcome != null;
    }

    @Override
    public T get() {
        this.outcomeLatch.await();
        return this.getOrThrow();
    }

    @Override
    public T get(long timeout, @NotNull TimeUnit unit) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
        if (!this.outcomeLatch.await(timeout, unit)) {
            throw (Throwable)new TimeoutException();
        }
        return this.getOrThrow();
    }

    private final T getOrThrow() {
        Either<Throwable, T> either = this.outcome;
        if (either == null) {
            Intrinsics.throwNpe();
        }
        return either.fold(getOrThrow.1.INSTANCE, getOrThrow.2.INSTANCE);
    }

    public void resume(T value) {
        this.resumeWith(EitherKt.right(value));
    }

    public void resumeWithException(@NotNull Throwable exception) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        this.resumeWith(EitherKt.left(exception));
    }

    private final void resumeWith(Either<? extends Throwable, ? extends T> outcome) {
        this.outcome = outcome;
        this.outcomeLatch.countDown();
    }

    @NotNull
    public CoroutineContext getContext() {
        return this.context;
    }

    public FutureContinuation(@NotNull CoroutineContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.outcomeLatch = new CountDownLatch(1);
    }
}

