/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.gradle.util.DeprecationLogger;

public final class NameValidator {
    private static final char[] FORBIDDEN_CHARACTERS = new char[]{' ', '/', '\\', ':', '<', '>', '\"', '?', '*', '|'};
    private static final char FORBIDDEN_LEADING_AND_TRAILING_CHARACTER = '.';
    private static final char REPLACEMENT_CHARACTER = '_';

    private NameValidator() {
    }

    public static void validate(String name) {
        if (StringUtils.containsAny((String)name, (char[])FORBIDDEN_CHARACTERS)) {
            DeprecationLogger.nagUserOfDeprecatedThing((String)("The name '" + name + "' contains at least one of the following characters: " + Arrays.toString(FORBIDDEN_CHARACTERS)));
        } else if (name.charAt(0) == '.' || name.charAt(name.length() - 1) == '.') {
            DeprecationLogger.nagUserOfDeprecatedThing((String)("The name '" + name + "' starts or ends with a '" + '.' + "'"));
        }
    }

    public static String asValidName(String name) {
        return name;
    }
}

