/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.rubygrapefruit.platform.ProcessLauncher;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.process.internal.DefaultExecHandle;
import org.gradle.process.internal.ProcessBuilderFactory;
import org.gradle.process.internal.streams.StreamsHandler;

public class ExecHandleRunner
implements Runnable {
    private static final Logger LOGGER = Logging.getLogger(ExecHandleRunner.class);
    private final ProcessBuilderFactory processBuilderFactory;
    private final DefaultExecHandle execHandle;
    private final Lock lock = new ReentrantLock();
    private final ProcessLauncher processLauncher;
    private final ExecutorFactory executorFactory;
    private Process process;
    private boolean aborted;
    private final StreamsHandler streamsHandler;

    public ExecHandleRunner(DefaultExecHandle execHandle, StreamsHandler streamsHandler, ProcessLauncher processLauncher, ExecutorFactory executorFactory) {
        this.processLauncher = processLauncher;
        this.executorFactory = executorFactory;
        if (execHandle == null) {
            throw new IllegalArgumentException("execHandle == null!");
        }
        this.streamsHandler = streamsHandler;
        this.processBuilderFactory = new ProcessBuilderFactory();
        this.execHandle = execHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortProcess() {
        this.lock.lock();
        try {
            this.aborted = true;
            if (this.process != null) {
                LOGGER.debug("Abort requested. Destroying process: {}.", (Object)this.execHandle.getDisplayName());
                this.process.destroy();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void run() {
        try {
            ProcessBuilder processBuilder = this.processBuilderFactory.createProcessBuilder(this.execHandle);
            Process process = this.processLauncher.start(processBuilder);
            this.streamsHandler.connectStreams(process, this.execHandle.getDisplayName(), this.executorFactory);
            this.setProcess(process);
            this.execHandle.started();
            LOGGER.debug("waiting until streams are handled...");
            this.streamsHandler.start();
            if (this.execHandle.isDaemon()) {
                this.streamsHandler.stop();
                this.detached();
            } else {
                int exitValue = process.waitFor();
                this.streamsHandler.stop();
                this.completed(exitValue);
            }
        }
        catch (Throwable t) {
            this.execHandle.failed(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setProcess(Process process) {
        this.lock.lock();
        try {
            this.process = process;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void completed(int exitValue) {
        if (this.aborted) {
            this.execHandle.aborted(exitValue);
        } else {
            this.execHandle.finished(exitValue);
        }
    }

    private void detached() {
        this.execHandle.detached();
    }
}

