/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import org.gradle.cli.AbstractCommandLineConverter;
import org.gradle.cli.CommandLineArgumentException;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;
import org.gradle.concurrent.ParallelismConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParallelismConfigurationCommandLineConverter
extends AbstractCommandLineConverter<ParallelismConfiguration> {
    private static final String PARALLEL = "parallel";
    private static final String MAX_WORKERS = "max-workers";

    public ParallelismConfiguration convert(ParsedCommandLine options, ParallelismConfiguration target) throws CommandLineArgumentException {
        if (options.hasOption(PARALLEL)) {
            target.setParallelProjectExecutionEnabled(true);
        }
        if (options.hasOption(MAX_WORKERS)) {
            String value = options.option(MAX_WORKERS).getValue();
            try {
                int workerCount = Integer.parseInt(value);
                if (workerCount < 1) {
                    this.invalidMaxWorkersSwitchValue(value);
                }
                target.setMaxWorkerCount(workerCount);
            }
            catch (NumberFormatException e) {
                this.invalidMaxWorkersSwitchValue(value);
            }
        }
        return target;
    }

    private ParallelismConfiguration invalidMaxWorkersSwitchValue(String value) {
        throw new CommandLineArgumentException(String.format("Argument value '%s' given for --%s option is invalid (must be a positive, non-zero, integer)", value, MAX_WORKERS));
    }

    public void configure(CommandLineParser parser) {
        parser.option(new String[]{PARALLEL}).hasDescription("Build projects in parallel. Gradle will attempt to determine the optimal number of executor threads to use.").incubating();
        parser.option(new String[]{MAX_WORKERS}).hasArgument().hasDescription("Configure the number of concurrent workers Gradle is allowed to use.").incubating();
    }
}

