/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks;

import groovy.lang.Closure;
import java.io.FilterReader;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.ClosureBackedAction;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.internal.file.FileLookup;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.internal.file.copy.ClosureBackedTransformer;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.CopyActionExecuter;
import org.gradle.api.internal.file.copy.CopySpecInternal;
import org.gradle.api.internal.file.copy.CopySpecResolver;
import org.gradle.api.internal.file.copy.CopySpecSource;
import org.gradle.api.internal.file.copy.DefaultCopySpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.reflect.Instantiator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCopyTask
extends ConventionTask
implements CopySpec,
CopySpecSource {
    private final CopySpecInternal rootSpec = this.createRootSpec();
    private final CopySpecInternal mainSpec;

    protected AbstractCopyTask() {
        this.rootSpec.addChildSpecListener(new CopySpecInternal.CopySpecListener(){

            public void childSpecAdded(CopySpecInternal.CopySpecAddress path, final CopySpecInternal spec) {
                if (AbstractCopyTask.this.getState().getExecuting()) {
                    throw new GradleException("You cannot add child specs at execution time. Consider configuring this task during configuration time or using a separate task to do the configuration.");
                }
                StringBuilder specPropertyNameBuilder = new StringBuilder("rootSpec");
                CopySpecResolver parentResolver = path.unroll(specPropertyNameBuilder);
                final CopySpecResolver resolver = spec.buildResolverRelativeToParent(parentResolver);
                String specPropertyName = specPropertyNameBuilder.toString();
                AbstractCopyTask.this.getInputs().files(new Object[]{new Callable<FileTree>(){

                    @Override
                    public FileTree call() throws Exception {
                        return resolver.getSource();
                    }
                }}).withPropertyName(specPropertyName).withPathSensitivity(PathSensitivity.RELATIVE).skipWhenEmpty();
                AbstractCopyTask.this.getInputs().property(specPropertyName + ".destPath", new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return resolver.getDestPath().getPathString();
                    }
                });
                AbstractCopyTask.this.getInputs().property(specPropertyName + ".caseSensitive", new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return spec.isCaseSensitive();
                    }
                });
                AbstractCopyTask.this.getInputs().property(specPropertyName + ".includeEmptyDirs", new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return spec.getIncludeEmptyDirs();
                    }
                });
                AbstractCopyTask.this.getInputs().property(specPropertyName + ".duplicatesStrategy", new Callable<DuplicatesStrategy>(){

                    @Override
                    public DuplicatesStrategy call() throws Exception {
                        return spec.getDuplicatesStrategy();
                    }
                });
                AbstractCopyTask.this.getInputs().property(specPropertyName + ".dirMode", new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        return spec.getDirMode();
                    }
                });
                AbstractCopyTask.this.getInputs().property(specPropertyName + ".fileMode", new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        return spec.getFileMode();
                    }
                });
                AbstractCopyTask.this.getInputs().property(specPropertyName + ".filteringCharset", new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return spec.getFilteringCharset();
                    }
                });
            }
        });
        this.getOutputs().doNotCacheIf("Has custom actions", (Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                return AbstractCopyTask.this.rootSpec.hasCustomActions();
            }
        });
        this.mainSpec = this.rootSpec.addChild();
    }

    protected CopySpecInternal createRootSpec() {
        Instantiator instantiator = this.getInstantiator();
        FileResolver fileResolver = this.getFileResolver();
        return (CopySpecInternal)instantiator.newInstance(DefaultCopySpec.class, new Object[]{fileResolver, instantiator});
    }

    protected abstract CopyAction createCopyAction();

    @Inject
    protected Instantiator getInstantiator() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected org.gradle.internal.nativeplatform.filesystem.FileSystem getFileSystem() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected FileResolver getFileResolver() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected FileLookup getFileLookup() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected DirectoryFileTreeFactory getDirectoryFileTreeFactory() {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    protected void copy() {
        CopyActionExecuter copyActionExecuter = this.createCopyActionExecuter();
        CopyAction copyAction = this.createCopyAction();
        WorkResult didWork = copyActionExecuter.execute(this.rootSpec, copyAction);
        this.setDidWork(didWork.getDidWork());
    }

    protected CopyActionExecuter createCopyActionExecuter() {
        Instantiator instantiator = this.getInstantiator();
        org.gradle.internal.nativeplatform.filesystem.FileSystem fileSystem = this.getFileSystem();
        return new CopyActionExecuter(instantiator, (FileSystem)fileSystem, false);
    }

    @Internal
    public FileCollection getSource() {
        return this.rootSpec.buildRootResolver().getAllSource();
    }

    @Override
    @Internal
    public CopySpecInternal getRootSpec() {
        return this.rootSpec;
    }

    @Internal
    protected CopySpecInternal getMainSpec() {
        return this.mainSpec;
    }

    @Internal
    public boolean isCaseSensitive() {
        return this.getMainSpec().isCaseSensitive();
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.getMainSpec().setCaseSensitive(caseSensitive);
    }

    @Internal
    public boolean getIncludeEmptyDirs() {
        return this.getMainSpec().getIncludeEmptyDirs();
    }

    public void setIncludeEmptyDirs(boolean includeEmptyDirs) {
        this.getMainSpec().setIncludeEmptyDirs(includeEmptyDirs);
    }

    public void setDuplicatesStrategy(DuplicatesStrategy strategy) {
        this.getRootSpec().setDuplicatesStrategy(strategy);
    }

    @Internal
    public DuplicatesStrategy getDuplicatesStrategy() {
        return this.getRootSpec().getDuplicatesStrategy();
    }

    public AbstractCopyTask from(Object ... sourcePaths) {
        this.getMainSpec().from(sourcePaths);
        return this;
    }

    public AbstractCopyTask filesMatching(String pattern, Action<? super FileCopyDetails> action) {
        this.getMainSpec().filesMatching(pattern, action);
        return this;
    }

    public AbstractCopyTask filesMatching(Iterable<String> patterns, Action<? super FileCopyDetails> action) {
        this.getMainSpec().filesMatching(patterns, action);
        return this;
    }

    public AbstractCopyTask filesNotMatching(String pattern, Action<? super FileCopyDetails> action) {
        this.getMainSpec().filesNotMatching(pattern, action);
        return this;
    }

    public AbstractCopyTask filesNotMatching(Iterable<String> patterns, Action<? super FileCopyDetails> action) {
        this.getMainSpec().filesNotMatching(patterns, action);
        return this;
    }

    public AbstractCopyTask from(Object sourcePath, Closure c) {
        this.getMainSpec().from(sourcePath, (Action)new ClosureBackedAction(c));
        return this;
    }

    public AbstractCopyTask from(Object sourcePath, Action<? super CopySpec> configureAction) {
        this.getMainSpec().from(sourcePath, configureAction);
        return this;
    }

    public CopySpec with(CopySpec ... sourceSpecs) {
        this.getMainSpec().with(sourceSpecs);
        return this;
    }

    public AbstractCopyTask into(Object destDir) {
        this.getRootSpec().into(destDir);
        return this;
    }

    public AbstractCopyTask into(Object destPath, Closure configureClosure) {
        this.getMainSpec().into(destPath, configureClosure);
        return this;
    }

    public CopySpec into(Object destPath, Action<? super CopySpec> copySpec) {
        this.getMainSpec().into(destPath, copySpec);
        return this;
    }

    public AbstractCopyTask include(String ... includes) {
        this.getMainSpec().include(includes);
        return this;
    }

    public AbstractCopyTask include(Iterable<String> includes) {
        this.getMainSpec().include(includes);
        return this;
    }

    public AbstractCopyTask include(Spec<FileTreeElement> includeSpec) {
        this.getMainSpec().include(includeSpec);
        return this;
    }

    public AbstractCopyTask include(Closure includeSpec) {
        this.getMainSpec().include(includeSpec);
        return this;
    }

    public AbstractCopyTask exclude(String ... excludes) {
        this.getMainSpec().exclude(excludes);
        return this;
    }

    public AbstractCopyTask exclude(Iterable<String> excludes) {
        this.getMainSpec().exclude(excludes);
        return this;
    }

    public AbstractCopyTask exclude(Spec<FileTreeElement> excludeSpec) {
        this.getMainSpec().exclude(excludeSpec);
        return this;
    }

    public AbstractCopyTask exclude(Closure excludeSpec) {
        this.getMainSpec().exclude(excludeSpec);
        return this;
    }

    public AbstractCopyTask setIncludes(Iterable<String> includes) {
        this.getMainSpec().setIncludes(includes);
        return this;
    }

    @Internal
    public Set<String> getIncludes() {
        return this.getMainSpec().getIncludes();
    }

    public AbstractCopyTask setExcludes(Iterable<String> excludes) {
        this.getMainSpec().setExcludes(excludes);
        return this;
    }

    @Internal
    public Set<String> getExcludes() {
        return this.getMainSpec().getExcludes();
    }

    public AbstractCopyTask rename(Closure closure) {
        return this.rename(new ClosureBackedTransformer(closure));
    }

    public AbstractCopyTask rename(Transformer<String, String> renamer) {
        this.getMainSpec().rename(renamer);
        return this;
    }

    public AbstractCopyTask rename(String sourceRegEx, String replaceWith) {
        this.getMainSpec().rename(sourceRegEx, replaceWith);
        return this;
    }

    public AbstractCopyTask rename(Pattern sourceRegEx, String replaceWith) {
        this.getMainSpec().rename(sourceRegEx, replaceWith);
        return this;
    }

    public AbstractCopyTask filter(Map<String, ?> properties, Class<? extends FilterReader> filterType) {
        this.getMainSpec().filter(properties, filterType);
        return this;
    }

    public AbstractCopyTask filter(Class<? extends FilterReader> filterType) {
        this.getMainSpec().filter(filterType);
        return this;
    }

    public AbstractCopyTask filter(Closure closure) {
        this.getMainSpec().filter(closure);
        return this;
    }

    public AbstractCopyTask filter(Transformer<String, String> transformer) {
        this.getMainSpec().filter(transformer);
        return this;
    }

    public AbstractCopyTask expand(Map<String, ?> properties) {
        this.getMainSpec().expand(properties);
        return this;
    }

    @Internal
    public Integer getDirMode() {
        return this.getMainSpec().getDirMode();
    }

    @Internal
    public Integer getFileMode() {
        return this.getMainSpec().getFileMode();
    }

    public AbstractCopyTask setDirMode(Integer mode) {
        this.getMainSpec().setDirMode(mode);
        return this;
    }

    public AbstractCopyTask setFileMode(Integer mode) {
        this.getMainSpec().setFileMode(mode);
        return this;
    }

    public AbstractCopyTask eachFile(Action<? super FileCopyDetails> action) {
        this.getMainSpec().eachFile(action);
        return this;
    }

    public AbstractCopyTask eachFile(Closure closure) {
        this.getMainSpec().eachFile(closure);
        return this;
    }

    @Internal
    public String getFilteringCharset() {
        return this.getMainSpec().getFilteringCharset();
    }

    public void setFilteringCharset(String charset) {
        this.getMainSpec().setFilteringCharset(charset);
    }
}

