/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import javax.annotation.Nullable;
import org.gradle.api.internal.provider.AbstractProvider;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.provider.PropertyState;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Cast;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPropertyState<T>
implements PropertyState<T>,
ProviderInternal<T> {
    private final Class<T> type;
    private Provider<? extends T> provider = Providers.notDefined();

    public DefaultPropertyState(Class<T> type) {
        this.type = type;
    }

    @Override
    @Nullable
    public Class<T> getType() {
        return this.type;
    }

    public void set(T value) {
        if (value == null) {
            this.provider = Providers.notDefined();
            return;
        }
        if (!this.type.isInstance(value)) {
            throw new IllegalArgumentException(String.format("Cannot set the value of a property of type %s using an instance of type %s.", this.type.getName(), value.getClass().getName()));
        }
        this.provider = Providers.of(value);
    }

    protected Provider<? extends T> getProvider() {
        return this.provider;
    }

    public void set(final Provider<? extends T> provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Cannot set the value of a property using a null provider.");
        }
        ProviderInternal p = (ProviderInternal)Cast.uncheckedCast(provider);
        if (p.getType() != null && !this.type.isAssignableFrom(p.getType())) {
            throw new IllegalArgumentException(String.format("Cannot set the value of a property of type %s using a provider of type %s.", this.type.getName(), p.getType().getName()));
        }
        if (p.getType() == null) {
            p = new AbstractProvider<T>(){

                @Override
                @Nullable
                public Class<T> getType() {
                    return null;
                }

                public T getOrNull() {
                    Object value = provider.getOrNull();
                    if (value == null || DefaultPropertyState.this.type.isInstance(value)) {
                        return value;
                    }
                    throw new IllegalArgumentException(String.format("Cannot get the value of a property of type %s as the provider associated with this property returned a value of type %s.", DefaultPropertyState.this.type.getName(), value.getClass().getName()));
                }
            };
        }
        this.provider = p;
    }

    public T get() {
        return (T)this.provider.get();
    }

    public T getOrNull() {
        return (T)this.provider.getOrNull();
    }

    public boolean isPresent() {
        return this.provider.isPresent();
    }

    public String toString() {
        return String.format("value: %s", this.getOrNull());
    }
}

