/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.util.Ref;
import org.jetbrains.kotlin.com.intellij.util.diff.FlyweightCapableTreeStructure;

public class ASTStructure
implements FlyweightCapableTreeStructure<ASTNode> {
    private final ASTNode myRoot;

    public ASTStructure(@NotNull ASTNode root2) {
        if (root2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/ASTStructure", "<init>"));
        }
        this.myRoot = root2;
    }

    @Override
    @NotNull
    public ASTNode getRoot() {
        ASTNode aSTNode = this.myRoot;
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/ASTStructure", "getRoot"));
        }
        return aSTNode;
    }

    @Override
    public ASTNode getParent(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/ASTStructure", "getParent"));
        }
        return node.getTreeParent();
    }

    @Override
    @NotNull
    public ASTNode prepareForGetChildren(@NotNull ASTNode astNode) {
        if (astNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "astNode", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/ASTStructure", "prepareForGetChildren"));
        }
        ASTNode aSTNode = astNode;
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/ASTStructure", "prepareForGetChildren"));
        }
        return aSTNode;
    }

    @Override
    public int getChildren(@NotNull ASTNode astNode, @NotNull Ref<ASTNode[]> into) {
        if (astNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "astNode", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/ASTStructure", "getChildren"));
        }
        if (into == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "into", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/ASTStructure", "getChildren"));
        }
        ASTNode child = astNode.getFirstChildNode();
        if (child == null) {
            return 0;
        }
        ASTNode[] store2 = into.get();
        if (store2 == null) {
            store2 = new ASTNode[10];
            into.set(store2);
        }
        int count = 0;
        while (child != null) {
            if (count >= store2.length) {
                ASTNode[] newStore = new ASTNode[count * 3 / 2];
                System.arraycopy(store2, 0, newStore, 0, count);
                into.set(newStore);
                store2 = newStore;
            }
            store2[count++] = child;
            child = child.getTreeNext();
        }
        return count;
    }

    public void disposeChildren(ASTNode[] nodes, int count) {
    }

    @Override
    @NotNull
    public CharSequence toString(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/ASTStructure", "toString"));
        }
        CharSequence charSequence = node.getChars();
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/ASTStructure", "toString"));
        }
        return charSequence;
    }

    @Override
    public int getStartOffset(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/ASTStructure", "getStartOffset"));
        }
        return node.getStartOffset();
    }

    @Override
    public int getEndOffset(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/ASTStructure", "getEndOffset"));
        }
        return node.getStartOffset() + node.getTextLength();
    }
}

