/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph;

import java.util.Arrays;
import java.util.List;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.DependencyArtifactsVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;

public class CompositeDependencyArtifactsVisitor
implements DependencyArtifactsVisitor {
    private final List<DependencyArtifactsVisitor> visitors;

    public CompositeDependencyArtifactsVisitor(DependencyArtifactsVisitor ... visitors) {
        this.visitors = Arrays.asList(visitors);
    }

    @Override
    public void startArtifacts(DependencyGraphNode root) {
        for (DependencyArtifactsVisitor visitor : this.visitors) {
            visitor.startArtifacts(root);
        }
    }

    @Override
    public void visitArtifacts(DependencyGraphNode from, DependencyGraphNode to, ArtifactSet artifacts) {
        for (DependencyArtifactsVisitor visitor : this.visitors) {
            visitor.visitArtifacts(from, to, artifacts);
        }
    }

    @Override
    public void finishArtifacts() {
        for (DependencyArtifactsVisitor visitor : this.visitors) {
            visitor.finishArtifacts();
        }
    }
}

