/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental;

import java.io.File;

public class ResolvedInclude {
    private final String include;
    private final File dependencyFile;

    public ResolvedInclude(String include, File dependencyFile) {
        this.include = include;
        this.dependencyFile = dependencyFile;
    }

    public boolean isUnknown() {
        return this.dependencyFile == null;
    }

    public boolean isMaybeMacro() {
        return this.isUnknown() && ResolvedInclude.isMacro(this.include);
    }

    private static boolean isMacro(String token) {
        if (token.isEmpty() || !Character.isJavaIdentifierStart(token.charAt(0))) {
            return false;
        }
        if (token.length() > 1) {
            for (char c : token.substring(1).toCharArray()) {
                if (Character.isJavaIdentifierPart(c)) continue;
                return false;
            }
        }
        return true;
    }

    public String getInclude() {
        return this.include;
    }

    public File getFile() {
        return this.dependencyFile;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResolvedInclude that = (ResolvedInclude)o;
        if (!this.include.equals(that.include)) {
            return false;
        }
        return !(this.dependencyFile == null ? that.dependencyFile != null : !this.dependencyFile.equals(that.dependencyFile));
    }

    public int hashCode() {
        return this.include.hashCode();
    }

    public String toString() {
        return "Resolved include '" + this.include + "' -> '" + this.resolved() + "'";
    }

    private String resolved() {
        if (this.isUnknown()) {
            return "???";
        }
        return this.dependencyFile.getAbsolutePath();
    }
}

