/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.daemon;

import java.io.Serializable;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.internal.reflect.DirectInstantiator;
import org.gradle.internal.reflect.ObjectInstantiationException;
import org.gradle.process.internal.daemon.AbstractWorkerDaemonExecutor;
import org.gradle.process.internal.daemon.WorkSpec;
import org.gradle.process.internal.daemon.WorkerDaemonAction;
import org.gradle.process.internal.daemon.WorkerDaemonFactory;
import org.gradle.process.internal.daemon.WorkerDaemonProtocol;
import org.gradle.process.internal.daemon.WorkerDaemonResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkerDaemonRunnableExecutor
extends AbstractWorkerDaemonExecutor<Runnable> {
    WorkerDaemonRunnableExecutor(WorkerDaemonFactory workerDaemonFactory, FileResolver fileResolver, Class<? extends Runnable> implementationClass, Class<? extends WorkerDaemonProtocol> serverImplementationClass) {
        super(workerDaemonFactory, fileResolver, implementationClass, serverImplementationClass);
    }

    @Override
    WorkSpec getSpec() {
        return new ParamSpec(this.getParams());
    }

    @Override
    WorkerDaemonAction getAction() {
        return new WrappedDaemonRunnable(this.getImplementationClass());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WrappedDaemonRunnable
    implements WorkerDaemonAction<ParamSpec> {
        private final Class<? extends Runnable> runnableClass;

        WrappedDaemonRunnable(Class<? extends Runnable> runnableClass) {
            this.runnableClass = runnableClass;
        }

        @Override
        public WorkerDaemonResult execute(ParamSpec spec) {
            try {
                Runnable runnable = (Runnable)DirectInstantiator.instantiate(this.runnableClass, (Object[])spec.getParams());
                runnable.run();
                return new WorkerDaemonResult(true, null);
            }
            catch (ObjectInstantiationException e) {
                return new WorkerDaemonResult(true, e.getCause());
            }
            catch (Throwable t) {
                return new WorkerDaemonResult(true, t);
            }
        }

        @Override
        public String getDescription() {
            return this.runnableClass.getName();
        }
    }

    private static class ParamSpec
    implements WorkSpec {
        final Serializable[] params;

        ParamSpec(Serializable[] params) {
            this.params = params;
        }

        public Serializable[] getParams() {
            return this.params;
        }
    }
}

