/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.hash.HashCode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.DefaultBuildCacheKeyBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TaskExecution {
    private String taskClass;
    private HashCode taskClassLoaderHash;
    private HashCode taskActionsClassLoaderHash;
    private Map<String, Object> inputProperties;
    private Iterable<String> outputPropertyNamesForCacheKey;
    private ImmutableSet<String> declaredOutputFilePaths;

    public ImmutableSet<String> getOutputPropertyNamesForCacheKey() {
        return ImmutableSet.copyOf(this.outputPropertyNamesForCacheKey);
    }

    public void setOutputPropertyNamesForCacheKey(Iterable<String> outputPropertyNames) {
        this.outputPropertyNamesForCacheKey = outputPropertyNames;
    }

    public ImmutableSet<String> getDeclaredOutputFilePaths() {
        return this.declaredOutputFilePaths;
    }

    public void setDeclaredOutputFilePaths(ImmutableSet<String> declaredOutputFilePaths) {
        this.declaredOutputFilePaths = declaredOutputFilePaths;
    }

    public String getTaskClass() {
        return this.taskClass;
    }

    public void setTaskClass(String taskClass) {
        this.taskClass = taskClass;
    }

    public HashCode getTaskClassLoaderHash() {
        return this.taskClassLoaderHash;
    }

    public void setTaskClassLoaderHash(HashCode taskClassLoaderHash) {
        this.taskClassLoaderHash = taskClassLoaderHash;
    }

    public HashCode getTaskActionsClassLoaderHash() {
        return this.taskActionsClassLoaderHash;
    }

    public void setTaskActionsClassLoaderHash(HashCode taskActionsClassLoaderHash) {
        this.taskActionsClassLoaderHash = taskActionsClassLoaderHash;
    }

    public Map<String, Object> getInputProperties() {
        return this.inputProperties;
    }

    public void setInputProperties(Map<String, Object> inputProperties) {
        this.inputProperties = inputProperties;
    }

    public abstract Map<String, FileCollectionSnapshot> getOutputFilesSnapshot();

    public abstract void setOutputFilesSnapshot(Map<String, FileCollectionSnapshot> var1);

    public abstract Map<String, FileCollectionSnapshot> getInputFilesSnapshot();

    public abstract void setInputFilesSnapshot(Map<String, FileCollectionSnapshot> var1);

    public abstract FileCollectionSnapshot getDiscoveredInputFilesSnapshot();

    public abstract void setDiscoveredInputFilesSnapshot(FileCollectionSnapshot var1);

    public BuildCacheKey calculateCacheKey() {
        if (this.taskClassLoaderHash == null || this.taskActionsClassLoaderHash == null) {
            return null;
        }
        DefaultBuildCacheKeyBuilder builder = new DefaultBuildCacheKeyBuilder();
        builder.putString(this.taskClass);
        builder.putBytes(this.taskClassLoaderHash.asBytes());
        builder.putBytes(this.taskActionsClassLoaderHash.asBytes());
        for (Map.Entry entry : TaskExecution.sortEntries(this.inputProperties.entrySet())) {
            builder.putString(entry.getKey());
            Object value = entry.getValue();
            builder.appendToCacheKey(value);
        }
        for (Map.Entry entry : TaskExecution.sortEntries(this.getInputFilesSnapshot().entrySet())) {
            builder.putString(entry.getKey());
            FileCollectionSnapshot snapshot = (FileCollectionSnapshot)entry.getValue();
            snapshot.appendToCacheKey(builder);
        }
        for (String cacheableOutputPropertyName : TaskExecution.sortStrings(this.getOutputPropertyNamesForCacheKey())) {
            builder.putString(cacheableOutputPropertyName);
        }
        return builder.build();
    }

    private static <T> List<Map.Entry<String, T>> sortEntries(Set<Map.Entry<String, T>> entries) {
        ArrayList sortedEntries = Lists.newArrayList(entries);
        Collections.sort(sortedEntries, new Comparator<Map.Entry<String, T>>(){

            @Override
            public int compare(Map.Entry<String, T> o1, Map.Entry<String, T> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        return sortedEntries;
    }

    private static List<String> sortStrings(Collection<String> entries) {
        ArrayList sortedEntries = Lists.newArrayList(entries);
        Collections.sort(sortedEntries);
        return sortedEntries;
    }
}

