/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.AbstractFileCollectionSnapshotter;
import org.gradle.api.internal.changedetection.state.ClasspathSnapshotter;
import org.gradle.api.internal.changedetection.state.DefaultFileDetails;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotter;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.internal.hash.FileHasher;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultClasspathSnapshotter
extends AbstractFileCollectionSnapshotter
implements ClasspathSnapshotter {
    private static final Comparator<DefaultFileDetails> FILE_DETAILS_COMPARATOR = new Comparator<DefaultFileDetails>(){

        @Override
        public int compare(DefaultFileDetails o1, DefaultFileDetails o2) {
            return o1.getPath().compareTo(o2.getPath());
        }
    };

    public DefaultClasspathSnapshotter(FileHasher hasher, StringInterner stringInterner, FileSystem fileSystem, DirectoryFileTreeFactory directoryFileTreeFactory) {
        super(hasher, stringInterner, fileSystem, directoryFileTreeFactory);
    }

    @Override
    public Class<? extends FileCollectionSnapshotter> getRegisteredType() {
        return ClasspathSnapshotter.class;
    }

    @Override
    protected void visitTreeOrBackingFile(FileTreeInternal fileTree, List<DefaultFileDetails> fileTreeElements) {
        ArrayList subElements = Lists.newArrayList();
        super.visitTreeOrBackingFile(fileTree, subElements);
        Collections.sort(subElements, FILE_DETAILS_COMPARATOR);
        fileTreeElements.addAll(subElements);
    }

    @Override
    protected void visitDirectoryTree(DirectoryFileTree directoryTree, List<DefaultFileDetails> fileTreeElements) {
        ArrayList subElements = Lists.newArrayList();
        super.visitDirectoryTree(directoryTree, subElements);
        Collections.sort(subElements, FILE_DETAILS_COMPARATOR);
        fileTreeElements.addAll(subElements);
    }
}

