/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.load.kotlin.DeserializedDescriptorResolver;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinClassFinder;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinarySourceElement;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.serialization.ClassData;
import kotlin.reflect.jvm.internal.impl.serialization.ClassDataWithSource;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ClassDataFinder;
import kotlin.reflect.jvm.internal.impl.serialization.jvm.JvmProtoBufUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaClassDataFinder
implements ClassDataFinder {
    private final KotlinClassFinder kotlinClassFinder;
    private final DeserializedDescriptorResolver deserializedDescriptorResolver;

    @Override
    @Nullable
    public ClassDataWithSource findClassData(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        KotlinJvmBinaryClass kotlinJvmBinaryClass = this.kotlinClassFinder.findKotlinClass(classId);
        if (kotlinJvmBinaryClass == null) {
            return null;
        }
        KotlinJvmBinaryClass kotlinJvmBinaryClass2 = kotlinJvmBinaryClass;
        boolean bl = Intrinsics.areEqual((Object)kotlinJvmBinaryClass2.getClassId(), (Object)classId);
        if (_Assertions.ENABLED && !bl) {
            String string = "Class with incorrect id found: expected " + classId + ", actual " + kotlinJvmBinaryClass2.getClassId();
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        String[] stringArray = this.deserializedDescriptorResolver.readData$kotlin_core(kotlinJvmBinaryClass2, DeserializedDescriptorResolver.Companion.getKOTLIN_CLASS$kotlin_core());
        if (stringArray == null) {
            return null;
        }
        String[] data2 = stringArray;
        String[] stringArray2 = kotlinJvmBinaryClass2.getClassHeader().getStrings();
        if (stringArray2 == null) {
            String string = "String table not found in " + kotlinJvmBinaryClass2;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        String[] strings = stringArray2;
        ClassData classData = JvmProtoBufUtil.readClassDataFrom(data2, strings);
        return new ClassDataWithSource(classData, new KotlinJvmBinarySourceElement(kotlinJvmBinaryClass2));
    }

    public JavaClassDataFinder(@NotNull KotlinClassFinder kotlinClassFinder, @NotNull DeserializedDescriptorResolver deserializedDescriptorResolver) {
        Intrinsics.checkParameterIsNotNull((Object)kotlinClassFinder, (String)"kotlinClassFinder");
        Intrinsics.checkParameterIsNotNull((Object)deserializedDescriptorResolver, (String)"deserializedDescriptorResolver");
        this.kotlinClassFinder = kotlinClassFinder;
        this.deserializedDescriptorResolver = deserializedDescriptorResolver;
    }
}

