/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants.evaluate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValueFactory;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluatorVisitor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 /2\u00020\u0001:\u0001/B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J(\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010J$\u0010\u0016\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00172\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010J$\u0010\u0018\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ.\u0010\u001d\u001a\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u001f\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0018\u00010\u001e2\u0006\u0010\u0015\u001a\u00020 2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001cH\u0002J1\u0010$\u001a\u0012\u0012\u0004\u0012\u00020\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170%2\n\u0010&\u001a\u0006\u0012\u0002\b\u00030'2\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b(J*\u0010)\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u001f2\u0006\u0010*\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J(\u0010+\u001a\u00020\f2\u0006\u0010,\u001a\u00020\u00102\b\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\u0006\u0010-\u001a\u00020.2\u0006\u0010\u0011\u001a\u00020\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "(Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;)V", "getBuiltIns$kotlin_compiler", "()Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "constantValueFactory", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValueFactory;", "getConstantValueFactory$kotlin_compiler", "()Lorg/jetbrains/kotlin/resolve/constants/ConstantValueFactory;", "checkCompileTimeConstant", "", "argumentExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "evaluateExpression", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "expression", "evaluateToConstantValue", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "getAnnotationArgumentValue", "parameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "resolvedArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;", "getArgumentExpressionsForArrayCall", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "hasSpread", "", "argument", "resolveAnnotationArguments", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "resolveAnnotationArguments$kotlin_compiler", "resolveAnnotationValueArguments", "resolvedValueArgument", "updateNumberType", "numberType", "statementFilter", "Lorg/jetbrains/kotlin/resolve/StatementFilter;", "Companion", "kotlin-compiler"})
public final class ConstantExpressionEvaluator {
    @NotNull
    private final ConstantValueFactory constantValueFactory;
    @NotNull
    private final KotlinBuiltIns builtIns;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final ConstantValueFactory getConstantValueFactory$kotlin_compiler() {
        return this.constantValueFactory;
    }

    public final void updateNumberType(@NotNull KotlinType numberType, @Nullable KtExpression expression, @NotNull StatementFilter statementFilter, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(numberType, "numberType");
        Intrinsics.checkParameterIsNotNull(statementFilter, "statementFilter");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        if (expression == null) {
            return;
        }
        BindingContextUtils.updateRecordedType(numberType, expression, trace, false);
        if (!(expression instanceof KtConstantExpression)) {
            KtExpression deparenthesized = KtPsiUtil.getLastElementDeparenthesized(expression, statementFilter);
            if (deparenthesized != expression) {
                this.updateNumberType(numberType, deparenthesized, statementFilter, trace);
            }
            return;
        }
        this.evaluateExpression(expression, trace, numberType);
    }

    @NotNull
    public final Map<ValueParameterDescriptor, ConstantValue<?>> resolveAnnotationArguments$kotlin_compiler(@NotNull ResolvedCall<?> resolvedCall2, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        HashMap arguments2 = new HashMap();
        Iterator<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>> iterator2 = resolvedCall2.getValueArguments().entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry;
            Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry2 = entry = iterator2.next();
            ValueParameterDescriptor parameterDescriptor = entry2.getKey();
            Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry3 = entry;
            ResolvedValueArgument resolvedArgument = entry3.getValue();
            ValueParameterDescriptor valueParameterDescriptor = parameterDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor, "parameterDescriptor");
            ResolvedValueArgument resolvedValueArgument = resolvedArgument;
            Intrinsics.checkExpressionValueIsNotNull(resolvedValueArgument, "resolvedArgument");
            ConstantValue<?> value = this.getAnnotationArgumentValue(trace, valueParameterDescriptor, resolvedValueArgument);
            if (value == null) continue;
            arguments2.put(parameterDescriptor, value);
        }
        return arguments2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ConstantValue<?> getAnnotationArgumentValue(@NotNull BindingTrace trace, @NotNull ValueParameterDescriptor parameterDescriptor, @NotNull ResolvedValueArgument resolvedArgument) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        KotlinType constantType;
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(parameterDescriptor, "parameterDescriptor");
        Intrinsics.checkParameterIsNotNull(resolvedArgument, "resolvedArgument");
        KotlinType varargElementType = parameterDescriptor.getVarargElementType();
        boolean argumentsAsVararg = varargElementType != null && !this.hasSpread(resolvedArgument);
        KotlinType kotlinType = constantType = argumentsAsVararg ? varargElementType : parameterDescriptor.getType();
        if (kotlinType == null) {
            Intrinsics.throwNpe();
        }
        List<CompileTimeConstant<?>> compileTimeConstants = this.resolveAnnotationValueArguments(resolvedArgument, kotlinType, trace);
        Iterable iterable = compileTimeConstants;
        void var9_9 = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            CompileTimeConstant compileTimeConstant = (CompileTimeConstant)item$iv$iv;
            void var14_14 = destination$iv$iv;
            ConstantValue constantValue = it.toConstantValue(constantType);
            var14_14.add(constantValue);
        }
        List constants = (List)destination$iv$iv;
        if (argumentsAsVararg) {
            if (parameterDescriptor.declaresDefaultValue() && compileTimeConstants.isEmpty()) {
                return null;
            }
            KotlinType kotlinType2 = parameterDescriptor.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "parameterDescriptor.type");
            return this.constantValueFactory.createArrayValue(constants, kotlinType2);
        }
        return (ConstantValue)CollectionsKt.lastOrNull(constants);
    }

    private final void checkCompileTimeConstant(KtExpression argumentExpression, KotlinType expectedType, BindingTrace trace) {
        Pair<List<KtExpression>, KotlinType> arrayArgument;
        KotlinType expressionType = trace.getType(argumentExpression);
        if (expressionType == null || !KotlinTypeChecker.DEFAULT.isSubtypeOf(expressionType, expectedType)) {
            return;
        }
        if (argumentExpression instanceof KtCallExpression && (arrayArgument = this.getArgumentExpressionsForArrayCall((KtCallExpression)argumentExpression, trace)) != null) {
            for (KtExpression expression : arrayArgument.getFirst()) {
                KotlinType kotlinType = arrayArgument.getSecond();
                if (kotlinType == null) {
                    Intrinsics.throwNpe();
                }
                this.checkCompileTimeConstant(expression, kotlinType, trace);
            }
        }
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.bindingContext");
        CompileTimeConstant<?> constant = Companion.getConstant(argumentExpression, bindingContext);
        if (constant != null && constant.getCanBeUsedInAnnotations()) {
            if (constant.getUsesNonConstValAsConstant()) {
                trace.report(Errors.NON_CONST_VAL_USED_IN_CONSTANT_EXPRESSION.on((KtExpression)((PsiElement)argumentExpression)));
            }
            return;
        }
        ClassifierDescriptor descriptor2 = expressionType.getConstructor().getDeclarationDescriptor();
        if (descriptor2 != null && DescriptorUtils.isEnumClass(descriptor2)) {
            trace.report(Errors.ANNOTATION_PARAMETER_MUST_BE_ENUM_CONST.on((KtExpression)((PsiElement)argumentExpression)));
        } else if (descriptor2 instanceof ClassDescriptor && KotlinBuiltIns.isKClass((ClassDescriptor)descriptor2)) {
            trace.report(Errors.ANNOTATION_PARAMETER_MUST_BE_KCLASS_LITERAL.on((KtExpression)((PsiElement)argumentExpression)));
        } else {
            trace.report(Errors.ANNOTATION_PARAMETER_MUST_BE_CONST.on((KtExpression)((PsiElement)argumentExpression)));
        }
    }

    private final Pair<List<KtExpression>, KotlinType> getArgumentExpressionsForArrayCall(KtCallExpression expression, BindingTrace trace) {
        KtElement ktElement = expression;
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.bindingContext");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
        if (resolvedCall2 == null || !CompileTimeConstantUtils.isArrayMethodCall(resolvedCall2)) {
            return null;
        }
        Map.Entry argumentEntry = (Map.Entry)CollectionsKt.single((Iterable)resolvedCall2.getValueArguments().entrySet());
        KotlinType kotlinType = ((ValueParameterDescriptor)argumentEntry.getKey()).getVarargElementType();
        if (kotlinType == null) {
            return null;
        }
        KotlinType elementType = kotlinType;
        ArrayList<KtExpression> result2 = CollectionsKt.arrayListOf(new KtExpression[0]);
        for (ValueArgument valueArgument : ((ResolvedValueArgument)argumentEntry.getValue()).getArguments()) {
            KtExpression valueArgumentExpression = valueArgument.getArgumentExpression();
            if (valueArgumentExpression == null) continue;
            result2.add(valueArgumentExpression);
        }
        return new Pair<List<KtExpression>, KotlinType>(result2, elementType);
    }

    private final boolean hasSpread(ResolvedValueArgument argument) {
        List<ValueArgument> arguments2 = argument.getArguments();
        return arguments2.size() == 1 && arguments2.get(0).getSpreadElement() != null;
    }

    private final List<CompileTimeConstant<?>> resolveAnnotationValueArguments(ResolvedValueArgument resolvedValueArgument, KotlinType expectedType, BindingTrace trace) {
        ArrayList constants = new ArrayList();
        for (ValueArgument argument : resolvedValueArgument.getArguments()) {
            KtExpression argumentExpression;
            if (argument.getArgumentExpression() == null) {
                continue;
            }
            CompileTimeConstant<?> constant = this.evaluateExpression(argumentExpression, trace, expectedType);
            if (constant instanceof IntegerValueTypeConstant) {
                KotlinType defaultType2 = ((IntegerValueTypeConstant)constant).getType(expectedType);
                this.updateNumberType(defaultType2, argumentExpression, StatementFilter.NONE, trace);
            }
            if (constant != null) {
                constants.add(constant);
            }
            this.checkCompileTimeConstant(argumentExpression, expectedType, trace);
        }
        return constants;
    }

    @Nullable
    public final CompileTimeConstant<?> evaluateExpression(@NotNull KtExpression expression, @NotNull BindingTrace trace, @Nullable KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        ConstantExpressionEvaluatorVisitor visitor2 = new ConstantExpressionEvaluatorVisitor(this, trace);
        CompileTimeConstant compileTimeConstant = visitor2.evaluate(expression, expectedType);
        if (compileTimeConstant == null) {
            return null;
        }
        CompileTimeConstant constant = compileTimeConstant;
        return !constant.isError() ? constant : (CompileTimeConstant)null;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ CompileTimeConstant evaluateExpression$default(ConstantExpressionEvaluator constantExpressionEvaluator, KtExpression ktExpression, BindingTrace bindingTrace, KotlinType kotlinType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: evaluateExpression");
        }
        if ((n & 4) != 0) {
            kotlinType = TypeUtils.NO_EXPECTED_TYPE;
        }
        return constantExpressionEvaluator.evaluateExpression(ktExpression, bindingTrace, kotlinType);
    }

    @Nullable
    public final ConstantValue<?> evaluateToConstantValue(@NotNull KtExpression expression, @NotNull BindingTrace trace, @NotNull KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(expectedType, "expectedType");
        CompileTimeConstant<?> compileTimeConstant = this.evaluateExpression(expression, trace, expectedType);
        return compileTimeConstant != null ? compileTimeConstant.toConstantValue(expectedType) : null;
    }

    @NotNull
    public final KotlinBuiltIns getBuiltIns$kotlin_compiler() {
        return this.builtIns;
    }

    public ConstantExpressionEvaluator(@NotNull KotlinBuiltIns builtIns) {
        Intrinsics.checkParameterIsNotNull(builtIns, "builtIns");
        this.builtIns = builtIns;
        this.constantValueFactory = new ConstantValueFactory(this.builtIns);
    }

    @JvmStatic
    @Nullable
    public static final CompileTimeConstant<?> getConstant(@NotNull KtExpression expression, @NotNull BindingContext bindingContext) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        return Companion.getConstant(expression, bindingContext);
    }

    @JvmStatic
    @Nullable
    public static final CompileTimeConstant<?> getPossiblyErrorConstant(@NotNull KtExpression expression, @NotNull BindingContext bindingContext) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        return Companion.getPossiblyErrorConstant(expression, bindingContext);
    }

    @Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u001e\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator$Companion;", "", "()V", "getConstant", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getPossiblyErrorConstant", "kotlin-compiler"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final CompileTimeConstant<?> getConstant(@NotNull KtExpression expression, @NotNull BindingContext bindingContext) {
            Intrinsics.checkParameterIsNotNull(expression, "expression");
            Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
            CompileTimeConstant compileTimeConstant = this.getPossiblyErrorConstant(expression, bindingContext);
            if (compileTimeConstant == null) {
                return null;
            }
            CompileTimeConstant constant = compileTimeConstant;
            return !constant.isError() ? constant : (CompileTimeConstant)null;
        }

        @JvmStatic
        @Nullable
        public final CompileTimeConstant<?> getPossiblyErrorConstant(@NotNull KtExpression expression, @NotNull BindingContext bindingContext) {
            Intrinsics.checkParameterIsNotNull(expression, "expression");
            Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
            return (CompileTimeConstant)bindingContext.get(BindingContext.COMPILE_TIME_VALUE, expression);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

