/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.lang.java.parser;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.codeInsight.daemon.JavaErrorMessages;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilder;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilderUtil;
import org.jetbrains.kotlin.com.intellij.lang.java.parser.JavaParser;
import org.jetbrains.kotlin.com.intellij.lang.java.parser.JavaParserUtil;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.util.BitUtil;

public class ReferenceParser {
    private static final TokenSet WILDCARD_KEYWORD_SET = TokenSet.create(JavaTokenType.EXTENDS_KEYWORD, JavaTokenType.SUPER_KEYWORD);
    private final JavaParser myParser;

    public ReferenceParser(@NotNull JavaParser javaParser) {
        if (javaParser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaParser", "org/jetbrains/kotlin/com/intellij/lang/java/parser/ReferenceParser", "<init>"));
        }
        this.myParser = javaParser;
    }

    @Nullable
    public PsiBuilder.Marker parseType(PsiBuilder builder, int flags) {
        TypeInfo typeInfo = this.parseTypeInfo(builder, flags);
        return typeInfo != null ? typeInfo.marker : null;
    }

    @Nullable
    public TypeInfo parseTypeInfo(PsiBuilder builder, int flags) {
        TypeInfo typeInfo = this.parseTypeInfo(builder, flags, false);
        if (typeInfo != null) {
            IElementType operator;
            assert (!BitUtil.isSet(flags, 16) || !BitUtil.isSet(flags, 32)) : "don't set both flags simultaneously";
            IElementType iElementType = BitUtil.isSet(flags, 16) ? JavaTokenType.OR : (operator = BitUtil.isSet(flags, 32) ? JavaTokenType.AND : null);
            if (operator != null && builder.getTokenType() == operator) {
                typeInfo.marker = typeInfo.marker.precede();
                while (builder.getTokenType() == operator) {
                    builder.advanceLexer();
                    IElementType tokenType = builder.getTokenType();
                    if (tokenType != JavaTokenType.IDENTIFIER && tokenType != JavaTokenType.AT) {
                        JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
                    }
                    this.parseTypeInfo(builder, flags, false);
                }
                typeInfo.marker.done(JavaElementType.TYPE);
            }
        }
        return typeInfo;
    }

    @Nullable
    private TypeInfo parseTypeInfo(PsiBuilder builder, int flags, boolean badWildcard) {
        if (builder.getTokenType() == null) {
            return null;
        }
        TypeInfo typeInfo = new TypeInfo();
        PsiBuilder.Marker type2 = builder.mark();
        PsiBuilder.Marker anno = this.myParser.getDeclarationParser().parseAnnotations(builder);
        IElementType tokenType = builder.getTokenType();
        if (PsiBuilderUtil.expect(builder, ElementType.PRIMITIVE_TYPE_BIT_SET)) {
            typeInfo.isPrimitive = true;
        } else {
            if ((BitUtil.isSet(flags, 4) || badWildcard) && (tokenType == JavaTokenType.QUEST || ReferenceParser.isKeywordAny(builder))) {
                if (tokenType == JavaTokenType.QUEST) {
                    builder.advanceLexer();
                } else {
                    ReferenceParser.dummy(builder);
                }
                this.completeWildcardType(builder, BitUtil.isSet(flags, 4), type2);
                typeInfo.marker = type2;
                return typeInfo;
            }
            if (tokenType == JavaTokenType.IDENTIFIER) {
                this.parseJavaCodeReference(builder, BitUtil.isSet(flags, 1), true, false, false, false, BitUtil.isSet(flags, 8), typeInfo);
            } else {
                if (BitUtil.isSet(flags, 8) && tokenType == JavaTokenType.GT) {
                    if (anno == null) {
                        JavaParserUtil.emptyElement(builder, JavaElementType.DIAMOND_TYPE);
                    } else {
                        JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
                        typeInfo.hasErrors = true;
                    }
                    type2.done(JavaElementType.TYPE);
                    typeInfo.marker = type2;
                    return typeInfo;
                }
                type2.drop();
                if (anno != null && BitUtil.isSet(flags, 64)) {
                    JavaParserUtil.error(builder, JavaErrorMessages.message("expected.type", new Object[0]));
                    typeInfo.hasErrors = true;
                    return typeInfo;
                }
                return null;
            }
        }
        while (true) {
            type2.done(JavaElementType.TYPE);
            this.myParser.getDeclarationParser().parseAnnotations(builder);
            PsiBuilder.Marker bracket = builder.mark();
            if (!PsiBuilderUtil.expect(builder, JavaTokenType.LBRACKET)) {
                bracket.drop();
                break;
            }
            if (!PsiBuilderUtil.expect(builder, JavaTokenType.RBRACKET)) {
                bracket.rollbackTo();
                break;
            }
            bracket.drop();
            typeInfo.isArray = true;
            type2 = type2.precede();
        }
        if (BitUtil.isSet(flags, 2) && builder.getTokenType() == JavaTokenType.ELLIPSIS) {
            type2 = type2.precede();
            builder.advanceLexer();
            type2.done(JavaElementType.TYPE);
            typeInfo.isVarArg = true;
        }
        typeInfo.marker = type2;
        return typeInfo;
    }

    private void completeWildcardType(PsiBuilder builder, boolean wildcard, PsiBuilder.Marker type2) {
        if (PsiBuilderUtil.expect(builder, WILDCARD_KEYWORD_SET) && this.parseTypeInfo(builder, 1) == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.type", new Object[0]));
        }
        if (wildcard) {
            type2.done(JavaElementType.TYPE);
        } else {
            type2.error(JavaErrorMessages.message("wildcard.not.expected", new Object[0]));
        }
    }

    @Nullable
    public PsiBuilder.Marker parseJavaCodeReference(PsiBuilder builder, boolean eatLastDot, boolean parameterList, boolean isNew, boolean diamonds) {
        return this.parseJavaCodeReference(builder, eatLastDot, parameterList, false, false, isNew, diamonds, new TypeInfo());
    }

    public boolean parseImportCodeReference(PsiBuilder builder, boolean isStatic) {
        TypeInfo typeInfo = new TypeInfo();
        this.parseJavaCodeReference(builder, true, false, true, isStatic, false, false, typeInfo);
        return !typeInfo.hasErrors;
    }

    @Nullable
    private PsiBuilder.Marker parseJavaCodeReference(PsiBuilder builder, boolean eatLastDot, boolean parameterList, boolean isImport, boolean isStaticImport, boolean isNew, boolean diamonds, TypeInfo typeInfo) {
        PsiBuilder.Marker refElement = builder.mark();
        this.myParser.getDeclarationParser().parseAnnotations(builder);
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.IDENTIFIER)) {
            refElement.rollbackTo();
            if (isImport) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
            }
            typeInfo.hasErrors = true;
            return null;
        }
        if (parameterList) {
            typeInfo.isParameterized = this.parseReferenceParameterList(builder, true, diamonds);
        } else {
            JavaParserUtil.emptyElement(builder, JavaElementType.REFERENCE_PARAMETER_LIST);
        }
        while (builder.getTokenType() == JavaTokenType.DOT) {
            boolean hasIdentifier;
            refElement.done(JavaElementType.JAVA_CODE_REFERENCE);
            if (isNew && !diamonds && typeInfo.isParameterized) {
                return refElement;
            }
            PsiBuilder.Marker dotPos = builder.mark();
            builder.advanceLexer();
            this.myParser.getDeclarationParser().parseAnnotations(builder);
            if (PsiBuilderUtil.expect(builder, JavaTokenType.IDENTIFIER)) {
                hasIdentifier = true;
            } else {
                if (isImport && PsiBuilderUtil.expect(builder, JavaTokenType.ASTERISK)) {
                    dotPos.drop();
                    return refElement;
                }
                if (!eatLastDot) {
                    dotPos.rollbackTo();
                    return refElement;
                }
                hasIdentifier = false;
            }
            dotPos.drop();
            PsiBuilder.Marker prevElement = refElement;
            refElement = refElement.precede();
            if (!hasIdentifier) {
                typeInfo.hasErrors = true;
                if (isImport) {
                    JavaParserUtil.error(builder, JavaErrorMessages.message("import.statement.identifier.or.asterisk.expected.", new Object[0]));
                    refElement.drop();
                    return prevElement;
                }
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
                JavaParserUtil.emptyElement(builder, JavaElementType.REFERENCE_PARAMETER_LIST);
                break;
            }
            if (parameterList) {
                typeInfo.isParameterized = this.parseReferenceParameterList(builder, true, diamonds);
                continue;
            }
            JavaParserUtil.emptyElement(builder, JavaElementType.REFERENCE_PARAMETER_LIST);
        }
        refElement.done(isStaticImport ? JavaElementType.IMPORT_STATIC_REFERENCE : JavaElementType.JAVA_CODE_REFERENCE);
        return refElement;
    }

    public boolean parseReferenceParameterList(PsiBuilder builder, boolean wildcard, boolean diamonds) {
        PsiBuilder.Marker list2 = builder.mark();
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.LT)) {
            list2.done(JavaElementType.REFERENCE_PARAMETER_LIST);
            return false;
        }
        int flags = BitUtil.set(BitUtil.set(1, 4, wildcard), 8, diamonds);
        boolean isOk = true;
        while (true) {
            if (this.parseTypeInfo(builder, flags, true) == null) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
            } else {
                IElementType tokenType = builder.getTokenType();
                if (WILDCARD_KEYWORD_SET.contains(tokenType)) {
                    this.parseReferenceList(builder, tokenType, null, JavaTokenType.AND);
                }
            }
            if (PsiBuilderUtil.expect(builder, JavaTokenType.GT)) break;
            if (!JavaParserUtil.expectOrError(builder, JavaTokenType.COMMA, "expected.gt.or.comma")) {
                isOk = false;
                break;
            }
            flags = BitUtil.set(flags, 8, false);
        }
        list2.done(JavaElementType.REFERENCE_PARAMETER_LIST);
        return isOk;
    }

    @NotNull
    public PsiBuilder.Marker parseTypeParameters(PsiBuilder builder) {
        PsiBuilder.Marker list2 = builder.mark();
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.LT)) {
            list2.done(JavaElementType.TYPE_PARAMETER_LIST);
            PsiBuilder.Marker marker = list2;
            if (marker == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/java/parser/ReferenceParser", "parseTypeParameters"));
            }
            return marker;
        }
        do {
            PsiBuilder.Marker param;
            if ((param = this.parseTypeParameter(builder)) != null) continue;
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.type.parameter", new Object[0]));
        } while (PsiBuilderUtil.expect(builder, JavaTokenType.COMMA));
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.GT)) {
            if (builder.getTokenType() == JavaTokenType.IDENTIFIER) {
                if (builder.lookAhead(1) == JavaTokenType.GT) {
                    PsiBuilder.Marker errorElement = builder.mark();
                    builder.advanceLexer();
                    errorElement.error(JavaErrorMessages.message("unexpected.identifier", new Object[0]));
                    builder.advanceLexer();
                } else {
                    JavaParserUtil.error(builder, JavaErrorMessages.message("expected.gt", new Object[0]));
                }
            } else {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.gt", new Object[0]));
            }
        }
        list2.done(JavaElementType.TYPE_PARAMETER_LIST);
        PsiBuilder.Marker marker = list2;
        if (marker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/java/parser/ReferenceParser", "parseTypeParameters"));
        }
        return marker;
    }

    @Nullable
    public PsiBuilder.Marker parseTypeParameter(PsiBuilder builder) {
        boolean wild;
        PsiBuilder.Marker param = builder.mark();
        this.myParser.getDeclarationParser().parseAnnotations(builder);
        if (ReferenceParser.isKeywordAny(builder)) {
            ReferenceParser.dummy(builder);
        }
        if (!(wild = PsiBuilderUtil.expect(builder, JavaTokenType.QUEST)) && !PsiBuilderUtil.expect(builder, JavaTokenType.IDENTIFIER)) {
            param.rollbackTo();
            return null;
        }
        this.parseReferenceList(builder, JavaTokenType.EXTENDS_KEYWORD, JavaElementType.EXTENDS_BOUND_LIST, JavaTokenType.AND);
        if (!wild) {
            param.done(JavaElementType.TYPE_PARAMETER);
        } else {
            param.error(JavaErrorMessages.message("wildcard.not.expected", new Object[0]));
        }
        return param;
    }

    @NotNull
    public PsiBuilder.Marker parseReferenceList(PsiBuilder builder, IElementType start, @Nullable IElementType type2, IElementType delimiter) {
        PsiBuilder.Marker element = builder.mark();
        if (PsiBuilderUtil.expect(builder, start)) {
            do {
                PsiBuilder.Marker classReference;
                if ((classReference = this.parseJavaCodeReference(builder, true, true, false, false)) != null) continue;
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
            } while (PsiBuilderUtil.expect(builder, delimiter));
        }
        if (type2 != null) {
            element.done(type2);
        } else {
            element.error(JavaErrorMessages.message("bound.not.expected", new Object[0]));
        }
        PsiBuilder.Marker marker = element;
        if (marker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/java/parser/ReferenceParser", "parseReferenceList"));
        }
        return marker;
    }

    private static boolean isKeywordAny(PsiBuilder builder) {
        return JavaParserUtil.getLanguageLevel(builder).isAtLeast(LanguageLevel.JDK_X) && "any".equals(builder.getTokenText());
    }

    private static void dummy(PsiBuilder builder) {
        PsiBuilder.Marker mark = builder.mark();
        builder.advanceLexer();
        mark.done(JavaElementType.DUMMY_ELEMENT);
    }

    public static class TypeInfo {
        public boolean isPrimitive;
        public boolean isParameterized;
        public boolean isArray;
        public boolean isVarArg;
        public boolean hasErrors;
        public PsiBuilder.Marker marker;
    }
}

