/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution;

import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.internal.artifacts.DependencySubstitutionInternal;
import org.gradle.api.internal.artifacts.dsl.ComponentSelectorParsers;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.UnversionedModuleComponentSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.VersionSelectionReasons;

public class DefaultDependencySubstitution
implements DependencySubstitutionInternal {
    private final ComponentSelector requested;
    private final ModuleVersionSelector oldRequested;
    private ComponentSelectionReason selectionReason;
    private ComponentSelector target;

    public DefaultDependencySubstitution(ComponentSelector requested, ModuleVersionSelector oldRequested) {
        this.requested = requested;
        this.target = requested;
        this.oldRequested = oldRequested;
    }

    public ComponentSelector getRequested() {
        return this.requested;
    }

    public ModuleVersionSelector getOldRequested() {
        return this.oldRequested;
    }

    public void useTarget(Object notation) {
        this.useTarget(notation, VersionSelectionReasons.SELECTED_BY_RULE);
    }

    public void useTarget(Object notation, ComponentSelectionReason selectionReason) {
        this.target = (ComponentSelector)ComponentSelectorParsers.parser().parseNotation(notation);
        this.selectionReason = selectionReason;
        DefaultDependencySubstitution.validateTarget(this.target);
    }

    public ComponentSelectionReason getSelectionReason() {
        return this.selectionReason;
    }

    public ComponentSelector getTarget() {
        return this.target;
    }

    public boolean isUpdated() {
        return this.selectionReason != null;
    }

    public static void validateTarget(ComponentSelector componentSelector) {
        if (componentSelector instanceof UnversionedModuleComponentSelector) {
            throw new InvalidUserDataException("Must specify version for target of dependency substitution");
        }
    }
}

