/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.local.model;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.LibraryBinaryIdentifier;
import org.gradle.api.artifacts.component.LibraryComponentSelector;

public class DefaultLibraryComponentSelector
implements LibraryComponentSelector {
    private final String projectPath;
    private final String libraryName;

    public DefaultLibraryComponentSelector(String projectPath, String libraryName) {
        assert (!Strings.isNullOrEmpty((String)projectPath)) : "project path cannot be null or empty";
        this.projectPath = projectPath;
        this.libraryName = Strings.emptyToNull((String)libraryName);
    }

    public String getDisplayName() {
        String txt = Strings.isNullOrEmpty((String)this.libraryName) ? String.format("project '%s'", this.projectPath) : String.format("project '%s' library '%s'", this.projectPath, this.libraryName);
        return txt;
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    public boolean matchesStrictly(ComponentIdentifier identifier) {
        assert (identifier != null) : "identifier cannot be null";
        if (identifier instanceof LibraryBinaryIdentifier) {
            LibraryBinaryIdentifier projectComponentIdentifier = (LibraryBinaryIdentifier)identifier;
            return this.projectPath.equals(projectComponentIdentifier.getProjectPath()) && projectComponentIdentifier.getLibraryName().equals(this.libraryName);
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultLibraryComponentSelector that = (DefaultLibraryComponentSelector)o;
        return Objects.equal((Object)this.projectPath, (Object)that.projectPath) && Objects.equal((Object)this.libraryName, (Object)that.libraryName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.projectPath, this.libraryName});
    }

    public String toString() {
        return this.getDisplayName();
    }
}

