/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.notations;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.artifacts.SelfResolvingDependency;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.internal.artifacts.dependencies.DefaultSelfResolvingDependency;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyFactory;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.TypeConversionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyClassPathNotationConverter
implements NotationConverter<DependencyFactory.ClassPathNotation, SelfResolvingDependency> {
    private final ClassPathRegistry classPathRegistry;
    private final Instantiator instantiator;
    private final FileResolver fileResolver;
    private final Map<DependencyFactory.ClassPathNotation, SelfResolvingDependency> internCache = Maps.newEnumMap(DependencyFactory.ClassPathNotation.class);
    private final Lock internCacheWriteLock = new ReentrantLock();

    public DependencyClassPathNotationConverter(Instantiator instantiator, ClassPathRegistry classPathRegistry, FileResolver fileResolver) {
        this.instantiator = instantiator;
        this.classPathRegistry = classPathRegistry;
        this.fileResolver = fileResolver;
    }

    public void describe(DiagnosticsVisitor visitor) {
        visitor.candidate("ClassPathNotation").example("gradleApi()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convert(DependencyFactory.ClassPathNotation notation, NotationConvertResult<? super SelfResolvingDependency> result) throws TypeConversionException {
        SelfResolvingDependency dependency = this.internCache.get(notation);
        if (dependency == null) {
            this.internCacheWriteLock.lock();
            try {
                dependency = this.maybeCreateUnderLock(notation);
            }
            finally {
                this.internCacheWriteLock.unlock();
            }
        }
        result.converted((Object)dependency);
    }

    private SelfResolvingDependency maybeCreateUnderLock(DependencyFactory.ClassPathNotation notation) {
        SelfResolvingDependency dependency = this.internCache.get(notation);
        if (dependency == null) {
            List classpath = this.classPathRegistry.getClassPath(notation.name()).getAsFiles();
            FileCollectionInternal files = this.fileResolver.resolveFiles(new Object[]{classpath});
            dependency = (SelfResolvingDependency)this.instantiator.newInstance(DefaultSelfResolvingDependency.class, new Object[]{files});
            this.internCache.put(notation, dependency);
        }
        return dependency;
    }
}

