/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.jetty;

import java.io.File;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.plugins.WarPluginConvention;
import org.gradle.api.plugins.jetty.AbstractJettyRunTask;
import org.gradle.api.plugins.jetty.JettyPluginConvention;
import org.gradle.api.plugins.jetty.JettyRun;
import org.gradle.api.plugins.jetty.JettyRunWar;
import org.gradle.api.plugins.jetty.JettyStop;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.bundling.War;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyPlugin
implements Plugin<Project> {
    public static final String JETTY_RUN = "jettyRun";
    public static final String JETTY_RUN_WAR = "jettyRunWar";
    public static final String JETTY_STOP = "jettyStop";
    public static final String RELOAD_AUTOMATIC = "automatic";
    public static final String RELOAD_MANUAL = "manual";

    public void apply(Project project) {
        project.getPluginManager().apply(WarPlugin.class);
        JettyPluginConvention jettyConvention = new JettyPluginConvention();
        Convention convention = project.getConvention();
        convention.getPlugins().put("jetty", jettyConvention);
        this.configureMappingRules(project, jettyConvention);
        this.configureJettyRun(project);
        this.configureJettyRunWar(project);
        this.configureJettyStop(project, jettyConvention);
    }

    private void configureMappingRules(final Project project, final JettyPluginConvention jettyConvention) {
        project.getTasks().withType(AbstractJettyRunTask.class, (Action)new Action<AbstractJettyRunTask>(){

            public void execute(AbstractJettyRunTask abstractJettyRunTask) {
                JettyPlugin.this.configureAbstractJettyTask(project, jettyConvention, abstractJettyRunTask);
            }
        });
    }

    private void configureJettyRunWar(final Project project) {
        project.getTasks().withType(JettyRunWar.class, (Action)new Action<JettyRunWar>(){

            public void execute(JettyRunWar jettyRunWar) {
                jettyRunWar.dependsOn(new Object[]{"war"});
                jettyRunWar.getConventionMapping().map("webApp", (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return ((War)project.getTasks().getByName("war")).getArchivePath();
                    }
                });
            }
        });
        JettyRunWar jettyRunWar = (JettyRunWar)project.getTasks().create(JETTY_RUN_WAR, JettyRunWar.class);
        jettyRunWar.setDescription("Assembles the webapp into a war and deploys it to Jetty.");
        jettyRunWar.setGroup("web application");
    }

    private void configureJettyStop(Project project, final JettyPluginConvention jettyConvention) {
        JettyStop jettyStop = (JettyStop)project.getTasks().create(JETTY_STOP, JettyStop.class);
        jettyStop.setDescription("Stops Jetty.");
        jettyStop.setGroup("web application");
        jettyStop.getConventionMapping().map("stopPort", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return jettyConvention.getStopPort();
            }
        });
        jettyStop.getConventionMapping().map("stopKey", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return jettyConvention.getStopKey();
            }
        });
    }

    private void configureJettyRun(final Project project) {
        project.getTasks().withType(JettyRun.class, (Action)new Action<JettyRun>(){

            public void execute(JettyRun jettyRun) {
                jettyRun.getConventionMapping().map("webXml", (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return JettyPlugin.this.getWebXml(project);
                    }
                });
                jettyRun.getConventionMapping().map("classpath", (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return ((SourceSet)JettyPlugin.this.getJavaConvention(project).getSourceSets().getByName("main")).getRuntimeClasspath();
                    }
                });
                jettyRun.getConventionMapping().map("webAppSourceDirectory", (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return JettyPlugin.this.getWarConvention(project).getWebAppDir();
                    }
                });
            }
        });
        JettyRun jettyRun = (JettyRun)project.getTasks().create(JETTY_RUN, JettyRun.class);
        jettyRun.setDescription("Uses your files as and where they are and deploys them to Jetty.");
        jettyRun.setGroup("web application");
    }

    private Object getWebXml(Project project) {
        War war = (War)project.getTasks().getByName("war");
        File webXml = war.getWebXml() != null ? war.getWebXml() : new File(this.getWarConvention(project).getWebAppDir(), "WEB-INF/web.xml");
        return webXml;
    }

    private void configureAbstractJettyTask(final Project project, final JettyPluginConvention jettyConvention, AbstractJettyRunTask jettyTask) {
        jettyTask.setDaemon(false);
        jettyTask.setReload(RELOAD_AUTOMATIC);
        jettyTask.setScanIntervalSeconds(0);
        jettyTask.getConventionMapping().map("contextPath", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return ((War)project.getTasks().getByName("war")).getBaseName();
            }
        });
        jettyTask.getConventionMapping().map("httpPort", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return jettyConvention.getHttpPort();
            }
        });
        jettyTask.getConventionMapping().map("stopPort", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return jettyConvention.getStopPort();
            }
        });
        jettyTask.getConventionMapping().map("stopKey", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return jettyConvention.getStopKey();
            }
        });
    }

    public JavaPluginConvention getJavaConvention(Project project) {
        return (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
    }

    public WarPluginConvention getWarConvention(Project project) {
        return (WarPluginConvention)project.getConvention().getPlugin(WarPluginConvention.class);
    }
}

