/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transfer;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.gradle.internal.resource.local.LocalResource;
import org.gradle.internal.resource.transfer.AbstractProgressLoggingHandler;
import org.gradle.internal.resource.transfer.ExternalResourceUploader;
import org.gradle.internal.resource.transfer.ResourceOperation;
import org.gradle.logging.ProgressLoggerFactory;

public class ProgressLoggingExternalResourceUploader
extends AbstractProgressLoggingHandler
implements ExternalResourceUploader {
    private final ExternalResourceUploader delegate;

    public ProgressLoggingExternalResourceUploader(ExternalResourceUploader delegate, ProgressLoggerFactory progressLoggerFactory) {
        super(progressLoggerFactory);
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(LocalResource resource, URI destination) throws IOException {
        ResourceOperation uploadOperation = this.createResourceOperation(destination.toString(), ResourceOperation.Type.upload, this.getClass(), resource.getContentLength());
        try {
            this.delegate.upload((LocalResource)new ProgressLoggingLocalResource(resource, uploadOperation), destination);
        }
        finally {
            uploadOperation.completed();
        }
    }

    private class ProgressLoggingLocalResource
    implements LocalResource {
        private final LocalResource delegate;
        private final ResourceOperation uploadOperation;

        private ProgressLoggingLocalResource(LocalResource delegate, ResourceOperation uploadOperation) {
            this.delegate = delegate;
            this.uploadOperation = uploadOperation;
        }

        public InputStream open() {
            return new AbstractProgressLoggingHandler.ProgressLoggingInputStream(this.delegate.open(), this.uploadOperation);
        }

        public long getContentLength() {
            return this.delegate.getContentLength();
        }
    }
}

