/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import java.io.File;
import org.gradle.api.file.DeleteAction;
import org.gradle.api.file.UnableToDeleteFileException;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.internal.os.OperatingSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteActionImpl
implements DeleteAction {
    private static Logger logger = LoggerFactory.getLogger(DeleteActionImpl.class);
    private FileResolver fileResolver;
    private static final int DELETE_RETRY_SLEEP_MILLIS = 10;

    public DeleteActionImpl(FileResolver fileResolver) {
        this.fileResolver = fileResolver;
    }

    public boolean delete(Object ... deletes) {
        boolean didWork = false;
        for (File file : this.fileResolver.resolveFiles(deletes)) {
            if (!file.exists()) continue;
            logger.debug("Deleting {}", (Object)file);
            didWork = true;
            this.doDelete(file);
        }
        return didWork;
    }

    private void doDelete(File file) {
        if (file.isDirectory()) {
            File[] contents = file.listFiles();
            if (contents == null) {
                return;
            }
            for (File item : contents) {
                this.doDelete(item);
            }
        }
        if (!file.delete() && file.exists()) {
            this.handleFailedDelete(file);
        }
    }

    private boolean isRunGcOnFailedDelete() {
        return OperatingSystem.current().isWindows();
    }

    private void handleFailedDelete(File file) {
        if (this.isRunGcOnFailedDelete()) {
            System.gc();
        }
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!file.delete() && file.exists()) {
            throw new UnableToDeleteFileException(file);
        }
    }
}

