/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal.graph.nodes;

import java.util.Collections;
import java.util.Set;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.artifacts.result.UnresolvedDependencyResult;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.DependencyEdge;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.InvertedRenderableModuleResult;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RenderableDependency;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnresolvedDependencyEdge
implements DependencyEdge {
    private final UnresolvedDependencyResult dependency;
    private final ModuleComponentIdentifier actual;

    public UnresolvedDependencyEdge(UnresolvedDependencyResult dependency) {
        this.dependency = dependency;
        ModuleComponentSelector attempted = (ModuleComponentSelector)dependency.getAttempted();
        this.actual = DefaultModuleComponentIdentifier.newId((String)attempted.getGroup(), (String)attempted.getModule(), (String)attempted.getVersion());
    }

    @Override
    public boolean isResolvable() {
        return false;
    }

    @Override
    public ComponentSelector getRequested() {
        return this.dependency.getRequested();
    }

    public ModuleComponentIdentifier getActual() {
        return this.actual;
    }

    @Override
    public ComponentSelectionReason getReason() {
        return this.dependency.getAttemptedReason();
    }

    public ModuleComponentIdentifier getFrom() {
        return (ModuleComponentIdentifier)this.dependency.getFrom().getId();
    }

    @Override
    public Set<? extends RenderableDependency> getChildren() {
        return Collections.singleton(new InvertedRenderableModuleResult(this.dependency.getFrom()));
    }
}

