/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import groovy.lang.Closure;
import groovy.text.SimpleTemplateEngine;
import groovy.text.Template;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.Map;
import org.apache.tools.ant.util.ReaderInputStream;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Transformer;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.ChainingTransformer;
import org.gradle.api.internal.file.copy.LineFilter;
import org.gradle.util.ConfigureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterChain
implements Transformer<InputStream, InputStream> {
    private final ChainingTransformer<Reader> transformers = new ChainingTransformer<Reader>(Reader.class);

    public Reader transform(Reader original) {
        return this.transformers.transform(original);
    }

    public InputStream transform(InputStream original) {
        return new ReaderInputStream(this.transform(new InputStreamReader(original)));
    }

    public boolean hasFilters() {
        return this.transformers.hasTransformers();
    }

    public void add(Class<? extends FilterReader> filterType) {
        this.add(filterType, null);
    }

    public void add(final Class<? extends FilterReader> filterType, final Map<String, ?> properties) {
        this.transformers.add(new Transformer<Reader, Reader>(){

            public Reader transform(Reader original) {
                try {
                    Constructor constructor = filterType.getConstructor(Reader.class);
                    FilterReader result = (FilterReader)constructor.newInstance(original);
                    if (properties != null) {
                        ConfigureUtil.configureByMap(properties, result);
                    }
                    return result;
                }
                catch (Throwable th) {
                    throw new InvalidUserDataException("Error - Invalid filter specification for " + filterType.getName(), th);
                }
            }
        });
    }

    public void add(final Closure closure) {
        this.transformers.add(new Transformer<Reader, Reader>(){

            public Reader transform(Reader original) {
                return new LineFilter(original, closure);
            }
        });
    }

    public void expand(final Map<String, ?> properties) {
        this.transformers.add(new Transformer<Reader, Reader>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Reader transform(Reader original) {
                try {
                    Template template;
                    try {
                        SimpleTemplateEngine engine = new SimpleTemplateEngine();
                        template = engine.createTemplate(original);
                    }
                    finally {
                        original.close();
                    }
                    StringWriter writer = new StringWriter();
                    template.make(properties).writeTo((Writer)writer);
                    return new StringReader(writer.toString());
                }
                catch (IOException e) {
                    throw new UncheckedIOException((Throwable)e);
                }
            }
        });
    }
}

