/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.resolve;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.gradle.api.internal.resolve.LibraryResolutionErrorMessageBuilder;
import org.gradle.jvm.JarBinarySpec;
import org.gradle.jvm.platform.JavaPlatform;
import org.gradle.language.base.internal.model.DefaultVariantsMetaData;
import org.gradle.language.base.internal.model.VariantsMetaData;
import org.gradle.language.base.internal.model.VariantsMetaDataHelper;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JvmLibraryResolutionErrorMessageBuilder
implements LibraryResolutionErrorMessageBuilder {
    private static final String TARGET_PLATFORM = "targetPlatform";
    private final VariantsMetaData variantsMetaData;
    private final ModelSchemaStore schemaStore;
    private final Platform platform;
    private final Set<String> resolveDimensions;

    public JvmLibraryResolutionErrorMessageBuilder(VariantsMetaData variantsMetaData, ModelSchemaStore schemaStore) {
        this.variantsMetaData = variantsMetaData;
        this.schemaStore = schemaStore;
        this.platform = (Platform)variantsMetaData.getValueAsType(Platform.class, TARGET_PLATFORM);
        this.resolveDimensions = variantsMetaData.getNonNullDimensions();
    }

    public String multipleBinariesForSameVariantErrorMessage(String libraryName, Collection<? extends BinarySpec> binaries) {
        ArrayList<String> binaryDescriptors = new ArrayList<String>(binaries.size());
        StringBuilder binaryDescriptor = new StringBuilder();
        for (BinarySpec binarySpec : binaries) {
            binaryDescriptor.setLength(0);
            binaryDescriptor.append("   - ").append(binarySpec.getDisplayName()).append(":\n");
            VariantsMetaData metaData = DefaultVariantsMetaData.extractFrom((BinarySpec)binarySpec, (ModelSchemaStore)this.schemaStore);
            TreeSet dimensions = new TreeSet(metaData.getNonNullDimensions());
            if (dimensions.size() <= 1) continue;
            for (String dimension : dimensions) {
                binaryDescriptor.append("       * ").append(dimension).append(" '").append(metaData.getValueAsString(dimension)).append("'\n");
            }
            binaryDescriptors.add(binaryDescriptor.toString());
        }
        if (binaryDescriptors.isEmpty()) {
            return String.format("Multiple binaries available for library '%s' (%s) : %s", libraryName, this.platform, binaries);
        }
        StringBuilder sb = new StringBuilder(String.format("Multiple binaries available for library '%s' (%s) :\n", libraryName, this.platform));
        for (String descriptor : binaryDescriptors) {
            sb.append(descriptor);
        }
        return sb.toString();
    }

    public String noCompatibleBinaryErrorMessage(String libraryName, Collection<BinarySpec> allBinaries) {
        if (this.resolveDimensions.size() == 1) {
            List availablePlatforms = Lists.transform((List)Lists.newArrayList(allBinaries), (Function)new Function<BinarySpec, String>(){

                public String apply(BinarySpec input) {
                    return input instanceof JarBinarySpec ? ((JarBinarySpec)input).getTargetPlatform().toString() : input.toString();
                }
            });
            return String.format("Cannot find a compatible binary for library '%s' (%s). Available platforms: %s", libraryName, this.platform, availablePlatforms);
        }
        final boolean moreThanOneBinary = allBinaries.size() > 1;
        TreeSet availablePlatforms = new TreeSet(Lists.transform((List)Lists.newArrayList(allBinaries), (Function)new Function<BinarySpec, String>(){

            public String apply(BinarySpec input) {
                if (input instanceof JarBinarySpec) {
                    JavaPlatform targetPlatform = ((JarBinarySpec)input).getTargetPlatform();
                    if (moreThanOneBinary) {
                        return String.format("'%s' on %s", targetPlatform.getName(), input.getDisplayName());
                    }
                    return String.format("'%s'", targetPlatform.getName());
                }
                return null;
            }
        }));
        StringBuilder error = new StringBuilder(String.format("Cannot find a compatible binary for library '%s' (%s).\n", libraryName, this.platform));
        Joiner joiner = Joiner.on((String)",").skipNulls();
        error.append("    Required platform '").append(this.platform.getName()).append("', ");
        error.append("available: ").append(joiner.join(availablePlatforms));
        error.append("\n");
        HashMultimap variants = HashMultimap.create();
        for (BinarySpec spec : allBinaries) {
            VariantsMetaData md = DefaultVariantsMetaData.extractFrom((BinarySpec)spec, (ModelSchemaStore)this.schemaStore);
            Set incompatibleDimensionTypes = VariantsMetaDataHelper.incompatibleDimensionTypes((VariantsMetaData)this.variantsMetaData, (VariantsMetaData)md, this.resolveDimensions);
            for (String dimension : this.resolveDimensions) {
                String value = md.getValueAsString(dimension);
                if (value == null) continue;
                String message = moreThanOneBinary ? String.format("'%s' on %s", value, spec.getDisplayName()) : String.format("'%s'", value);
                if (incompatibleDimensionTypes.contains(dimension)) {
                    message = String.format("%s but with an incompatible type (expected '%s' was '%s')", message, this.variantsMetaData.getDimensionType(dimension).getConcreteClass().getName(), md.getDimensionType(dimension).getConcreteClass().getName());
                }
                variants.put((Object)dimension, (Object)message);
            }
        }
        for (String dimension : this.resolveDimensions) {
            if (JvmLibraryResolutionErrorMessageBuilder.isPlatformDimension(dimension)) continue;
            error.append("    Required ").append(dimension).append(" '").append(this.variantsMetaData.getValueAsString(dimension)).append("'");
            TreeSet available = new TreeSet(variants.get((Object)dimension));
            if (!available.isEmpty()) {
                error.append(", available: ").append(joiner.join(available)).append("\n");
                continue;
            }
            error.append(" but no compatible binary was found\n");
        }
        return error.toString();
    }

    private static boolean isPlatformDimension(String dimension) {
        return TARGET_PLATFORM.equals(dimension);
    }
}

