/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.cunit.plugins;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.language.base.FunctionalSourceSet;
import org.gradle.language.base.internal.registry.LanguageTransformContainer;
import org.gradle.language.c.CSourceSet;
import org.gradle.language.c.plugins.CLangPlugin;
import org.gradle.model.Defaults;
import org.gradle.model.Finalize;
import org.gradle.model.ModelMap;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.nativeplatform.NativeBinarySpec;
import org.gradle.nativeplatform.NativeComponentSpec;
import org.gradle.nativeplatform.SharedLibraryBinary;
import org.gradle.nativeplatform.internal.NativeBinarySpecInternal;
import org.gradle.nativeplatform.internal.configure.ToolSettingNativeBinaryInitializer;
import org.gradle.nativeplatform.internal.resolve.NativeDependencyResolver;
import org.gradle.nativeplatform.test.cunit.CUnitTestSuiteBinarySpec;
import org.gradle.nativeplatform.test.cunit.CUnitTestSuiteSpec;
import org.gradle.nativeplatform.test.cunit.internal.DefaultCUnitTestSuiteBinary;
import org.gradle.nativeplatform.test.cunit.internal.DefaultCUnitTestSuiteSpec;
import org.gradle.nativeplatform.test.cunit.tasks.GenerateCUnitLauncher;
import org.gradle.nativeplatform.test.plugins.NativeBinariesTestPlugin;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.platform.base.BinaryType;
import org.gradle.platform.base.BinaryTypeBuilder;
import org.gradle.platform.base.ComponentType;
import org.gradle.platform.base.ComponentTypeBuilder;
import org.gradle.platform.base.internal.BinaryNamingScheme;
import org.gradle.platform.base.internal.ComponentSpecInternal;
import org.gradle.platform.base.internal.DefaultBinaryNamingSchemeBuilder;
import org.gradle.platform.base.test.TestSuiteContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class CUnitPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPluginManager().apply(NativeBinariesTestPlugin.class);
        project.getPluginManager().apply(CLangPlugin.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Rules
    extends RuleSource {
        private static final String CUNIT_LAUNCHER_SOURCE_SET = "cunitLauncher";

        Rules() {
        }

        @Defaults
        public void createCUnitTestSuitePerComponent(TestSuiteContainer testSuites, ModelMap<NativeComponentSpec> components) {
            for (final NativeComponentSpec component : components.values()) {
                String suiteName = String.format("%sTest", component.getName());
                testSuites.create(suiteName, CUnitTestSuiteSpec.class, (Action)new Action<CUnitTestSuiteSpec>(){

                    public void execute(CUnitTestSuiteSpec testSuite) {
                        DefaultCUnitTestSuiteSpec cunitTestSuite = (DefaultCUnitTestSuiteSpec)testSuite;
                        cunitTestSuite.setTestedComponent(component);
                    }
                });
            }
        }

        @ComponentType
        public void registerCUnitTestSuiteSpecType(ComponentTypeBuilder<CUnitTestSuiteSpec> builder) {
            builder.defaultImplementation(DefaultCUnitTestSuiteSpec.class);
        }

        @Finalize
        public void configureCUnitTestSuiteSources(TestSuiteContainer testSuites, @Path(value="buildDir") File buildDir) {
            for (CUnitTestSuiteSpec suite : testSuites.withType(CUnitTestSuiteSpec.class).values()) {
                FunctionalSourceSet suiteSourceSet = ((ComponentSpecInternal)suite).getFunctionalSourceSet();
                CSourceSet launcherSources = (CSourceSet)suiteSourceSet.maybeCreate(CUNIT_LAUNCHER_SOURCE_SET, CSourceSet.class);
                File baseDir = new File(buildDir, String.format("src/%s/cunitLauncher", suite.getName()));
                launcherSources.getSource().srcDir((Object)new File(baseDir, "c"));
                launcherSources.getExportedHeaders().srcDir((Object)new File(baseDir, "headers"));
                CSourceSet testSources = (CSourceSet)suiteSourceSet.maybeCreate("c", CSourceSet.class);
                testSources.lib((Object)launcherSources);
            }
        }

        @Mutate
        public void createCUnitLauncherTasks(TaskContainer tasks, TestSuiteContainer testSuites) {
            for (CUnitTestSuiteSpec suite : testSuites.withType(CUnitTestSuiteSpec.class).values()) {
                String taskName = suite.getName() + "CUnitLauncher";
                GenerateCUnitLauncher skeletonTask = (GenerateCUnitLauncher)tasks.create(taskName, GenerateCUnitLauncher.class);
                CSourceSet launcherSources = this.findLauncherSources(suite);
                skeletonTask.setSourceDir((File)launcherSources.getSource().getSrcDirs().iterator().next());
                skeletonTask.setHeaderDir((File)launcherSources.getExportedHeaders().getSrcDirs().iterator().next());
                launcherSources.builtBy(new Object[]{skeletonTask});
            }
        }

        private CSourceSet findLauncherSources(CUnitTestSuiteSpec suite) {
            return (CSourceSet)suite.getSources().withType(CSourceSet.class).get(CUNIT_LAUNCHER_SOURCE_SET);
        }

        @BinaryType
        public void registerCUnitTestBinaryType(BinaryTypeBuilder<CUnitTestSuiteBinarySpec> builder) {
            builder.defaultImplementation(DefaultCUnitTestSuiteBinary.class);
        }

        @Mutate
        public void createCUnitTestBinaries(TestSuiteContainer testSuites, @Path(value="buildDir") File buildDir, LanguageTransformContainer languageTransforms, final ServiceRegistry serviceRegistry, ITaskFactory taskFactory) {
            ToolSettingNativeBinaryInitializer setToolsAction = new ToolSettingNativeBinaryInitializer(languageTransforms);
            testSuites.withType(CUnitTestSuiteSpec.class).afterEach((Action)new Action<CUnitTestSuiteSpec>((Action)setToolsAction, buildDir){
                final /* synthetic */ Action val$setToolsAction;
                final /* synthetic */ File val$buildDir;
                {
                    this.val$setToolsAction = action;
                    this.val$buildDir = file;
                }

                public void execute(CUnitTestSuiteSpec cUnitTestSuite) {
                    for (final NativeBinarySpec testedBinary : cUnitTestSuite.getTestedComponent().getBinaries().withType(NativeBinarySpec.class).values()) {
                        if (testedBinary instanceof SharedLibraryBinary) continue;
                        final BinaryNamingScheme namingScheme = new DefaultBinaryNamingSchemeBuilder(((NativeBinarySpecInternal)testedBinary).getNamingScheme()).withComponentName(cUnitTestSuite.getBaseName()).withTypeString("CUnitExe").build();
                        final NativeDependencyResolver resolver = (NativeDependencyResolver)serviceRegistry.get(NativeDependencyResolver.class);
                        cUnitTestSuite.getBinaries().create(namingScheme.getLifecycleTaskName(), CUnitTestSuiteBinarySpec.class, (Action)new Action<CUnitTestSuiteBinarySpec>(){

                            public void execute(CUnitTestSuiteBinarySpec binary) {
                                DefaultCUnitTestSuiteBinary testBinary = (DefaultCUnitTestSuiteBinary)binary;
                                testBinary.setTestedBinary((NativeBinarySpecInternal)testedBinary);
                                testBinary.setNamingScheme(namingScheme);
                                testBinary.setResolver(resolver);
                                val$setToolsAction.execute((Object)testBinary);
                                Rules.this.configure(testBinary, val$buildDir);
                            }
                        });
                    }
                }
            });
        }

        private void configure(DefaultCUnitTestSuiteBinary testBinary, File buildDir) {
            BinaryNamingScheme namingScheme = testBinary.getNamingScheme();
            PlatformToolProvider toolProvider = testBinary.getPlatformToolProvider();
            File binaryOutputDir = new File(new File(buildDir, "binaries"), namingScheme.getOutputDirectoryBase());
            String baseName = testBinary.getComponent().getBaseName();
            testBinary.setExecutableFile(new File(binaryOutputDir, toolProvider.getExecutableName(baseName)));
        }
    }
}

