/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.UUID;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.DefaultExecutorFactory;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.id.UUIDGenerator;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.messaging.dispatch.DiscardingFailureHandler;
import org.gradle.messaging.remote.MessagingClient;
import org.gradle.messaging.remote.MessagingServer;
import org.gradle.messaging.remote.internal.AsyncConnection;
import org.gradle.messaging.remote.internal.AsyncConnectionAdapter;
import org.gradle.messaging.remote.internal.DefaultIncomingBroadcast;
import org.gradle.messaging.remote.internal.DefaultOutgoingBroadcast;
import org.gradle.messaging.remote.internal.IncomingBroadcast;
import org.gradle.messaging.remote.internal.IncomingConnector;
import org.gradle.messaging.remote.internal.MessageOriginator;
import org.gradle.messaging.remote.internal.OutgoingBroadcast;
import org.gradle.messaging.remote.internal.OutgoingConnector;
import org.gradle.messaging.remote.internal.Protocol;
import org.gradle.messaging.remote.internal.hub.MessageHubBackedClient;
import org.gradle.messaging.remote.internal.hub.MessageHubBackedServer;
import org.gradle.messaging.remote.internal.inet.InetAddressFactory;
import org.gradle.messaging.remote.internal.inet.MulticastConnection;
import org.gradle.messaging.remote.internal.inet.SocketInetAddress;
import org.gradle.messaging.remote.internal.inet.TcpIncomingConnector;
import org.gradle.messaging.remote.internal.inet.TcpOutgoingConnector;
import org.gradle.messaging.remote.internal.protocol.DiscoveryMessage;
import org.gradle.messaging.remote.internal.protocol.DiscoveryProtocolSerializer;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessagingServices
extends DefaultServiceRegistry
implements Stoppable {
    private final IdGenerator<UUID> idGenerator = new UUIDGenerator();
    private final ClassLoader messageClassLoader;
    private final String broadcastGroup;
    private final SocketInetAddress broadcastAddress;

    public MessagingServices(ClassLoader messageClassLoader) {
        this(messageClassLoader, "gradle");
    }

    public MessagingServices(ClassLoader messageClassLoader, String broadcastGroup) {
        this(messageClassLoader, broadcastGroup, MessagingServices.defaultBroadcastAddress());
    }

    public MessagingServices(ClassLoader messageClassLoader, String broadcastGroup, SocketInetAddress broadcastAddress) {
        this.messageClassLoader = messageClassLoader;
        this.broadcastGroup = broadcastGroup;
        this.broadcastAddress = broadcastAddress;
    }

    private static SocketInetAddress defaultBroadcastAddress() {
        try {
            return new SocketInetAddress(InetAddress.getByName("233.253.17.122"), 7912);
        }
        catch (UnknownHostException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    public void stop() {
        this.close();
    }

    protected MessageOriginator createMessageOriginator() {
        String hostName = ((InetAddressFactory)this.get(InetAddressFactory.class)).getHostName();
        String nodeName = String.format("%s@%s", System.getProperty("user.name"), hostName);
        return new MessageOriginator(this.idGenerator.generateId(), nodeName);
    }

    protected ExecutorFactory createExecutorFactory() {
        return new DefaultExecutorFactory();
    }

    protected InetAddressFactory createInetAddressFactory() {
        return new InetAddressFactory();
    }

    protected OutgoingConnector createOutgoingConnector() {
        return new TcpOutgoingConnector();
    }

    protected IncomingConnector createIncomingConnector(ExecutorFactory executorFactory, InetAddressFactory inetAddressFactory) {
        return new TcpIncomingConnector(executorFactory, inetAddressFactory, this.idGenerator);
    }

    protected MessagingClient createMessagingClient(OutgoingConnector outgoingConnector, ExecutorFactory executorFactory) {
        return new MessageHubBackedClient(outgoingConnector, executorFactory);
    }

    protected MessagingServer createMessagingServer(IncomingConnector incomingConnector, ExecutorFactory executorFactory) {
        return new MessageHubBackedServer(incomingConnector, executorFactory);
    }

    protected IncomingBroadcast createIncomingBroadcast(MessageOriginator messageOriginator, AsyncConnection<DiscoveryMessage> asyncConnection, IncomingConnector incomingConnector, ExecutorFactory executorFactory) {
        return new DefaultIncomingBroadcast(messageOriginator, this.broadcastGroup, asyncConnection, incomingConnector, executorFactory, this.idGenerator, this.messageClassLoader);
    }

    protected OutgoingBroadcast createOutgoingBroadcast(MessageOriginator messageOriginator, AsyncConnection<DiscoveryMessage> asyncConnection, OutgoingConnector outgoingConnector, ExecutorFactory executorFactory) {
        return new DefaultOutgoingBroadcast(messageOriginator, this.broadcastGroup, asyncConnection, outgoingConnector, executorFactory, this.idGenerator, this.messageClassLoader);
    }

    protected AsyncConnection<DiscoveryMessage> createMulticastConnection(ExecutorFactory executorFactory, InetAddressFactory addressFactory) {
        MulticastConnection<DiscoveryMessage> connection = new MulticastConnection<DiscoveryMessage>(this.broadcastAddress, new DiscoveryProtocolSerializer(), addressFactory);
        return new AsyncConnectionAdapter<DiscoveryMessage>(connection, new DiscardingFailureHandler(LoggerFactory.getLogger(MulticastConnection.class)), executorFactory, new Protocol[0]);
    }
}

