/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.gradle.messaging.remote.internal.Protocol;
import org.gradle.messaging.remote.internal.ProtocolContext;
import org.gradle.messaging.remote.internal.protocol.ChannelAvailable;
import org.gradle.messaging.remote.internal.protocol.ChannelUnavailable;
import org.gradle.messaging.remote.internal.protocol.DiscoveryMessage;
import org.gradle.messaging.remote.internal.protocol.LookupRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelLookupProtocol
implements Protocol<DiscoveryMessage> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelLookupProtocol.class);
    private final Map<String, RequestDetails> channels = new HashMap<String, RequestDetails>();
    private ProtocolContext<DiscoveryMessage> context;

    @Override
    public void start(ProtocolContext<DiscoveryMessage> context) {
        this.context = context;
    }

    @Override
    public void handleOutgoing(DiscoveryMessage message) {
        if (!(message instanceof LookupRequest)) {
            throw new UnsupportedOperationException();
        }
        LookupRequest lookupRequest = (LookupRequest)message;
        LOGGER.info("Broadcasting lookup request: {}", (Object)lookupRequest);
        RequestDetails request = new RequestDetails(lookupRequest);
        this.channels.put(lookupRequest.getChannel(), request);
        request.run();
    }

    @Override
    public void handleIncoming(DiscoveryMessage message) {
        if (message instanceof ChannelAvailable) {
            ChannelAvailable channelAvailable = (ChannelAvailable)message;
            LOGGER.info("Channel discovered: {}", (Object)channelAvailable);
            RequestDetails request = this.channels.get(channelAvailable.getChannel());
            if (request != null) {
                LOGGER.info("Processing request on channel: {}", (Object)request.lookupRequest);
                request.handleResponse(channelAvailable);
            } else {
                LOGGER.info("No request for channel, ignoring.");
            }
        } else if (!(message instanceof LookupRequest) && !(message instanceof ChannelUnavailable)) {
            LOGGER.info("Received unknown discovery message - discarding: {}", (Object)message);
        } else {
            LOGGER.info("Ignored incoming discovery message {}", (Object)message);
        }
    }

    @Override
    public void stopRequested() {
        this.context.stopped();
    }

    private class RequestDetails
    implements Runnable {
        private final LookupRequest lookupRequest;
        ProtocolContext.Callback timeout;
        int attempts;

        public RequestDetails(LookupRequest lookupRequest) {
            this.lookupRequest = lookupRequest;
        }

        public void handleResponse(ChannelAvailable channelAvailable) {
            this.timeout.cancel();
            ChannelLookupProtocol.this.context.dispatchIncoming(channelAvailable);
        }

        public void run() {
            ++this.attempts;
            this.timeout = ChannelLookupProtocol.this.context.callbackLater(this.getTimeoutSeconds(), TimeUnit.SECONDS, this);
            ChannelLookupProtocol.this.context.dispatchOutgoing(this.lookupRequest);
        }

        private int getTimeoutSeconds() {
            if (this.attempts > 10) {
                return 30;
            }
            if (this.attempts > 5) {
                return 10;
            }
            return 1;
        }
    }
}

