/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.plugins;

import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.api.internal.resolve.ProjectModelResolver;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.ide.visualstudio.VisualStudioProject;
import org.gradle.ide.visualstudio.VisualStudioSolution;
import org.gradle.ide.visualstudio.internal.DefaultVisualStudioExtension;
import org.gradle.ide.visualstudio.internal.DefaultVisualStudioProject;
import org.gradle.ide.visualstudio.internal.VisualStudioExtensionInternal;
import org.gradle.ide.visualstudio.internal.VisualStudioProjectConfiguration;
import org.gradle.ide.visualstudio.tasks.GenerateFiltersFileTask;
import org.gradle.ide.visualstudio.tasks.GenerateProjectFileTask;
import org.gradle.ide.visualstudio.tasks.GenerateSolutionFileTask;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.model.Model;
import org.gradle.model.Mutate;
import org.gradle.model.RuleSource;
import org.gradle.nativeplatform.NativeBinarySpec;
import org.gradle.nativeplatform.NativeComponentSpec;
import org.gradle.nativeplatform.plugins.NativeComponentModelPlugin;
import org.gradle.platform.base.BinaryContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class VisualStudioPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPluginManager().apply(NativeComponentModelPlugin.class);
    }

    static class Rules
    extends RuleSource {
        Rules() {
        }

        @Model
        public static VisualStudioExtensionInternal visualStudio(ServiceRegistry serviceRegistry) {
            Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
            ProjectModelResolver projectModelResolver = (ProjectModelResolver)serviceRegistry.get(ProjectModelResolver.class);
            FileResolver fileResolver = (FileResolver)serviceRegistry.get(FileResolver.class);
            return (VisualStudioExtensionInternal)instantiator.newInstance(DefaultVisualStudioExtension.class, new Object[]{instantiator, projectModelResolver, fileResolver});
        }

        @Mutate
        public static void includeBuildFileInProject(VisualStudioExtensionInternal visualStudio, final ProjectIdentifier projectIdentifier) {
            visualStudio.getProjects().all((Action)new Action<VisualStudioProject>(){

                public void execute(VisualStudioProject project) {
                    if (projectIdentifier.getBuildFile() != null) {
                        ((DefaultVisualStudioProject)project).addSourceFile(projectIdentifier.getBuildFile());
                    }
                }
            });
        }

        @Mutate
        public static void createVisualStudioModelForBinaries(VisualStudioExtensionInternal visualStudioExtension, BinaryContainer binaryContainer) {
            for (NativeBinarySpec binary : binaryContainer.withType(NativeBinarySpec.class)) {
                VisualStudioProjectConfiguration configuration = visualStudioExtension.getProjectRegistry().addProjectConfiguration(binary);
                if (!binary.isBuildable()) continue;
                DefaultVisualStudioProject visualStudioProject = configuration.getProject();
                visualStudioExtension.getSolutionRegistry().addSolution(visualStudioProject);
            }
        }

        @Mutate
        public static void createTasksForVisualStudio(TaskContainer tasks, VisualStudioExtensionInternal visualStudioExtension) {
            for (VisualStudioProject vsProject : visualStudioExtension.getProjects()) {
                vsProject.builtBy(new Object[]{Rules.createProjectsFileTask(tasks, vsProject)});
                vsProject.builtBy(new Object[]{Rules.createFiltersFileTask(tasks, vsProject)});
            }
            for (VisualStudioSolution vsSolution : visualStudioExtension.getSolutions()) {
                Task solutionTask = tasks.create(vsSolution.getName() + "VisualStudio");
                solutionTask.setDescription(String.format("Generates the '%s' Visual Studio solution file.", vsSolution.getName()));
                vsSolution.setBuildTask(solutionTask);
                vsSolution.builtBy(new Object[]{Rules.createSolutionTask(tasks, vsSolution)});
                NativeComponentSpec component = vsSolution.getComponent();
                Task lifecycleTask = (Task)tasks.maybeCreate(component.getName() + "VisualStudio");
                lifecycleTask.dependsOn(new Object[]{vsSolution});
                lifecycleTask.setGroup("IDE");
                lifecycleTask.setDescription(String.format("Generates the Visual Studio solution for %s.", component));
            }
            Rules.addCleanTask(tasks);
        }

        private static void addCleanTask(TaskContainer tasks) {
            Delete cleanTask = (Delete)tasks.create("cleanVisualStudio", Delete.class);
            for (Task task : tasks.withType(GenerateSolutionFileTask.class)) {
                cleanTask.delete(new Object[]{task.getOutputs().getFiles()});
            }
            for (Task task : tasks.withType(GenerateFiltersFileTask.class)) {
                cleanTask.delete(new Object[]{task.getOutputs().getFiles()});
            }
            for (Task task : tasks.withType(GenerateProjectFileTask.class)) {
                cleanTask.delete(new Object[]{task.getOutputs().getFiles()});
            }
            cleanTask.setGroup("IDE");
            cleanTask.setDescription("Removes all generated Visual Studio project and solution files");
        }

        private static Task createSolutionTask(TaskContainer tasks, VisualStudioSolution solution) {
            GenerateSolutionFileTask solutionFileTask = (GenerateSolutionFileTask)tasks.create(solution.getName() + "VisualStudioSolution", GenerateSolutionFileTask.class);
            solutionFileTask.setVisualStudioSolution(solution);
            return solutionFileTask;
        }

        private static Task createProjectsFileTask(TaskContainer tasks, VisualStudioProject vsProject) {
            GenerateProjectFileTask task = (GenerateProjectFileTask)tasks.create(vsProject.getName() + "VisualStudioProject", GenerateProjectFileTask.class);
            task.setVisualStudioProject(vsProject);
            task.initGradleCommand();
            return task;
        }

        private static Task createFiltersFileTask(TaskContainer tasks, VisualStudioProject vsProject) {
            GenerateFiltersFileTask task = (GenerateFiltersFileTask)tasks.create(vsProject.getName() + "VisualStudioFilters", GenerateFiltersFileTask.class);
            task.setVisualStudioProject(vsProject);
            return task;
        }
    }
}

