/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testkit.runner.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.gradle.api.Action;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.testkit.runner.BuildResult;
import org.gradle.testkit.runner.GradleRunner;
import org.gradle.testkit.runner.InvalidRunnerConfigurationException;
import org.gradle.testkit.runner.UnexpectedBuildFailure;
import org.gradle.testkit.runner.UnexpectedBuildSuccess;
import org.gradle.testkit.runner.internal.ConstantTestKitDirProvider;
import org.gradle.testkit.runner.internal.DefaultBuildResult;
import org.gradle.testkit.runner.internal.GradleExecutionResult;
import org.gradle.testkit.runner.internal.GradleExecutor;
import org.gradle.testkit.runner.internal.TempTestKitDirProvider;
import org.gradle.testkit.runner.internal.TestKitDirProvider;
import org.gradle.testkit.runner.internal.TestKitGradleExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGradleRunner
extends GradleRunner {
    public static final String DIAGNOSTICS_MESSAGE_SEPARATOR = "-----";
    public static final String DEBUG_SYS_PROP = "org.gradle.testkit.debug";
    private final File gradleHome;
    private final GradleExecutor gradleExecutor;
    private TestKitDirProvider testKitDirProvider;
    private File projectDirectory;
    private List<String> arguments = Collections.emptyList();
    private List<String> jvmArguments = Collections.emptyList();
    private ClassPath classpath = ClassPath.EMPTY;
    private boolean debug;

    public DefaultGradleRunner(File gradleHome) {
        this(gradleHome, new TestKitGradleExecutor(), new TempTestKitDirProvider());
    }

    DefaultGradleRunner(File gradleHome, GradleExecutor gradleExecutor, TestKitDirProvider testKitDirProvider) {
        this.gradleHome = gradleHome;
        this.gradleExecutor = gradleExecutor;
        this.testKitDirProvider = testKitDirProvider;
        this.debug = this.isDebugEnabled();
    }

    private boolean isDebugEnabled() {
        return Boolean.parseBoolean(System.getProperty(DEBUG_SYS_PROP, "false"));
    }

    public TestKitDirProvider getTestKitDirProvider() {
        return this.testKitDirProvider;
    }

    @Override
    public DefaultGradleRunner withTestKitDir(File testKitDir) {
        if (testKitDir == null) {
            throw new IllegalArgumentException("testKitDir argument cannot be null");
        }
        this.testKitDirProvider = new ConstantTestKitDirProvider(testKitDir);
        return this;
    }

    public DefaultGradleRunner withJvmArguments(List<String> jvmArguments) {
        this.jvmArguments = Collections.unmodifiableList(new ArrayList<String>(jvmArguments));
        return this;
    }

    public DefaultGradleRunner withJvmArguments(String ... jvmArguments) {
        return this.withJvmArguments(Arrays.asList(jvmArguments));
    }

    @Override
    public File getProjectDir() {
        return this.projectDirectory;
    }

    @Override
    public DefaultGradleRunner withProjectDir(File projectDir) {
        this.projectDirectory = projectDir;
        return this;
    }

    @Override
    public List<String> getArguments() {
        return this.arguments;
    }

    @Override
    public DefaultGradleRunner withArguments(List<String> arguments) {
        this.arguments = Collections.unmodifiableList(new ArrayList<String>(arguments));
        return this;
    }

    @Override
    public DefaultGradleRunner withArguments(String ... arguments) {
        return this.withArguments((List)Arrays.asList(arguments));
    }

    @Override
    public List<? extends File> getPluginClasspath() {
        return this.classpath.getAsFiles();
    }

    @Override
    public GradleRunner withPluginClasspath(Iterable<? extends File> classpath) {
        ArrayList<File> f = new ArrayList<File>();
        for (File file : classpath) {
            f.add(new File(file.getAbsolutePath()));
        }
        if (!f.isEmpty()) {
            this.classpath = new DefaultClassPath(f);
        }
        return this;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public GradleRunner withDebug(boolean debug) {
        this.debug = debug;
        return this;
    }

    @Override
    public BuildResult build() {
        return this.run(new Action<GradleExecutionResult>(){

            public void execute(GradleExecutionResult gradleExecutionResult) {
                if (!gradleExecutionResult.isSuccessful()) {
                    throw new UnexpectedBuildFailure(DefaultGradleRunner.this.createDiagnosticsMessage("Unexpected build execution failure", gradleExecutionResult));
                }
            }
        });
    }

    @Override
    public BuildResult buildAndFail() {
        return this.run(new Action<GradleExecutionResult>(){

            public void execute(GradleExecutionResult gradleExecutionResult) {
                if (gradleExecutionResult.isSuccessful()) {
                    throw new UnexpectedBuildSuccess(DefaultGradleRunner.this.createDiagnosticsMessage("Unexpected build execution success", gradleExecutionResult));
                }
            }
        });
    }

    private String createDiagnosticsMessage(String trailingMessage, GradleExecutionResult gradleExecutionResult) {
        String lineBreak = SystemProperties.getInstance().getLineSeparator();
        StringBuilder message = new StringBuilder();
        message.append(trailingMessage);
        message.append(" in ");
        message.append(this.getProjectDir().getAbsolutePath());
        message.append(" with arguments ");
        message.append(this.getArguments());
        message.append(lineBreak).append(lineBreak);
        message.append("Output:");
        message.append(lineBreak);
        message.append(gradleExecutionResult.getStandardOutput());
        message.append(lineBreak);
        message.append(DIAGNOSTICS_MESSAGE_SEPARATOR);
        message.append(lineBreak);
        message.append("Error:");
        message.append(lineBreak);
        message.append(gradleExecutionResult.getStandardError());
        message.append(lineBreak);
        message.append(DIAGNOSTICS_MESSAGE_SEPARATOR);
        if (gradleExecutionResult.getThrowable() != null) {
            message.append(lineBreak);
            message.append("Reason:");
            message.append(lineBreak);
            message.append(this.determineExceptionMessage(gradleExecutionResult.getThrowable()));
            message.append(lineBreak);
            message.append(DIAGNOSTICS_MESSAGE_SEPARATOR);
        }
        return message.toString();
    }

    private String determineExceptionMessage(Throwable throwable) {
        return throwable.getCause() == null ? throwable.getMessage() : ExceptionUtils.getRootCause((Throwable)throwable).getMessage();
    }

    private BuildResult run(Action<GradleExecutionResult> resultVerification) {
        if (this.projectDirectory == null) {
            throw new InvalidRunnerConfigurationException("Please specify a project directory before executing the build");
        }
        File testKitDir = this.createTestKitDir(this.testKitDirProvider);
        GradleExecutionResult execResult = this.gradleExecutor.run(this.gradleHome, testKitDir, this.projectDirectory, this.arguments, this.jvmArguments, this.classpath, this.debug);
        resultVerification.execute((Object)execResult);
        return new DefaultBuildResult(execResult.getStandardOutput(), execResult.getStandardError(), execResult.getTasks());
    }

    private File createTestKitDir(TestKitDirProvider testKitDirProvider) {
        File dir = testKitDirProvider.getDir();
        if (dir.isDirectory()) {
            if (!dir.canWrite()) {
                throw new InvalidRunnerConfigurationException("Unable to write to test kit directory: " + dir.getAbsolutePath());
            }
            return dir;
        }
        if (dir.exists()) {
            throw new InvalidRunnerConfigurationException("Unable to use non-directory as test kit directory: " + dir.getAbsolutePath());
        }
        if (dir.mkdirs() || dir.isDirectory()) {
            return dir;
        }
        throw new InvalidRunnerConfigurationException("Unable to create test kit directory: " + dir.getAbsolutePath());
    }
}

