/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classloader;

import com.google.common.collect.MapMaker;
import java.util.concurrent.ConcurrentMap;
import org.gradle.internal.classloader.ClassLoaderHierarchy;
import org.gradle.internal.classloader.ClassLoaderSpec;
import org.gradle.internal.classloader.ClassLoaderVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingClassLoader
extends ClassLoader
implements ClassLoaderHierarchy {
    private static final Object MISSING_CLASS = new Object();
    private final ConcurrentMap<String, Object> loadedClasses = new MapMaker().weakValues().makeMap();
    private final ClassLoader parent;

    public CachingClassLoader(ClassLoader parent) {
        super(parent);
        this.parent = parent;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> result;
        Object cachedValue = this.loadedClasses.get(name);
        if (cachedValue instanceof Class) {
            return (Class)cachedValue;
        }
        if (cachedValue == MISSING_CLASS) {
            throw new ClassNotFoundException(name);
        }
        try {
            result = super.loadClass(name, resolve);
        }
        catch (ClassNotFoundException e) {
            this.loadedClasses.putIfAbsent(name, MISSING_CLASS);
            throw e;
        }
        this.loadedClasses.putIfAbsent(name, result);
        return result;
    }

    @Override
    public void visit(ClassLoaderVisitor visitor) {
        visitor.visitSpec(new Spec());
        visitor.visitParent(this.getParent());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CachingClassLoader)) {
            return false;
        }
        CachingClassLoader that = (CachingClassLoader)o;
        return this.parent.equals(that.parent);
    }

    public int hashCode() {
        return this.parent.hashCode();
    }

    public static class Spec
    extends ClassLoaderSpec {
        public boolean equals(Object obj) {
            return obj != null && obj.getClass().equals(Spec.class);
        }

        public int hashCode() {
            return this.getClass().getName().hashCode();
        }
    }
}

