/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.registry;

import org.gradle.api.Action;
import org.gradle.model.InvalidModelRuleException;
import org.gradle.model.ModelRuleBindingException;
import org.gradle.model.internal.core.ModelNode;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.registry.BindingPredicate;
import org.gradle.model.internal.registry.ModelBinding;
import org.gradle.model.internal.registry.ModelNodeInternal;
import org.gradle.model.internal.report.IncompatibleTypeReferenceReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PathBinderCreationListener
extends ModelBinding {
    private final Action<ModelBinding> bindAction;

    public PathBinderCreationListener(ModelRuleDescriptor descriptor, BindingPredicate predicate, boolean writable, Action<ModelBinding> bindAction) {
        super(descriptor, predicate, writable);
        this.bindAction = bindAction;
    }

    @Override
    public boolean canBindInState(ModelNode.State state) {
        return this.predicate.isUntyped() || state.isAtLeast(ModelNode.State.ProjectionsDefined);
    }

    @Override
    public void onCreate(ModelNodeInternal node) {
        if (this.boundTo != null) {
            throw new IllegalStateException(String.format("Reference %s for %s is already bound to %s.", this.predicate.getReference(), this.referrer, this.boundTo));
        }
        if (!this.predicate.isUntyped() && !this.isTypeCompatible(node.getPromise())) {
            throw new InvalidModelRuleException(this.referrer, (Throwable)((Object)new ModelRuleBindingException(IncompatibleTypeReferenceReporter.of(node, node.getPromise(), this.predicate.getReference(), this.writable).asString())));
        }
        this.boundTo = node;
        this.bindAction.execute((Object)this);
    }
}

