/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.registry;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.jcip.annotations.NotThreadSafe;
import org.gradle.api.Nullable;
import org.gradle.internal.Cast;
import org.gradle.internal.service.Service;
import org.gradle.model.ConfigurationCycleException;
import org.gradle.model.InvalidModelRuleDeclarationException;
import org.gradle.model.RuleSource;
import org.gradle.model.internal.core.DuplicateModelException;
import org.gradle.model.internal.core.EmptyModelProjection;
import org.gradle.model.internal.core.ExtractedModelRule;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelCreator;
import org.gradle.model.internal.core.ModelCreators;
import org.gradle.model.internal.core.ModelNode;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelProjection;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelRuleExecutionException;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.inspect.ModelRuleExtractor;
import org.gradle.model.internal.registry.BindingPredicate;
import org.gradle.model.internal.registry.CreatorRuleBinder;
import org.gradle.model.internal.registry.ModelActionBinder;
import org.gradle.model.internal.registry.ModelBinding;
import org.gradle.model.internal.registry.ModelCreationListener;
import org.gradle.model.internal.registry.ModelGraph;
import org.gradle.model.internal.registry.ModelNodeInternal;
import org.gradle.model.internal.registry.ModelPathSuggestionProvider;
import org.gradle.model.internal.registry.ModelReferenceNode;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.model.internal.registry.NodeAtState;
import org.gradle.model.internal.registry.RuleBinder;
import org.gradle.model.internal.registry.RuleBindings;
import org.gradle.model.internal.registry.RuleContext;
import org.gradle.model.internal.registry.UnboundModelRulesException;
import org.gradle.model.internal.registry.UnboundRulesProcessor;
import org.gradle.model.internal.report.unbound.UnboundRule;
import org.gradle.model.internal.type.ModelType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class DefaultModelRegistry
implements ModelRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultModelRegistry.class);
    private final ModelGraph modelGraph;
    private final RuleBindings ruleBindings;
    private final ModelRuleExtractor ruleExtractor;
    private final Set<RuleBinder> unboundRules = Sets.newIdentityHashSet();
    private boolean reset;
    private boolean replace;

    public DefaultModelRegistry(ModelRuleExtractor ruleExtractor) {
        this.ruleExtractor = ruleExtractor;
        ModelCreator rootCreator = ModelCreators.of(ModelPath.ROOT).descriptor("<root>").withProjection(EmptyModelProjection.INSTANCE).build();
        this.modelGraph = new ModelGraph(new ModelElementNode(this.toCreatorBinder(rootCreator), null));
        this.modelGraph.getRoot().setState(ModelNode.State.Created);
        this.ruleBindings = new RuleBindings(this.modelGraph);
    }

    private static String describe(ModelRuleDescriptor descriptor) {
        StringBuilder stringBuilder = new StringBuilder();
        descriptor.describeTo(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public DefaultModelRegistry create(ModelCreator creator) {
        ModelPath path = creator.getPath();
        if (!ModelPath.ROOT.isDirectChild(path)) {
            throw new InvalidModelRuleDeclarationException(creator.getDescriptor(), "Cannot create element at '" + path + "', only top level is allowed (e.g. '" + path.getRootParent() + "')");
        }
        ModelNodeInternal root = this.modelGraph.getRoot();
        root.addLink(creator);
        return this;
    }

    private CreatorRuleBinder toCreatorBinder(ModelCreator creator) {
        BindingPredicate subject = new BindingPredicate(ModelReference.of(creator.getPath(), ModelType.untyped(), ModelNode.State.Created));
        return new CreatorRuleBinder(creator, subject, Collections.<BindingPredicate>emptyList(), this.unboundRules);
    }

    private ModelNodeInternal registerNode(ModelNodeInternal node) {
        if (this.reset) {
            this.unboundRules.remove(node.getCreatorBinder());
            this.unboundRules.removeAll(node.getInitializerRuleBinders());
            return node;
        }
        this.addRuleBindings(node);
        this.modelGraph.add(node);
        this.ruleBindings.nodeCreated(node);
        return node;
    }

    private void addRuleBindings(ModelNodeInternal node) {
        this.ruleBindings.add(node.getCreatorBinder());
        for (Map.Entry entry : node.getCreatorBinder().getCreator().getActions().entries()) {
            boolean earlyAction;
            ModelActionRole role = (ModelActionRole)((Object)entry.getKey());
            ModelAction action = (ModelAction)entry.getValue();
            DefaultModelRegistry.checkNodePath(node, action);
            boolean bl = earlyAction = role.compareTo(ModelActionRole.Create) <= 0;
            if (this.reset && !earlyAction) continue;
            ModelActionBinder binder = this.forceBind(action.getSubject(), role, action, ModelPath.ROOT);
            if (!earlyAction) continue;
            node.addInitializerRuleBinder(binder);
        }
    }

    @Override
    public DefaultModelRegistry configure(ModelActionRole role, ModelAction action) {
        this.bind(action.getSubject(), role, action, ModelPath.ROOT);
        return this;
    }

    @Override
    public ModelRegistry configure(ModelActionRole role, ModelAction action, ModelPath scope) {
        this.bind(action.getSubject(), role, action, scope);
        return this;
    }

    @Override
    public ModelRegistry apply(Class<? extends RuleSource> rules) {
        this.modelGraph.getRoot().applyToSelf(rules);
        return this;
    }

    private static void checkNodePath(ModelNodeInternal node, ModelAction action) {
        if (!node.getPath().equals(action.getSubject().getPath())) {
            throw new IllegalArgumentException(String.format("Element action reference has path (%s) which does not reference this node (%s).", action.getSubject().getPath(), node.getPath()));
        }
    }

    private <T> void bind(ModelReference<T> subject, ModelActionRole role, ModelAction mutator, ModelPath scope) {
        if (this.reset) {
            return;
        }
        this.forceBind(subject, role, mutator, scope);
    }

    private <T> ModelActionBinder forceBind(ModelReference<T> subject, ModelActionRole role, ModelAction mutator, ModelPath scope) {
        BindingPredicate mappedSubject = this.mapSubject(subject, role, scope);
        List<BindingPredicate> mappedInputs = this.mapInputs(mutator.getInputs(), scope);
        ModelActionBinder binder = new ModelActionBinder(mappedSubject, mappedInputs, mutator, this.unboundRules);
        this.ruleBindings.add(binder);
        return binder;
    }

    @Override
    public <T> T realize(ModelPath path, ModelType<T> type) {
        return this.toType(type, this.require(path), "get(ModelPath, ModelType)");
    }

    @Override
    public ModelNode atState(ModelPath path, ModelNode.State state) {
        return this.atStateOrMaybeLater(path, state, false);
    }

    @Override
    public ModelNode atStateOrLater(ModelPath path, ModelNode.State state) {
        return this.atStateOrMaybeLater(path, state, true);
    }

    private ModelNode atStateOrMaybeLater(ModelPath path, ModelNode.State state, boolean laterOk) {
        ModelNodeInternal node = this.modelGraph.find(path);
        if (node == null) {
            return null;
        }
        this.transition(node, state, laterOk);
        return node;
    }

    @Override
    public <T> T find(ModelPath path, ModelType<T> type) {
        return this.toType(type, this.get(path), "find(ModelPath, ModelType)");
    }

    private <T> T toType(ModelType<T> type, ModelNodeInternal node, String msg) {
        if (node == null) {
            return null;
        }
        return this.assertView(node, type, null, msg, new Object[0]).getInstance();
    }

    @Override
    public ModelNode realizeNode(ModelPath path) {
        return this.require(path);
    }

    private void registerListener(ModelCreationListener listener) {
        this.modelGraph.addListener(listener);
    }

    @Override
    public void remove(ModelPath path) {
        ModelNodeInternal node = this.modelGraph.find(path);
        if (node == null) {
            return;
        }
        Iterable<? extends ModelNode> dependents = node.getDependents();
        if (!Iterables.isEmpty(dependents)) {
            throw new RuntimeException("Tried to remove model " + path + " but it is depended on by: " + Joiner.on((String)", ").join(dependents));
        }
        this.modelGraph.remove(node);
        this.ruleBindings.remove(node);
        this.unboundRules.remove(node.getCreatorBinder());
        this.unboundRules.removeAll(node.getInitializerRuleBinders());
    }

    @Override
    public ModelRegistry createOrReplace(ModelCreator newCreator) {
        ModelPath path = newCreator.getPath();
        ModelNodeInternal node = this.modelGraph.find(path);
        if (node == null) {
            ModelNodeInternal parent = this.modelGraph.find(path.getParent());
            if (parent == null) {
                throw new IllegalStateException("Cannot create '" + path + "' as its parent node does not exist");
            }
            parent.addLink(newCreator);
        } else {
            this.replace(newCreator);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelRegistry replace(ModelCreator newCreator) {
        ModelNodeInternal node = this.modelGraph.find(newCreator.getPath());
        if (node == null) {
            throw new IllegalStateException("can not replace node " + newCreator.getPath() + " as it does not exist");
        }
        this.replace = true;
        try {
            boolean wasProjectionsDefined = node.isAtLeast(ModelNode.State.ProjectionsDefined);
            this.ruleBindings.remove(node, node.getCreatorBinder());
            for (RuleBinder ruleBinder : node.getInitializerRuleBinders()) {
                this.ruleBindings.remove(node, ruleBinder);
            }
            node.getInitializerRuleBinders().clear();
            node.replaceCreatorRuleBinder(this.toCreatorBinder(newCreator));
            node.setState(ModelNode.State.Known);
            this.addRuleBindings(node);
            if (wasProjectionsDefined) {
                this.transition(node, ModelNode.State.ProjectionsDefined, false);
            }
        }
        finally {
            this.replace = false;
        }
        return this;
    }

    @Override
    public void bindAllReferences() throws UnboundModelRulesException {
        if (this.unboundRules.isEmpty()) {
            return;
        }
        GoalGraph graph = new GoalGraph();
        boolean newInputsBound = true;
        while (!this.unboundRules.isEmpty() && newInputsBound) {
            RuleBinder[] unboundBinders;
            newInputsBound = false;
            for (RuleBinder binder : unboundBinders = this.unboundRules.toArray(new RuleBinder[this.unboundRules.size()])) {
                this.transitionTo(graph, new TryBindInputs(binder));
                newInputsBound = newInputsBound || binder.isBound();
            }
        }
        if (!this.unboundRules.isEmpty()) {
            TreeSet<RuleBinder> sortedBinders = new TreeSet<RuleBinder>(new Comparator<RuleBinder>(){

                @Override
                public int compare(RuleBinder o1, RuleBinder o2) {
                    return o1.getDescriptor().toString().compareTo(o2.getDescriptor().toString());
                }
            });
            sortedBinders.addAll(this.unboundRules);
            throw this.unbound(sortedBinders);
        }
    }

    private UnboundModelRulesException unbound(Iterable<? extends RuleBinder> binders) {
        ModelPathSuggestionProvider suggestionsProvider = new ModelPathSuggestionProvider(this.modelGraph.getFlattened().keySet());
        List<? extends UnboundRule> unboundRules = new UnboundRulesProcessor(binders, suggestionsProvider).process();
        return new UnboundModelRulesException(unboundRules);
    }

    private ModelNodeInternal require(ModelPath path) {
        ModelNodeInternal node = this.get(path);
        if (node == null) {
            throw new IllegalStateException("No model node at '" + path + "'");
        }
        return node;
    }

    @Override
    public ModelNode.State state(ModelPath path) {
        ModelNodeInternal modelNode = this.modelGraph.find(path);
        return modelNode == null ? null : modelNode.getState();
    }

    private ModelNodeInternal get(ModelPath path) {
        GoalGraph graph = new GoalGraph();
        this.transitionTo(graph, graph.nodeAtState(new NodeAtState(path, ModelNode.State.Known)));
        ModelNodeInternal node = this.modelGraph.find(path);
        if (node == null) {
            return null;
        }
        this.transitionTo(graph, graph.nodeAtState(new NodeAtState(path, ModelNode.State.GraphClosed)));
        return node;
    }

    private void transitionTo(GoalGraph goalGraph, ModelGoal targetGoal) {
        LinkedList<ModelGoal> queue = new LinkedList<ModelGoal>();
        queue.add(targetGoal);
        while (!queue.isEmpty()) {
            ModelGoal goal = (ModelGoal)queue.getFirst();
            if (goal.state == ModelGoal.State.Achieved) {
                queue.removeFirst();
                continue;
            }
            if (goal.state == ModelGoal.State.NotSeen && goal.isAchieved()) {
                goal.state = ModelGoal.State.Achieved;
                queue.removeFirst();
                continue;
            }
            if (goal.state == ModelGoal.State.VisitingDependencies) {
                goal.apply();
                goal.state = ModelGoal.State.Achieved;
                queue.removeFirst();
                continue;
            }
            ArrayList<ModelGoal> newDependencies = new ArrayList<ModelGoal>();
            goal.attachNode();
            boolean done = goal.calculateDependencies(goalGraph, newDependencies);
            goal.state = done || newDependencies.isEmpty() ? ModelGoal.State.VisitingDependencies : ModelGoal.State.DiscoveringDependencies;
            for (int i = newDependencies.size() - 1; i >= 0; --i) {
                ModelGoal dependency = (ModelGoal)newDependencies.get(i);
                if (dependency.state == ModelGoal.State.Achieved) continue;
                if (dependency.state == ModelGoal.State.NotSeen) {
                    queue.addFirst(dependency);
                    continue;
                }
                throw this.ruleCycle(dependency, queue);
            }
        }
    }

    private ConfigurationCycleException ruleCycle(ModelGoal brokenGoal, LinkedList<ModelGoal> queue) {
        ArrayList<String> path = new ArrayList<String>();
        int pos = queue.indexOf(brokenGoal);
        ListIterator<ModelGoal> iterator = queue.listIterator(pos + 1);
        while (iterator.hasPrevious()) {
            ModelGoal goal = iterator.previous();
            goal.attachToCycle(path);
        }
        brokenGoal.attachToCycle(path);
        Formatter out = new Formatter();
        out.format("A cycle has been detected in model rule dependencies. References forming the cycle:", new Object[0]);
        String last = null;
        StringBuilder indent = new StringBuilder("");
        for (int i = 0; i < path.size(); ++i) {
            String node = (String)path.get(i);
            if (node.equals(last)) continue;
            last = node;
            if (i == 0) {
                out.format("%n%s%s", indent, node);
                continue;
            }
            out.format("%n%s\\- %s", indent, node);
            indent.append("   ");
        }
        return new ConfigurationCycleException(out.toString());
    }

    private void transition(ModelNodeInternal node, ModelNode.State desired, boolean laterOk) {
        ModelPath path = node.getPath();
        ModelNode.State state = node.getState();
        LOGGER.debug("Transitioning model element '{}' from state {} to {}", new Object[]{path, state.name(), desired.name()});
        if (desired.ordinal() < state.ordinal()) {
            if (laterOk) {
                return;
            }
            throw new IllegalStateException("Cannot lifecycle model node '" + path + "' to state " + desired.name() + " as it is already at " + state.name());
        }
        if (state == desired) {
            return;
        }
        GoalGraph goalGraph = new GoalGraph();
        this.transitionTo(goalGraph, goalGraph.nodeAtState(new NodeAtState(node.getPath(), desired)));
    }

    private <T> ModelView<? extends T> assertView(ModelNodeInternal node, ModelType<T> targetType, @Nullable ModelRuleDescriptor descriptor, String msg, Object ... msgArgs) {
        ModelView<T> view = node.asReadOnly(targetType, descriptor);
        if (view == null) {
            throw new IllegalArgumentException("Model node '" + node.getPath().toString() + "' is not compatible with requested " + targetType + " (operation: " + String.format(msg, msgArgs) + ")");
        }
        return view;
    }

    private void fireAction(ModelActionBinder boundMutator) {
        final List<ModelView<?>> inputs = this.toViews(boundMutator.getInputBindings(), boundMutator.getAction().getDescriptor());
        ModelBinding subjectBinding = boundMutator.getSubjectBinding();
        if (subjectBinding == null) {
            throw new IllegalStateException("Subject binding must not be null");
        }
        final ModelNodeInternal node = subjectBinding.getNode();
        final ModelAction mutator = boundMutator.getAction();
        ModelRuleDescriptor descriptor = mutator.getDescriptor();
        LOGGER.debug("Mutating {} using {}", (Object)node.getPath(), (Object)descriptor);
        try {
            RuleContext.run(descriptor, new Runnable(){

                public void run() {
                    mutator.execute(node, inputs);
                }
            });
        }
        catch (Exception e) {
            throw new ModelRuleExecutionException(descriptor, e);
        }
    }

    private List<ModelView<?>> toViews(List<ModelBinding> bindings, ModelRuleDescriptor descriptor) {
        ModelView[] array = new ModelView[bindings.size()];
        int i = 0;
        for (ModelBinding binding : bindings) {
            ModelNodeInternal element = binding.getNode();
            ModelView<?> view = this.assertView(element, binding.getPredicate().getType(), descriptor, "toViews", new Object[0]);
            array[i++] = view;
        }
        List<ModelView<?>> views = Arrays.asList(array);
        return views;
    }

    @Override
    public MutableModelNode getRoot() {
        return this.modelGraph.getRoot();
    }

    @Override
    public MutableModelNode node(ModelPath path) {
        return this.modelGraph.find(path);
    }

    @Override
    public void prepareForReuse() {
        this.reset = true;
        LinkedList ephemerals = Lists.newLinkedList();
        this.collectEphemeralChildren(this.modelGraph.getRoot(), ephemerals);
        if (ephemerals.isEmpty()) {
            LOGGER.info("No ephemeral model nodes found to reset");
        } else {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Resetting ephemeral model nodes: " + Joiner.on((String)", ").join((Iterable)ephemerals));
            }
            for (ModelNodeInternal ephemeral : ephemerals) {
                ephemeral.reset();
            }
        }
    }

    private void collectEphemeralChildren(ModelNodeInternal node, Collection<ModelNodeInternal> ephemerals) {
        for (ModelNodeInternal modelNodeInternal : node.getLinks()) {
            if (modelNodeInternal.isEphemeral()) {
                ephemerals.add(modelNodeInternal);
                continue;
            }
            this.collectEphemeralChildren(modelNodeInternal, ephemerals);
        }
    }

    private BindingPredicate mapSubject(ModelReference<?> subjectReference, ModelActionRole role, ModelPath scope) {
        if (!role.isSubjectViewAvailable() && !subjectReference.isUntyped()) {
            throw new IllegalStateException(String.format("Cannot bind subject '%s' to role '%s' because it is targeting a type and subject types are not yet available in that role", new Object[]{subjectReference, role}));
        }
        ModelReference<?> mappedReference = subjectReference.getPath() == null ? subjectReference.inScope(scope) : subjectReference.withPath(scope.descendant(subjectReference.getPath()));
        return new BindingPredicate(mappedReference.atState(role.getTargetState()));
    }

    private List<BindingPredicate> mapInputs(List<? extends ModelReference<?>> inputs, ModelPath scope) {
        if (inputs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BindingPredicate> result = new ArrayList<BindingPredicate>(inputs.size());
        for (ModelReference<?> input : inputs) {
            if (input.getPath() != null) {
                if (input.getType().getConcreteClass().isAnnotationPresent(Service.class)) {
                    result.add(new BindingPredicate(input));
                    continue;
                }
                result.add(new BindingPredicate(input.withPath(scope.descendant(input.getPath()))));
                continue;
            }
            result.add(new BindingPredicate(input.inScope(ModelPath.ROOT)));
        }
        return result;
    }

    private class NotifyProjectionsDefined
    extends ModelNodeGoal {
        protected NotifyProjectionsDefined(ModelPath target) {
            super(target);
        }

        void apply() {
            if (DefaultModelRegistry.this.replace) {
                return;
            }
            DefaultModelRegistry.this.ruleBindings.nodeProjectionsDefined(this.node);
            DefaultModelRegistry.this.modelGraph.nodeProjectionsDefined(this.node);
        }

        public String toString() {
            return "notify projections defined for " + this.getPath() + ", state: " + (Object)((Object)this.state);
        }
    }

    private class RunModelAction
    extends RunAction {
        private final ModelActionBinder binder;

        public RunModelAction(ModelPath path, ModelActionBinder binder) {
            super(path, binder);
            this.binder = binder;
        }

        void apply() {
            LOGGER.debug("Running model element '{}' rule action {}", (Object)this.getPath(), (Object)this.binder.getDescriptor());
            DefaultModelRegistry.this.fireAction(this.binder);
            this.node.notifyFired(this.binder);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class RunAction
    extends ModelNodeGoal {
        private final RuleBinder binder;
        private boolean bindInputs;

        public RunAction(ModelPath path, RuleBinder binder) {
            super(path);
            this.binder = binder;
        }

        @Override
        public String toString() {
            return "run action for " + this.getPath() + ", rule: " + this.binder.getDescriptor() + ", state: " + (Object)((Object)this.state);
        }

        @Override
        public boolean calculateDependencies(GoalGraph graph, Collection<ModelGoal> dependencies) {
            if (!this.bindInputs) {
                dependencies.add(new TryBindInputs(this.binder));
                this.bindInputs = true;
                return false;
            }
            if (!this.binder.isBound()) {
                throw DefaultModelRegistry.this.unbound(Collections.singleton(this.binder));
            }
            for (ModelBinding binding : this.binder.getInputBindings()) {
                dependencies.add(graph.nodeAtState(new NodeAtState(binding.getNode().getPath(), binding.getPredicate().getState())));
            }
            return true;
        }

        @Override
        void attachToCycle(List<String> displayValue) {
            displayValue.add(this.binder.getDescriptor().toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TryBindInputs
    extends ModelGoal {
        private final RuleBinder binder;

        public TryBindInputs(RuleBinder binder) {
            this.binder = binder;
        }

        @Override
        public String toString() {
            return "bind inputs for " + this.binder.getDescriptor() + ", state: " + (Object)((Object)this.state);
        }

        @Override
        public boolean calculateDependencies(GoalGraph graph, Collection<ModelGoal> dependencies) {
            if (this.binder.getSubjectBinding() != null) {
                this.maybeBind(this.binder.getSubjectBinding(), dependencies);
            }
            for (ModelBinding binding : this.binder.getInputBindings()) {
                this.maybeBind(binding, dependencies);
            }
            return true;
        }

        private void maybeBind(ModelBinding binding, Collection<ModelGoal> dependencies) {
            if (!binding.isBound()) {
                if (binding.getPredicate().getPath() != null) {
                    dependencies.add(new TryResolveAndDefineProjectionsForPath(binding.getPredicate().getPath()));
                } else {
                    dependencies.add(new TryDefineScope(binding.getPredicate().getScope()));
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TryDefineScope
    extends ModelGoal {
        private final ModelPath scope;
        private boolean attemptedPath;

        public TryDefineScope(ModelPath scope) {
            this.scope = scope;
        }

        @Override
        public boolean isAchieved() {
            ModelNodeInternal node = DefaultModelRegistry.this.modelGraph.find(this.scope);
            if (node == null || !node.isAtLeast(ModelNode.State.SelfClosed)) {
                return false;
            }
            for (ModelNodeInternal modelNodeInternal : node.getLinks()) {
                if (modelNodeInternal.isAtLeast(ModelNode.State.ProjectionsDefined)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean calculateDependencies(GoalGraph graph, Collection<ModelGoal> dependencies) {
            if (!this.attemptedPath) {
                dependencies.add(new TryResolvePath(this.scope));
                this.attemptedPath = true;
                return false;
            }
            if (DefaultModelRegistry.this.modelGraph.find(this.scope) != null) {
                dependencies.add(graph.nodeAtState(new NodeAtState(this.scope, ModelNode.State.SelfClosed)));
                dependencies.add(new TransitionChildrenOrReference(this.scope, ModelNode.State.ProjectionsDefined));
            }
            return true;
        }

        @Override
        public String toString() {
            return "try define scope " + this.scope + ", state: " + (Object)((Object)this.state);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TryResolveReference
    extends ModelGoal {
        private final ModelReferenceNode parent;
        private final ModelPath path;

        public TryResolveReference(ModelReferenceNode parent, ModelPath path) {
            this.parent = parent;
            this.path = path;
        }

        @Override
        public boolean calculateDependencies(GoalGraph graph, Collection<ModelGoal> dependencies) {
            dependencies.add(new TryResolveAndDefineProjectionsForPath(this.parent.getTarget().getPath().child(this.path.getName())));
            return true;
        }

        @Override
        void apply() {
            ModelNodeInternal parentTarget = this.parent.getTarget();
            ModelNodeInternal childTarget = parentTarget.getLink(this.path.getName());
            if (childTarget == null) {
                throw new NullPointerException("child is null");
            }
            ModelCreator creator = ModelCreators.of(this.path).descriptor(this.parent.getDescriptor()).withProjection(childTarget.getCreatorBinder().getCreator().getProjection()).build();
            ModelReferenceNode childNode = new ModelReferenceNode(DefaultModelRegistry.this.toCreatorBinder(creator), this.parent);
            childNode.setTarget(childTarget);
            DefaultModelRegistry.this.registerNode(childNode);
            DefaultModelRegistry.this.ruleBindings.nodeProjectionsDefined(childNode);
        }

        @Override
        public String toString() {
            return "try resolve reference " + this.path + ", state: " + (Object)((Object)this.state);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TryResolveAndDefineProjectionsForPath
    extends TryResolvePath {
        private boolean attemptedPath;

        public TryResolveAndDefineProjectionsForPath(ModelPath path) {
            super(path);
        }

        @Override
        protected boolean doIsAchieved() {
            return this.node.isAtLeast(ModelNode.State.ProjectionsDefined);
        }

        @Override
        public boolean calculateDependencies(GoalGraph graph, Collection<ModelGoal> dependencies) {
            if (DefaultModelRegistry.this.modelGraph.find(this.getPath()) == null) {
                if (!this.attemptedPath) {
                    this.attemptedPath = super.calculateDependencies(graph, dependencies);
                    return false;
                }
                return true;
            }
            dependencies.add(graph.nodeAtState(new NodeAtState(this.getPath(), ModelNode.State.ProjectionsDefined)));
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TryResolvePath
    extends ModelNodeGoal {
        private boolean attemptedParent;

        public TryResolvePath(ModelPath path) {
            super(path);
        }

        @Override
        protected boolean doIsAchieved() {
            return true;
        }

        @Override
        public boolean calculateDependencies(GoalGraph graph, Collection<ModelGoal> dependencies) {
            if (!this.attemptedParent) {
                dependencies.add(new TryResolvePath(this.getPath().getParent()));
                this.attemptedParent = true;
                return false;
            }
            ModelNodeInternal parent = DefaultModelRegistry.this.modelGraph.find(this.getPath().getParent());
            if (parent == null) {
                return true;
            }
            if (parent instanceof ModelReferenceNode) {
                ModelReferenceNode parentReference = (ModelReferenceNode)parent;
                if (parentReference.getTarget() != null) {
                    dependencies.add(new TryResolveReference(parentReference, this.getPath()));
                }
            } else {
                dependencies.add(graph.nodeAtState(new NodeAtState(this.getPath().getParent(), ModelNode.State.SelfClosed)));
            }
            return true;
        }

        @Override
        public String toString() {
            return "try resolve path " + this.getPath() + ", state: " + (Object)((Object)this.state);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CloseGraph
    extends TransitionNodeToState {
        public CloseGraph(NodeAtState target) {
            super(target);
        }

        @Override
        boolean doCalculateDependencies(GoalGraph graph, Collection<ModelGoal> dependencies) {
            dependencies.add(new TransitionChildrenOrReference(this.getPath(), ModelNode.State.GraphClosed));
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ApplyActions
    extends TransitionNodeToState {
        private final Set<RuleBinder> seenRules;

        public ApplyActions(NodeAtState target) {
            super(target);
            this.seenRules = new HashSet<RuleBinder>();
        }

        @Override
        boolean doCalculateDependencies(GoalGraph graph, Collection<ModelGoal> dependencies) {
            boolean noActionsAdded = true;
            for (RuleBinder binder : DefaultModelRegistry.this.ruleBindings.getRulesWithSubject(this.target)) {
                if (!this.seenRules.add(binder)) continue;
                noActionsAdded = false;
                if (!(binder instanceof ModelActionBinder)) continue;
                dependencies.add(new RunModelAction(this.getPath(), (ModelActionBinder)binder));
            }
            return noActionsAdded;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TransitionChildrenOrReference
    extends ModelNodeGoal {
        private final ModelNode.State targetState;

        protected TransitionChildrenOrReference(ModelPath target, ModelNode.State targetState) {
            super(target);
            this.targetState = targetState;
        }

        @Override
        public boolean calculateDependencies(GoalGraph graph, Collection<ModelGoal> dependencies) {
            if (this.node instanceof ModelReferenceNode) {
                ModelReferenceNode referenceNode = (ModelReferenceNode)this.node;
                ModelNodeInternal modelNodeInternal = referenceNode.getTarget();
                if (modelNodeInternal == null || modelNodeInternal.getPath().isDescendant(this.node.getPath())) {
                    return true;
                }
                dependencies.add(graph.nodeAtState(new NodeAtState(modelNodeInternal.getPath(), this.targetState)));
            } else {
                for (ModelNodeInternal modelNodeInternal : this.node.getLinks()) {
                    dependencies.add(graph.nodeAtState(new NodeAtState(modelNodeInternal.getPath(), this.targetState)));
                }
            }
            return true;
        }

        @Override
        public String toString() {
            return "transition children of " + this.getPath() + " to " + (Object)((Object)this.targetState) + ", state: " + (Object)((Object)this.state);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TransitionDependents
    extends ModelGoal {
        private final NodeAtState input;

        public TransitionDependents(NodeAtState input) {
            this.input = input;
        }

        @Override
        public boolean calculateDependencies(GoalGraph graph, Collection<ModelGoal> dependencies) {
            for (RuleBinder rule : DefaultModelRegistry.this.ruleBindings.getRulesWithInput(this.input)) {
                if (rule.getSubjectBinding() == null || !rule.getSubjectBinding().isBound() || rule.getSubjectReference().getState() == null || rule.getSubjectBinding().getNode().getPath().equals(this.input.path)) continue;
                dependencies.add(graph.nodeAtState(new NodeAtState(rule.getSubjectBinding().getNode().getPath(), rule.getSubjectReference().getState())));
            }
            return true;
        }

        @Override
        public String toString() {
            return "transition dependents " + this.input.path + ", target: " + (Object)((Object)this.input.state) + ", state: " + (Object)((Object)this.state);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefineProjections
    extends ModelNodeGoal {
        public DefineProjections(ModelPath path) {
            super(path);
        }

        @Override
        public boolean doIsAchieved() {
            return this.node.isAtLeast(ModelNode.State.ProjectionsDefined);
        }

        @Override
        public boolean calculateDependencies(GoalGraph graph, Collection<ModelGoal> dependencies) {
            dependencies.add(new ApplyActions(new NodeAtState(this.getPath(), ModelNode.State.ProjectionsDefined)));
            dependencies.add(new NotifyProjectionsDefined(this.getPath()));
            return true;
        }

        @Override
        public String toString() {
            return "define projections for " + this.getPath() + ", state: " + (Object)((Object)this.state);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class TransitionNodeToState
    extends ModelNodeGoal {
        final NodeAtState target;
        private boolean seenPredecessor;

        public TransitionNodeToState(NodeAtState target) {
            super(target.path);
            this.target = target;
        }

        @Override
        public String toString() {
            return "transition " + this.getPath() + ", target: " + (Object)((Object)this.target.state) + ", state: " + (Object)((Object)this.state);
        }

        public ModelNode.State getTargetState() {
            return this.target.state;
        }

        @Override
        public boolean doIsAchieved() {
            return this.node.getState().compareTo(this.getTargetState()) >= 0;
        }

        @Override
        public final boolean calculateDependencies(GoalGraph graph, Collection<ModelGoal> dependencies) {
            if (!this.seenPredecessor) {
                NodeAtState predecessor = new NodeAtState(this.getPath(), this.getTargetState().previous());
                dependencies.add(graph.nodeAtState(predecessor));
                dependencies.add(new TransitionDependents(predecessor));
                this.seenPredecessor = true;
                return false;
            }
            if (this.node == null) {
                throw new IllegalStateException(String.format("Cannot transition model element '%s' to state %s as it does not exist.", this.getPath(), this.getTargetState().name()));
            }
            return this.doCalculateDependencies(graph, dependencies);
        }

        boolean doCalculateDependencies(GoalGraph graph, Collection<ModelGoal> dependencies) {
            return true;
        }

        @Override
        public final void apply() {
            if (!this.node.getState().equals((Object)this.getTargetState().previous())) {
                throw new IllegalStateException(String.format("Cannot transition model element '%s' to state %s as it is already at state %s.", new Object[]{this.node.getPath(), this.getTargetState(), this.node.getState()}));
            }
            LOGGER.debug("Transitioning model element '{}' to state {}.", (Object)this.node.getPath(), (Object)this.getTargetState().name());
            this.node.setState(this.getTargetState());
        }

        @Override
        void attachToCycle(List<String> displayValue) {
            displayValue.add(this.getPath().toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MakeKnown
    extends ModelNodeGoal {
        public MakeKnown(ModelPath path) {
            super(path);
        }

        @Override
        public String toString() {
            return "make known " + this.getPath() + ", state: " + (Object)((Object)this.state);
        }

        @Override
        public boolean doIsAchieved() {
            return true;
        }

        @Override
        public boolean calculateDependencies(GoalGraph graph, Collection<ModelGoal> dependencies) {
            ModelPath parent = this.getPath().getParent();
            if (parent != null) {
                dependencies.add(graph.nodeAtState(new NodeAtState(parent, ModelNode.State.SelfClosed)));
            }
            return true;
        }
    }

    private abstract class ModelNodeGoal
    extends ModelGoal {
        public final ModelPath target;
        public ModelNodeInternal node;

        protected ModelNodeGoal(ModelPath target) {
            this.target = target;
        }

        public ModelPath getPath() {
            return this.target;
        }

        public final boolean isAchieved() {
            this.node = DefaultModelRegistry.this.modelGraph.find(this.target);
            return this.node != null && this.doIsAchieved();
        }

        protected boolean doIsAchieved() {
            return false;
        }

        public void attachNode() {
            if (this.node != null) {
                return;
            }
            this.node = DefaultModelRegistry.this.modelGraph.find(this.getPath());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class ModelGoal {
        public State state = State.NotSeen;

        private ModelGoal() {
        }

        public boolean isAchieved() {
            return false;
        }

        public void attachNode() {
        }

        public boolean calculateDependencies(GoalGraph graph, Collection<ModelGoal> dependencies) {
            return true;
        }

        void apply() {
        }

        void attachToCycle(List<String> displayValue) {
        }

        public abstract String toString();

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum State {
            NotSeen,
            DiscoveringDependencies,
            VisitingDependencies,
            Achieved;

        }
    }

    private class GoalGraph {
        private final Map<NodeAtState, ModelGoal> nodeStates = new HashMap<NodeAtState, ModelGoal>();

        private GoalGraph() {
        }

        public ModelGoal nodeAtState(NodeAtState goal) {
            ModelGoal node = this.nodeStates.get(goal);
            if (node == null) {
                switch (goal.state) {
                    case Known: {
                        node = new MakeKnown(goal.path);
                        break;
                    }
                    case ProjectionsDefined: {
                        node = new DefineProjections(goal.path);
                        break;
                    }
                    case GraphClosed: {
                        node = new CloseGraph(goal);
                        break;
                    }
                    default: {
                        node = new ApplyActions(goal);
                    }
                }
                this.nodeStates.put(goal, node);
            }
            return node;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ModelElementNode
    extends ModelNodeInternal {
        private final Map<String, ModelNodeInternal> links;
        private final MutableModelNode parent;
        private Object privateData;
        private ModelType<?> privateDataType;

        public ModelElementNode(CreatorRuleBinder creatorRuleBinder, MutableModelNode parent) {
            super(creatorRuleBinder);
            this.links = Maps.newTreeMap();
            this.parent = parent;
        }

        @Override
        public MutableModelNode getParent() {
            return this.parent;
        }

        @Override
        public <T> ModelView<? extends T> asReadOnly(ModelType<T> type, @Nullable ModelRuleDescriptor ruleDescriptor) {
            ModelView<T> modelView = this.getAdapter().asImmutable(type, this, ruleDescriptor);
            if (modelView == null) {
                throw new IllegalStateException("Model node " + this.getPath() + " cannot be expressed as a read-only view of type " + type);
            }
            return modelView;
        }

        @Override
        public <T> ModelView<? extends T> asWritable(ModelType<T> type, ModelRuleDescriptor ruleDescriptor, List<ModelView<?>> inputs) {
            ModelView<T> modelView = this.getAdapter().asMutable(type, this, ruleDescriptor, inputs);
            if (modelView == null) {
                throw new IllegalStateException("Model node " + this.getPath() + " cannot be expressed as a mutable view of type " + type);
            }
            return modelView;
        }

        @Override
        public <T> T getPrivateData(Class<T> type) {
            return this.getPrivateData(ModelType.of(type));
        }

        @Override
        public <T> T getPrivateData(ModelType<T> type) {
            if (this.privateData == null) {
                return null;
            }
            if (!type.isAssignableFrom(this.privateDataType)) {
                throw new ClassCastException("Cannot get private data '" + this.privateData + "' of type '" + this.privateDataType + "' as type '" + type);
            }
            return (T)Cast.uncheckedCast((Object)this.privateData);
        }

        @Override
        public Object getPrivateData() {
            return this.privateData;
        }

        @Override
        public <T> void setPrivateData(Class<? super T> type, T object) {
            this.setPrivateData(ModelType.of(type), object);
        }

        @Override
        public <T> void setPrivateData(ModelType<? super T> type, T object) {
            if (!this.isMutable()) {
                throw new IllegalStateException(String.format("Cannot set value for model element '%s' as this element is not mutable.", this.getPath()));
            }
            this.privateDataType = type;
            this.privateData = object;
        }

        @Override
        protected void resetPrivateData() {
            this.privateDataType = null;
            this.privateData = null;
        }

        @Override
        public boolean hasLink(String name) {
            return this.links.containsKey(name);
        }

        @Override
        @Nullable
        public ModelNodeInternal getLink(String name) {
            return this.links.get(name);
        }

        @Override
        public Iterable<? extends ModelNodeInternal> getLinks() {
            return this.links.values();
        }

        @Override
        public int getLinkCount(ModelType<?> type) {
            int count = 0;
            for (ModelNodeInternal linked : this.links.values()) {
                linked.ensureAtLeast(ModelNode.State.ProjectionsDefined);
                if (!linked.getPromise().canBeViewedAsMutable(type)) continue;
                ++count;
            }
            return count;
        }

        @Override
        public Set<String> getLinkNames(ModelType<?> type) {
            LinkedHashSet names = Sets.newLinkedHashSet();
            for (Map.Entry<String, ModelNodeInternal> entry : this.links.entrySet()) {
                ModelNodeInternal link = entry.getValue();
                link.ensureAtLeast(ModelNode.State.ProjectionsDefined);
                if (!link.getPromise().canBeViewedAsMutable(type)) continue;
                names.add(entry.getKey());
            }
            return names;
        }

        @Override
        public Iterable<? extends MutableModelNode> getLinks(final ModelType<?> type) {
            return Iterables.filter(this.links.values(), (Predicate)new Predicate<ModelNodeInternal>(){

                public boolean apply(ModelNodeInternal link) {
                    link.ensureAtLeast(ModelNode.State.ProjectionsDefined);
                    return link.getPromise().canBeViewedAsMutable(type);
                }
            });
        }

        @Override
        public int getLinkCount() {
            return this.links.size();
        }

        @Override
        public boolean hasLink(String name, ModelType<?> type) {
            ModelNodeInternal linked = this.getLink(name);
            if (linked == null) {
                return false;
            }
            linked.ensureAtLeast(ModelNode.State.ProjectionsDefined);
            return linked.getPromise().canBeViewedAsMutable(type);
        }

        @Override
        public void applyToSelf(ModelActionRole role, ModelAction action) {
            DefaultModelRegistry.checkNodePath(this, action);
            DefaultModelRegistry.this.bind(action.getSubject(), role, action, ModelPath.ROOT);
        }

        @Override
        public void applyToLink(ModelActionRole type, ModelAction action) {
            if (!this.getPath().isDirectChild(action.getSubject().getPath())) {
                throw new IllegalArgumentException(String.format("Linked element action reference has a path (%s) which is not a child of this node (%s).", action.getSubject().getPath(), this.getPath()));
            }
            DefaultModelRegistry.this.bind(action.getSubject(), type, action, ModelPath.ROOT);
        }

        @Override
        public void applyToLink(String name, Class<? extends RuleSource> rules) {
            this.apply(rules, this.getPath().child(name));
        }

        @Override
        public void applyToSelf(Class<? extends RuleSource> rules) {
            this.apply(rules, this.getPath());
        }

        @Override
        public void applyToLinks(final ModelType<?> type, final Class<? extends RuleSource> rules) {
            DefaultModelRegistry.this.registerListener(new ModelCreationListener(){

                @Override
                @Nullable
                public ModelPath getParent() {
                    return this.getPath();
                }

                @Override
                @Nullable
                public ModelType<?> getType() {
                    return type;
                }

                @Override
                public boolean onCreate(ModelNodeInternal node) {
                    node.applyToSelf(rules);
                    return false;
                }
            });
        }

        @Override
        public void applyToAllLinksTransitive(final ModelType<?> type, final Class<? extends RuleSource> rules) {
            DefaultModelRegistry.this.registerListener(new ModelCreationListener(){

                @Override
                public ModelPath getAncestor() {
                    return ModelElementNode.this.getPath();
                }

                @Override
                @Nullable
                public ModelType<?> getType() {
                    return type;
                }

                @Override
                public boolean onCreate(ModelNodeInternal node) {
                    node.applyToSelf(rules);
                    return false;
                }
            });
        }

        private void apply(Class<? extends RuleSource> rules, ModelPath scope) {
            Iterable<ExtractedModelRule> extractedRules = DefaultModelRegistry.this.ruleExtractor.extract(rules);
            for (ExtractedModelRule extractedRule : extractedRules) {
                if (!extractedRule.getRuleDependencies().isEmpty()) {
                    throw new IllegalStateException("Rule source " + rules + " cannot have plugin dependencies (introduced by rule " + extractedRule + ")");
                }
                extractedRule.apply(DefaultModelRegistry.this, scope);
            }
        }

        @Override
        public void applyToAllLinks(final ModelActionRole type, final ModelAction action) {
            if (action.getSubject().getPath() != null) {
                throw new IllegalArgumentException("Linked element action reference must have null path.");
            }
            DefaultModelRegistry.this.registerListener(new ModelCreationListener(){

                @Override
                public ModelPath getParent() {
                    return ModelElementNode.this.getPath();
                }

                @Override
                public ModelType<?> getType() {
                    return action.getSubject().getType();
                }

                @Override
                public boolean onCreate(ModelNodeInternal node) {
                    DefaultModelRegistry.this.bind(ModelReference.of(node.getPath(), action.getSubject().getType()), type, action, ModelPath.ROOT);
                    return false;
                }
            });
        }

        @Override
        public void applyToAllLinksTransitive(final ModelActionRole type, final ModelAction action) {
            if (action.getSubject().getPath() != null) {
                throw new IllegalArgumentException("Linked element action reference must have null path.");
            }
            DefaultModelRegistry.this.registerListener(new ModelCreationListener(){

                @Override
                public ModelPath getAncestor() {
                    return ModelElementNode.this.getPath();
                }

                @Override
                public ModelType<?> getType() {
                    return action.getSubject().getType();
                }

                @Override
                public boolean onCreate(ModelNodeInternal node) {
                    DefaultModelRegistry.this.bind(ModelReference.of(node.getPath(), action.getSubject().getType()), type, action, ModelPath.ROOT);
                    return false;
                }
            });
        }

        @Override
        public void addReference(ModelCreator creator) {
            this.addNode(new ModelReferenceNode(DefaultModelRegistry.this.toCreatorBinder(creator), this), creator);
        }

        @Override
        public void addLink(ModelCreator creator) {
            this.addNode(new ModelElementNode(DefaultModelRegistry.this.toCreatorBinder(creator), this), creator);
        }

        private void addNode(ModelNodeInternal child, ModelCreator creator) {
            ModelPath childPath = child.getPath();
            if (!this.getPath().isDirectChild(childPath)) {
                throw new IllegalArgumentException(String.format("Element creator has a path (%s) which is not a child of this node (%s).", childPath, this.getPath()));
            }
            if (DefaultModelRegistry.this.reset) {
                DefaultModelRegistry.this.registerNode(child);
                return;
            }
            ModelNodeInternal currentChild = this.links.get(childPath.getName());
            if (currentChild != null) {
                if (!currentChild.isAtLeast(ModelNode.State.Created)) {
                    throw new DuplicateModelException(String.format("Cannot create '%s' using creation rule '%s' as the rule '%s' is already registered to create this model element.", childPath, DefaultModelRegistry.describe(creator.getDescriptor()), DefaultModelRegistry.describe(currentChild.getDescriptor())));
                }
                throw new DuplicateModelException(String.format("Cannot create '%s' using creation rule '%s' as the rule '%s' has already been used to create this model element.", childPath, DefaultModelRegistry.describe(creator.getDescriptor()), DefaultModelRegistry.describe(currentChild.getDescriptor())));
            }
            if (!this.isMutable()) {
                throw new IllegalStateException(String.format("Cannot create '%s' using creation rule '%s' as model element '%s' is no longer mutable.", childPath, DefaultModelRegistry.describe(creator.getDescriptor()), this.getPath()));
            }
            this.links.put(child.getPath().getName(), child);
            DefaultModelRegistry.this.registerNode(child);
        }

        @Override
        public void removeLink(String name) {
            if (this.links.remove(name) != null) {
                DefaultModelRegistry.this.remove(this.getPath().child(name));
            }
        }

        @Override
        public void setTarget(ModelNode target) {
            throw new UnsupportedOperationException(String.format("This node (%s) is not a reference to another node.", this.getPath()));
        }

        @Override
        public void ensureUsable() {
            this.ensureAtLeast(ModelNode.State.Initialized);
        }

        @Override
        public void ensureAtLeast(ModelNode.State state) {
            DefaultModelRegistry.this.transition(this, state, true);
        }

        @Override
        public void addProjection(ModelProjection projection) {
            DefaultModelRegistry.this.transition(this, ModelNode.State.Known, false);
            this.getCreatorBinder().getCreator().addProjection(projection);
        }
    }
}

