/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.manage.schema.ScalarCollectionSchema;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionContext;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionStrategy;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class ScalarCollectionStrategy
implements ModelSchemaExtractionStrategy {
    public static final List<ModelType<?>> TYPES = ImmutableList.of(ModelType.of(List.class), ModelType.of(Set.class));

    @Override
    public <T> void extract(ModelSchemaExtractionContext<T> extractionContext, ModelSchemaStore store) {
        ModelType<T> type = extractionContext.getType();
        Class<T> rawClass = type.getRawClass();
        ModelType<T> rawCollectionType = ModelType.of(rawClass);
        if (TYPES.contains(rawCollectionType) && type.getTypeVariables().size() > 0) {
            ModelType<?> elementType = type.getTypeVariables().get(0);
            extractionContext.found(this.createSchema(type, elementType));
        }
    }

    private <T, E> ScalarCollectionSchema<T, E> createSchema(ModelType<T> type, ModelType<E> elementType) {
        return new ScalarCollectionSchema<T, E>(type, elementType);
    }
}

