/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import com.google.common.base.Equivalence;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import groovy.lang.GroovyObject;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Nullable;
import org.gradle.internal.reflect.MethodSignatureEquivalence;
import org.gradle.model.Managed;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelSchemaUtils {
    private static final Equivalence<Method> METHOD_EQUIVALENCE = new MethodSignatureEquivalence();
    private static final Set<Equivalence.Wrapper<Method>> IGNORED_METHODS = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)Iterables.concat(Arrays.asList(Object.class.getMethods()), Arrays.asList(GroovyObject.class.getMethods())), (Function)new Function<Method, Equivalence.Wrapper<Method>>(){

        public Equivalence.Wrapper<Method> apply(@Nullable Method input) {
            return METHOD_EQUIVALENCE.wrap((Object)input);
        }
    }));

    public static Multimap<String, Method> getCandidateMethods(Class<?> clazz) {
        final ImmutableListMultimap.Builder methodsBuilder = ImmutableListMultimap.builder();
        ModelSchemaUtils.walkTypeHierarchy(clazz, new TypeVisitor(){

            @Override
            public void visitType(Class<?> type) {
                for (Method method : type.getDeclaredMethods()) {
                    int modifiers = method.getModifiers();
                    if (method.isSynthetic() || Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers) || IGNORED_METHODS.contains(METHOD_EQUIVALENCE.wrap((Object)method))) continue;
                    methodsBuilder.put((Object)method.getName(), (Object)method);
                }
            }
        });
        return methodsBuilder.build();
    }

    public static void walkTypeHierarchy(Class<?> clazz, TypeVisitor visitor) {
        Class type;
        HashSet seenInterfaces = Sets.newHashSet();
        ArrayDeque queue = new ArrayDeque();
        queue.add(clazz);
        while ((type = (Class)queue.poll()) != null) {
            if (type.equals(Object.class) || type.equals(GroovyObject.class)) continue;
            visitor.visitType(type);
            Class superclass = type.getSuperclass();
            if (superclass != null) {
                queue.add(superclass);
            }
            for (Class<?> iface : type.getInterfaces()) {
                if (!seenInterfaces.add(iface)) continue;
                queue.add(iface);
            }
        }
    }

    public static Method findMostSpecificMethod(Iterable<Method> declaringMethods) {
        for (Method method : declaringMethods) {
            if (Proxy.isProxyClass(method.getDeclaringClass())) continue;
            return method;
        }
        throw new IllegalArgumentException("Cannot find most-specific declaration of method. Declarations checked: " + declaringMethods);
    }

    public static boolean isMethodDeclaredInManagedType(Iterable<Method> declarations) {
        Method mostSpecificDeclaration = ModelSchemaUtils.findMostSpecificMethod(declarations);
        return ModelSchemaUtils.isMethodDeclaredInManagedType(mostSpecificDeclaration);
    }

    public static boolean isMethodDeclaredInManagedType(Method method) {
        return method.getDeclaringClass().isAnnotationPresent(Managed.class);
    }

    @Nullable
    public static List<Method> getOverloadedMethods(Collection<Method> methods) {
        List deduped;
        if (methods.size() > 1 && (deduped = CollectionUtils.dedup(methods, METHOD_EQUIVALENCE)).size() > 1) {
            return deduped;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface TypeVisitor {
        public void visitType(Class<?> var1);
    }
}

