/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Map;
import org.gradle.model.internal.core.NodeInitializer;
import org.gradle.model.internal.core.NodeInitializerRegistry;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.extract.ConstructableTypesRegistry;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConstructableTypesRegistry
implements ConstructableTypesRegistry {
    private Map<ModelType<?>, NodeInitializer> mappings = Maps.newLinkedHashMap();

    @Override
    public <T> NodeInitializer extractNodeInitializer(ModelSchema<T> schema, NodeInitializerRegistry nodeInitializerRegistry) {
        return this.mappings.get(schema.getType());
    }

    @Override
    public Iterable<ModelType<?>> supportedTypes() {
        return ImmutableList.of();
    }

    @Override
    public <T> void registerConstructableType(ModelType<T> type, NodeInitializer nodeInitializer) {
        this.mappings.put(type, nodeInitializer);
    }
}

