/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.inspect;

import java.util.Collections;
import java.util.List;
import org.gradle.api.Named;
import org.gradle.api.Nullable;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelCreator;
import org.gradle.model.internal.core.ModelCreators;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelProjection;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NodeInitializer;
import org.gradle.model.internal.core.NodeInitializerRegistry;
import org.gradle.model.internal.core.ReadonlyImmutableManagedPropertyException;
import org.gradle.model.internal.core.UnmanagedModelProjection;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.inspect.UnmanagedPropertyMissingSetterException;
import org.gradle.model.internal.manage.instance.ManagedProxyFactory;
import org.gradle.model.internal.manage.projection.ManagedModelProjection;
import org.gradle.model.internal.manage.schema.ManagedImplModelSchema;
import org.gradle.model.internal.manage.schema.ModelCollectionSchema;
import org.gradle.model.internal.manage.schema.ModelManagedImplStructSchema;
import org.gradle.model.internal.manage.schema.ModelProperty;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.manage.schema.ModelValueSchema;
import org.gradle.model.internal.manage.schema.ScalarCollectionSchema;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedModelInitializer<T>
implements NodeInitializer {
    protected final ModelManagedImplStructSchema<T> modelSchema;
    protected final ModelSchemaStore schemaStore;
    protected final NodeInitializerRegistry nodeInitializerRegistry;

    public ManagedModelInitializer(ModelManagedImplStructSchema<T> modelSchema, ModelSchemaStore schemaStore, NodeInitializerRegistry nodeInitializerRegistry) {
        this.modelSchema = modelSchema;
        this.schemaStore = schemaStore;
        this.nodeInitializerRegistry = nodeInitializerRegistry;
    }

    @Override
    public List<? extends ModelReference<?>> getInputs() {
        return Collections.emptyList();
    }

    @Override
    public void execute(MutableModelNode modelNode, List<ModelView<?>> inputs) {
        ModelProperty<?> nameProperty;
        for (ModelProperty<?> property : this.modelSchema.getProperties()) {
            this.addPropertyLink(modelNode, property);
        }
        if (this.isANamedType() && (nameProperty = this.modelSchema.getProperty("name")) != null && nameProperty.getStateManagementType().equals((Object)ModelProperty.StateManagementType.MANAGED)) {
            MutableModelNode nameLink = modelNode.getLink("name");
            if (nameLink == null) {
                throw new IllegalStateException("expected name node for " + modelNode.getPath());
            }
            nameLink.setPrivateData(ModelType.of(String.class), modelNode.getPath().getName());
        }
    }

    @Override
    public List<? extends ModelProjection> getProjections() {
        return Collections.singletonList(new ManagedModelProjection<T>(this.modelSchema, this.schemaStore, this.nodeInitializerRegistry, ManagedProxyFactory.INSTANCE));
    }

    @Override
    @Nullable
    public ModelAction getProjector(ModelPath path, ModelRuleDescriptor descriptor, ModelType<?> typeToCreate) {
        return null;
    }

    private <P> void addPropertyLink(MutableModelNode modelNode, ModelProperty<P> property) {
        if (!property.getStateManagementType().equals((Object)ModelProperty.StateManagementType.MANAGED)) {
            return;
        }
        ModelType<P> propertyType = property.getType();
        ModelSchema<P> propertySchema = this.schemaStore.getSchema(propertyType);
        ModelRuleDescriptor descriptor = modelNode.getDescriptor();
        if (propertySchema instanceof ManagedImplModelSchema) {
            ModelCreator creator;
            ManagedImplModelSchema managedPropertySchema;
            if (propertySchema instanceof ModelCollectionSchema) {
                ModelCollectionSchema propertyCollectionsSchema = (ModelCollectionSchema)propertySchema;
                ModelType elementType = propertyCollectionsSchema.getElementType();
                if (!(propertySchema instanceof ScalarCollectionSchema) && !property.isWritable()) {
                    this.nodeInitializerRegistry.getNodeInitializer(elementType);
                }
            }
            if (!property.isWritable()) {
                if (property.isDeclaredAsHavingUnmanagedType()) {
                    throw new UnmanagedPropertyMissingSetterException(property);
                }
                managedPropertySchema = (ManagedImplModelSchema)propertySchema;
                creator = ModelCreators.of(modelNode.getPath().child(property.getName()), this.nodeInitializerRegistry.getNodeInitializer(managedPropertySchema)).descriptor(descriptor).build();
                modelNode.addLink(creator);
            } else if (propertySchema instanceof ScalarCollectionSchema) {
                managedPropertySchema = (ManagedImplModelSchema)propertySchema;
                creator = ModelCreators.of(modelNode.getPath().child(property.getName()), this.nodeInitializerRegistry.getNodeInitializer(managedPropertySchema)).descriptor(descriptor).build();
                modelNode.addLink(creator);
            } else {
                ModelManagedImplStructSchema structSchema = (ModelManagedImplStructSchema)propertySchema;
                ManagedModelProjection projection = new ManagedModelProjection(structSchema, this.schemaStore, this.nodeInitializerRegistry, ManagedProxyFactory.INSTANCE);
                ModelCreator creator2 = ModelCreators.of(modelNode.getPath().child(property.getName())).withProjection(projection).descriptor(descriptor).build();
                modelNode.addReference(creator2);
            }
        } else {
            UnmanagedModelProjection<P> projection = new UnmanagedModelProjection<P>(propertyType, true, true);
            ModelCreators.Builder creatorBuilder = ModelCreators.of(modelNode.getPath().child(property.getName())).withProjection(projection).descriptor(descriptor);
            if (this.shouldHaveANodeInitializer(property, propertySchema)) {
                creatorBuilder.action(ModelActionRole.Create, this.nodeInitializerRegistry.getNodeInitializer(propertyType));
            } else if (this.isAModelValueSchema(propertySchema) && !property.isWritable() && !this.isNamePropertyOfANamedType(property)) {
                throw new ReadonlyImmutableManagedPropertyException(this.modelSchema.getType(), property.getName(), property.getType());
            }
            modelNode.addLink(creatorBuilder.build());
        }
    }

    private <P> boolean isNamePropertyOfANamedType(ModelProperty<P> property) {
        return this.isANamedType() && "name".equals(property.getName());
    }

    public boolean isANamedType() {
        return Named.class.isAssignableFrom(this.modelSchema.getType().getRawClass());
    }

    private <P> boolean shouldHaveANodeInitializer(ModelProperty<P> property, ModelSchema<P> propertySchema) {
        return !this.isAModelValueSchema(propertySchema) && !property.isDeclaredAsHavingUnmanagedType();
    }

    private <P> boolean isAModelValueSchema(ModelSchema<P> propertySchema) {
        return propertySchema instanceof ModelValueSchema;
    }
}

