/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import org.gradle.internal.Cast;
import org.gradle.model.internal.core.InstanceFactory;
import org.gradle.model.internal.core.InstanceFactoryRegistry;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultInstanceFactoryRegistry
implements InstanceFactoryRegistry {
    private final Map<ModelType<?>, ModelReference<? extends InstanceFactory<?, String>>> factoryReferences = Maps.newLinkedHashMap();

    @Override
    public <T> ModelReference<InstanceFactory<? super T, String>> getFactory(ModelType<T> type) {
        return (ModelReference)Cast.uncheckedCast(this.factoryReferences.get(type));
    }

    @Override
    public <T> void register(ModelType<T> type, ModelReference<? extends InstanceFactory<? super T, String>> factoryReference) {
        this.factoryReferences.put(type, factoryReference);
    }

    @Override
    public Iterable<ModelType<?>> supportedTypes() {
        return ImmutableSet.of();
    }
}

